# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.payment_initiation_party_name_entity_3 import PaymentInitiationPartyNameEntity3


class PaymentInitiationPartySummaryEntity(object):

    """Implementation of the 'Payment Initiation Party Summary entity' model.

    Summary of a payment initiation party

    Attributes:
        payment_initiation_party_id (str): Unique identifier of a payment
            initiation party
        name (PaymentInitiationPartyNameEntity3): Details of the name
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_initiation_party_id": 'paymentInitiationPartyId',
        "name": 'name'
    }

    _optionals = [
        'payment_initiation_party_id',
        'name',
    ]

    def __init__(self,
                 payment_initiation_party_id=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentInitiationPartySummaryEntity class"""

        # Initialize members of the class
        if payment_initiation_party_id is not APIHelper.SKIP:
            self.payment_initiation_party_id = payment_initiation_party_id 
        if name is not APIHelper.SKIP:
            self.name = name 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_initiation_party_id = dictionary.get("paymentInitiationPartyId") if dictionary.get("paymentInitiationPartyId") else APIHelper.SKIP
        name = PaymentInitiationPartyNameEntity3.from_dictionary(dictionary.get('name')) if 'name' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(payment_initiation_party_id,
                   name,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'payment_initiation_party_id={(self.payment_initiation_party_id if hasattr(self, "payment_initiation_party_id") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'payment_initiation_party_id={(self.payment_initiation_party_id if hasattr(self, "payment_initiation_party_id") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
