# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PaymentMethodEntity2(object):

    """Implementation of the 'Payment Method entity2' model.

    Payment method details

    Attributes:
        payment_method_id (str): Unique identifier of the payment method
        external_local_instrument_1_code (str): Unique identifier code of the
            payment method rail as documented internally to the FI. This is
            aligned with ISO 20022 pain.001, transaction level
        external_clearing_system_identification_1_code (str): Unique
            identifier code of the external clearing system. This is aligned
            with ISO 20022 pacs.008 group level. It can be used to send the
            payment rail for the payment. ISO has already listed codes in the
            fields which indicates the payment rail like "ACH" for ACH, "ACS"
            for EFT Payments, "LVT" for Canada LVTS, "LYX" for Lynx Canada,
            etc.
        external_clearing_system_identification_1_proprietary (str): For few
            examples where the payment rail is not part of the ISO 20022 scope
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_method_id": 'paymentMethodId',
        "external_local_instrument_1_code": 'externalLocalInstrument1Code',
        "external_clearing_system_identification_1_code": 'externalClearingSystemIdentification1Code',
        "external_clearing_system_identification_1_proprietary": 'externalClearingSystemIdentification1Proprietary'
    }

    _optionals = [
        'payment_method_id',
        'external_local_instrument_1_code',
        'external_clearing_system_identification_1_code',
        'external_clearing_system_identification_1_proprietary',
    ]

    def __init__(self,
                 payment_method_id=APIHelper.SKIP,
                 external_local_instrument_1_code=APIHelper.SKIP,
                 external_clearing_system_identification_1_code=APIHelper.SKIP,
                 external_clearing_system_identification_1_proprietary=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentMethodEntity2 class"""

        # Initialize members of the class
        if payment_method_id is not APIHelper.SKIP:
            self.payment_method_id = payment_method_id 
        if external_local_instrument_1_code is not APIHelper.SKIP:
            self.external_local_instrument_1_code = external_local_instrument_1_code 
        if external_clearing_system_identification_1_code is not APIHelper.SKIP:
            self.external_clearing_system_identification_1_code = external_clearing_system_identification_1_code 
        if external_clearing_system_identification_1_proprietary is not APIHelper.SKIP:
            self.external_clearing_system_identification_1_proprietary = external_clearing_system_identification_1_proprietary 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_method_id = dictionary.get("paymentMethodId") if dictionary.get("paymentMethodId") else APIHelper.SKIP
        external_local_instrument_1_code = dictionary.get("externalLocalInstrument1Code") if dictionary.get("externalLocalInstrument1Code") else APIHelper.SKIP
        external_clearing_system_identification_1_code = dictionary.get("externalClearingSystemIdentification1Code") if dictionary.get("externalClearingSystemIdentification1Code") else APIHelper.SKIP
        external_clearing_system_identification_1_proprietary = dictionary.get("externalClearingSystemIdentification1Proprietary") if dictionary.get("externalClearingSystemIdentification1Proprietary") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(payment_method_id,
                   external_local_instrument_1_code,
                   external_clearing_system_identification_1_code,
                   external_clearing_system_identification_1_proprietary,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'payment_method_id={(self.payment_method_id if hasattr(self, "payment_method_id") else None)!r}, '
                f'external_local_instrument_1_code={(self.external_local_instrument_1_code if hasattr(self, "external_local_instrument_1_code") else None)!r}, '
                f'external_clearing_system_identification_1_code={(self.external_clearing_system_identification_1_code if hasattr(self, "external_clearing_system_identification_1_code") else None)!r}, '
                f'external_clearing_system_identification_1_proprietary={(self.external_clearing_system_identification_1_proprietary if hasattr(self, "external_clearing_system_identification_1_proprietary") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'payment_method_id={(self.payment_method_id if hasattr(self, "payment_method_id") else None)!s}, '
                f'external_local_instrument_1_code={(self.external_local_instrument_1_code if hasattr(self, "external_local_instrument_1_code") else None)!s}, '
                f'external_clearing_system_identification_1_code={(self.external_clearing_system_identification_1_code if hasattr(self, "external_clearing_system_identification_1_code") else None)!s}, '
                f'external_clearing_system_identification_1_proprietary={(self.external_clearing_system_identification_1_proprietary if hasattr(self, "external_clearing_system_identification_1_proprietary") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
