# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PaymentMethodSystemCode(object):

    """Implementation of the 'Payment Method System Code' model.

    Unique identifier code of the external clearing system. Aligned with ISO
    20022 pacs.008 group level

    Attributes:
        external_clearing_system_identification_1_code (str): Unique
            identifier code of the external clearing system. This is aligned
            with ISO 20022 pacs.008 group level. It can be used to send the
            payment rail for the payment. ISO has already listed codes in the
            fields which indicates the payment rail like "ACH" for ACH, "ACS"
            for EFT Payments, "LVT" for Canada LVTS, "LYX" for Lynx Canada,
            etc.
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "external_clearing_system_identification_1_code": 'externalClearingSystemIdentification1Code'
    }

    _optionals = [
        'external_clearing_system_identification_1_code',
    ]

    def __init__(self,
                 external_clearing_system_identification_1_code=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentMethodSystemCode class"""

        # Initialize members of the class
        if external_clearing_system_identification_1_code is not APIHelper.SKIP:
            self.external_clearing_system_identification_1_code = external_clearing_system_identification_1_code 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        external_clearing_system_identification_1_code = dictionary.get("externalClearingSystemIdentification1Code") if dictionary.get("externalClearingSystemIdentification1Code") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(external_clearing_system_identification_1_code,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'external_clearing_system_identification_1_code={(self.external_clearing_system_identification_1_code if hasattr(self, "external_clearing_system_identification_1_code") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'external_clearing_system_identification_1_code={(self.external_clearing_system_identification_1_code if hasattr(self, "external_clearing_system_identification_1_code") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
