# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.page_metadata import PageMetadata
from fdxapi.models.page_metadata_links import PageMetadataLinks
from fdxapi.models.recipient_record_at_ecosystem_registry import RecipientRecordAtEcosystemRegistry


class RecipientRecordsAtEcosystemRegistry(object):

    """Implementation of the 'Recipient records at ecosystem registry' model.

    Recipient records at Ecosystem Registry. Properties in this structure use
    'snake_case' names to match the properties in [IETF RFC
    7591](https://datatracker.ietf.org/doc/rfc7591/).

    Attributes:
        page (PageMetadata): Offset IDs for navigating result sets
        links (PageMetadataLinks): Resource URLs for navigating result sets
        recipients (List[RecipientRecordAtEcosystemRegistry]): Recipients
            retrieved by the operation
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "recipients": 'recipients',
        "page": 'page',
        "links": 'links'
    }

    _optionals = [
        'page',
        'links',
    ]

    def __init__(self,
                 recipients=None,
                 page=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RecipientRecordsAtEcosystemRegistry class"""

        # Initialize members of the class
        if page is not APIHelper.SKIP:
            self.page = page 
        if links is not APIHelper.SKIP:
            self.links = links 
        self.recipients = recipients 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        recipients = None
        if dictionary.get('recipients') is not None:
            recipients = [RecipientRecordAtEcosystemRegistry.from_dictionary(x) for x in dictionary.get('recipients')]
        page = PageMetadata.from_dictionary(dictionary.get('page')) if 'page' in dictionary.keys() else APIHelper.SKIP
        links = PageMetadataLinks.from_dictionary(dictionary.get('links')) if 'links' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(recipients,
                   page,
                   links,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'recipients={self.recipients!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'recipients={self.recipients!s}, '
                f'additional_properties={self.additional_properties!s})')
