# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.intermediary import Intermediary
from fdxapi.models.registry_reference import RegistryReference


class RecipientRequest(object):

    """Implementation of the 'Recipient Request' model.

    Used to request a recipient registration. Properties in this structure use
    'snake_case' names to match the properties in [IETF RFC
    7591](https://datatracker.ietf.org/doc/rfc7591/)

    Attributes:
        client_name (str): The Data Recipient or Data Recipient Application
            name displayed by Data Provider during the consent Flow as well as
            in the Consent Dashboard
        description (str): A short description of the Data Recipient
            application
        redirect_uris (List[str]): An array of eligible Redirect URI targets
        logo_uri (str): Data Recipient Logo URL location
        client_uri (str): The URI which provides additional information about
            the Data Recipient
        contacts (List[str]): Array of strings representing ways to contact
            individuals responsible for the Data Recipient application
        scope (str): String form field with a list of data clusters
        duration_type (List[ConsentDurationType]): The duration of consent for
            the Data Recipient consumers
        duration_period (int): The maximum consent duration in days for
            duration_type TIME_BOUND for the Data Recipient, effective from
            the date of consent
        lookback_period (int): The maximum number of days allowed for Data
            Recipient to obtain in transaction history, effective from the
            current date
        registry_references (List[RegistryReference]): An array of external
            registries containing registered entity name, registered entity id
            and registry fields for the registries where the data recipient is
            registered
        intermediaries (List[Intermediary]): An array of the intermediaries
            for this data recipient
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "client_name": 'client_name',
        "redirect_uris": 'redirect_uris',
        "description": 'description',
        "logo_uri": 'logo_uri',
        "client_uri": 'client_uri',
        "contacts": 'contacts',
        "scope": 'scope',
        "duration_type": 'duration_type',
        "duration_period": 'duration_period',
        "lookback_period": 'lookback_period',
        "registry_references": 'registry_references',
        "intermediaries": 'intermediaries'
    }

    _optionals = [
        'description',
        'logo_uri',
        'client_uri',
        'contacts',
        'scope',
        'duration_type',
        'duration_period',
        'lookback_period',
        'registry_references',
        'intermediaries',
    ]

    def __init__(self,
                 client_name=None,
                 redirect_uris=None,
                 description=APIHelper.SKIP,
                 logo_uri=APIHelper.SKIP,
                 client_uri=APIHelper.SKIP,
                 contacts=APIHelper.SKIP,
                 scope=APIHelper.SKIP,
                 duration_type=APIHelper.SKIP,
                 duration_period=APIHelper.SKIP,
                 lookback_period=APIHelper.SKIP,
                 registry_references=APIHelper.SKIP,
                 intermediaries=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RecipientRequest class"""

        # Initialize members of the class
        self.client_name = client_name 
        if description is not APIHelper.SKIP:
            self.description = description 
        self.redirect_uris = redirect_uris 
        if logo_uri is not APIHelper.SKIP:
            self.logo_uri = logo_uri 
        if client_uri is not APIHelper.SKIP:
            self.client_uri = client_uri 
        if contacts is not APIHelper.SKIP:
            self.contacts = contacts 
        if scope is not APIHelper.SKIP:
            self.scope = scope 
        if duration_type is not APIHelper.SKIP:
            self.duration_type = duration_type 
        if duration_period is not APIHelper.SKIP:
            self.duration_period = duration_period 
        if lookback_period is not APIHelper.SKIP:
            self.lookback_period = lookback_period 
        if registry_references is not APIHelper.SKIP:
            self.registry_references = registry_references 
        if intermediaries is not APIHelper.SKIP:
            self.intermediaries = intermediaries 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        client_name = dictionary.get("client_name") if dictionary.get("client_name") else None
        redirect_uris = dictionary.get("redirect_uris") if dictionary.get("redirect_uris") else None
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        logo_uri = dictionary.get("logo_uri") if dictionary.get("logo_uri") else APIHelper.SKIP
        client_uri = dictionary.get("client_uri") if dictionary.get("client_uri") else APIHelper.SKIP
        contacts = dictionary.get("contacts") if dictionary.get("contacts") else APIHelper.SKIP
        scope = dictionary.get("scope") if dictionary.get("scope") else APIHelper.SKIP
        duration_type = dictionary.get("duration_type") if dictionary.get("duration_type") else APIHelper.SKIP
        duration_period = dictionary.get("duration_period") if dictionary.get("duration_period") else APIHelper.SKIP
        lookback_period = dictionary.get("lookback_period") if dictionary.get("lookback_period") else APIHelper.SKIP
        registry_references = None
        if dictionary.get('registry_references') is not None:
            registry_references = [RegistryReference.from_dictionary(x) for x in dictionary.get('registry_references')]
        else:
            registry_references = APIHelper.SKIP
        intermediaries = None
        if dictionary.get('intermediaries') is not None:
            intermediaries = [Intermediary.from_dictionary(x) for x in dictionary.get('intermediaries')]
        else:
            intermediaries = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(client_name,
                   redirect_uris,
                   description,
                   logo_uri,
                   client_uri,
                   contacts,
                   scope,
                   duration_type,
                   duration_period,
                   lookback_period,
                   registry_references,
                   intermediaries,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'client_name={self.client_name!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'redirect_uris={self.redirect_uris!r}, '
                f'logo_uri={(self.logo_uri if hasattr(self, "logo_uri") else None)!r}, '
                f'client_uri={(self.client_uri if hasattr(self, "client_uri") else None)!r}, '
                f'contacts={(self.contacts if hasattr(self, "contacts") else None)!r}, '
                f'scope={(self.scope if hasattr(self, "scope") else None)!r}, '
                f'duration_type={(self.duration_type if hasattr(self, "duration_type") else None)!r}, '
                f'duration_period={(self.duration_period if hasattr(self, "duration_period") else None)!r}, '
                f'lookback_period={(self.lookback_period if hasattr(self, "lookback_period") else None)!r}, '
                f'registry_references={(self.registry_references if hasattr(self, "registry_references") else None)!r}, '
                f'intermediaries={(self.intermediaries if hasattr(self, "intermediaries") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'client_name={self.client_name!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'redirect_uris={self.redirect_uris!s}, '
                f'logo_uri={(self.logo_uri if hasattr(self, "logo_uri") else None)!s}, '
                f'client_uri={(self.client_uri if hasattr(self, "client_uri") else None)!s}, '
                f'contacts={(self.contacts if hasattr(self, "contacts") else None)!s}, '
                f'scope={(self.scope if hasattr(self, "scope") else None)!s}, '
                f'duration_type={(self.duration_type if hasattr(self, "duration_type") else None)!s}, '
                f'duration_period={(self.duration_period if hasattr(self, "duration_period") else None)!s}, '
                f'lookback_period={(self.lookback_period if hasattr(self, "lookback_period") else None)!s}, '
                f'registry_references={(self.registry_references if hasattr(self, "registry_references") else None)!s}, '
                f'intermediaries={(self.intermediaries if hasattr(self, "intermediaries") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
