# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.recurring_payment_duration_entity_2 import RecurringPaymentDurationEntity2


class RecurringPaymentEntity(object):

    """Implementation of the 'Recurring Payment entity' model.

    A recurring payment. Financial institution is free to adjust the payment
    date to accommodate weekends and holidays

    Attributes:
        frequency (RecurringPaymentFrequency2): Defines how often the payment
            repeats
        duration (RecurringPaymentDurationEntity2): Defines how long the
            payment repeats for
        from_account_id (str): ID of the account used to source funds for
            payment
        to_payee_id (str): ID of the payee to receive funds for the payment
        amount (float): Amount for the payment. Must be positive
        merchant_account_id (str): User's account identifier with the merchant
        due_date (date): Date that the funds are scheduled to be delivered
        recurring_payment_id (str): Uniquely identifies a recurring payment.
            Used within the API to reference a recurring payment
        scheduled_timestamp (datetime): When the recurring payment was
            scheduled
        cancelled_timestamp (datetime): When the recurring payment was
            cancelled
        processed_timestamp (datetime): When the last payment executed
        failed_timestamp (datetime): When the recurring payment failed
        status (RecurringPaymentStatus2): Defines the status of the recurring
            payment
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "frequency": 'frequency',
        "from_account_id": 'fromAccountId',
        "to_payee_id": 'toPayeeId',
        "amount": 'amount',
        "due_date": 'dueDate',
        "status": 'status',
        "duration": 'duration',
        "merchant_account_id": 'merchantAccountId',
        "recurring_payment_id": 'recurringPaymentId',
        "scheduled_timestamp": 'scheduledTimestamp',
        "cancelled_timestamp": 'cancelledTimestamp',
        "processed_timestamp": 'processedTimestamp',
        "failed_timestamp": 'failedTimestamp'
    }

    _optionals = [
        'duration',
        'merchant_account_id',
        'recurring_payment_id',
        'scheduled_timestamp',
        'cancelled_timestamp',
        'processed_timestamp',
        'failed_timestamp',
    ]

    def __init__(self,
                 frequency=None,
                 from_account_id=None,
                 to_payee_id=None,
                 amount=None,
                 due_date=None,
                 status=None,
                 duration=APIHelper.SKIP,
                 merchant_account_id=APIHelper.SKIP,
                 recurring_payment_id=APIHelper.SKIP,
                 scheduled_timestamp=APIHelper.SKIP,
                 cancelled_timestamp=APIHelper.SKIP,
                 processed_timestamp=APIHelper.SKIP,
                 failed_timestamp=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RecurringPaymentEntity class"""

        # Initialize members of the class
        self.frequency = frequency 
        if duration is not APIHelper.SKIP:
            self.duration = duration 
        self.from_account_id = from_account_id 
        self.to_payee_id = to_payee_id 
        self.amount = amount 
        if merchant_account_id is not APIHelper.SKIP:
            self.merchant_account_id = merchant_account_id 
        self.due_date = due_date 
        if recurring_payment_id is not APIHelper.SKIP:
            self.recurring_payment_id = recurring_payment_id 
        if scheduled_timestamp is not APIHelper.SKIP:
            self.scheduled_timestamp = APIHelper.apply_datetime_converter(scheduled_timestamp, APIHelper.RFC3339DateTime) if scheduled_timestamp else None 
        if cancelled_timestamp is not APIHelper.SKIP:
            self.cancelled_timestamp = APIHelper.apply_datetime_converter(cancelled_timestamp, APIHelper.RFC3339DateTime) if cancelled_timestamp else None 
        if processed_timestamp is not APIHelper.SKIP:
            self.processed_timestamp = APIHelper.apply_datetime_converter(processed_timestamp, APIHelper.RFC3339DateTime) if processed_timestamp else None 
        if failed_timestamp is not APIHelper.SKIP:
            self.failed_timestamp = APIHelper.apply_datetime_converter(failed_timestamp, APIHelper.RFC3339DateTime) if failed_timestamp else None 
        self.status = status 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        frequency = dictionary.get("frequency") if dictionary.get("frequency") else None
        from_account_id = dictionary.get("fromAccountId") if dictionary.get("fromAccountId") else None
        to_payee_id = dictionary.get("toPayeeId") if dictionary.get("toPayeeId") else None
        amount = dictionary.get("amount") if dictionary.get("amount") else None
        due_date = dateutil.parser.parse(dictionary.get('dueDate')).date() if dictionary.get('dueDate') else None
        status = dictionary.get("status") if dictionary.get("status") else None
        duration = RecurringPaymentDurationEntity2.from_dictionary(dictionary.get('duration')) if 'duration' in dictionary.keys() else APIHelper.SKIP
        merchant_account_id = dictionary.get("merchantAccountId") if dictionary.get("merchantAccountId") else APIHelper.SKIP
        recurring_payment_id = dictionary.get("recurringPaymentId") if dictionary.get("recurringPaymentId") else APIHelper.SKIP
        scheduled_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("scheduledTimestamp")).datetime if dictionary.get("scheduledTimestamp") else APIHelper.SKIP
        cancelled_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("cancelledTimestamp")).datetime if dictionary.get("cancelledTimestamp") else APIHelper.SKIP
        processed_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("processedTimestamp")).datetime if dictionary.get("processedTimestamp") else APIHelper.SKIP
        failed_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("failedTimestamp")).datetime if dictionary.get("failedTimestamp") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(frequency,
                   from_account_id,
                   to_payee_id,
                   amount,
                   due_date,
                   status,
                   duration,
                   merchant_account_id,
                   recurring_payment_id,
                   scheduled_timestamp,
                   cancelled_timestamp,
                   processed_timestamp,
                   failed_timestamp,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'frequency={self.frequency!r}, '
                f'duration={(self.duration if hasattr(self, "duration") else None)!r}, '
                f'from_account_id={self.from_account_id!r}, '
                f'to_payee_id={self.to_payee_id!r}, '
                f'amount={self.amount!r}, '
                f'merchant_account_id={(self.merchant_account_id if hasattr(self, "merchant_account_id") else None)!r}, '
                f'due_date={self.due_date!r}, '
                f'recurring_payment_id={(self.recurring_payment_id if hasattr(self, "recurring_payment_id") else None)!r}, '
                f'scheduled_timestamp={(self.scheduled_timestamp if hasattr(self, "scheduled_timestamp") else None)!r}, '
                f'cancelled_timestamp={(self.cancelled_timestamp if hasattr(self, "cancelled_timestamp") else None)!r}, '
                f'processed_timestamp={(self.processed_timestamp if hasattr(self, "processed_timestamp") else None)!r}, '
                f'failed_timestamp={(self.failed_timestamp if hasattr(self, "failed_timestamp") else None)!r}, '
                f'status={self.status!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'frequency={self.frequency!s}, '
                f'duration={(self.duration if hasattr(self, "duration") else None)!s}, '
                f'from_account_id={self.from_account_id!s}, '
                f'to_payee_id={self.to_payee_id!s}, '
                f'amount={self.amount!s}, '
                f'merchant_account_id={(self.merchant_account_id if hasattr(self, "merchant_account_id") else None)!s}, '
                f'due_date={self.due_date!s}, '
                f'recurring_payment_id={(self.recurring_payment_id if hasattr(self, "recurring_payment_id") else None)!s}, '
                f'scheduled_timestamp={(self.scheduled_timestamp if hasattr(self, "scheduled_timestamp") else None)!s}, '
                f'cancelled_timestamp={(self.cancelled_timestamp if hasattr(self, "cancelled_timestamp") else None)!s}, '
                f'processed_timestamp={(self.processed_timestamp if hasattr(self, "processed_timestamp") else None)!s}, '
                f'failed_timestamp={(self.failed_timestamp if hasattr(self, "failed_timestamp") else None)!s}, '
                f'status={self.status!s}, '
                f'additional_properties={self.additional_properties!s})')
