# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.fi_attribute_entity import FiAttributeEntity


class RewardCategoryEntity(object):

    """Implementation of the 'Reward Category entity' model.

    Reward category used to calculate rewards on a transaction

    Attributes:
        reward_program_id (str): Long term persistent identity of the reward
            program
        category_name (str): Reward category name
        category_id (str): Long term persistent identity of the reward category
        multiplier (float): Factor used to calculate rewards accrued
        description (str): Description of the reward category
        fi_attributes (List[FiAttributeEntity]): Array of FI-specific
            attributes
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "reward_program_id": 'rewardProgramId',
        "category_name": 'categoryName',
        "category_id": 'categoryId',
        "multiplier": 'multiplier',
        "description": 'description',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'reward_program_id',
        'category_name',
        'category_id',
        'multiplier',
        'description',
        'fi_attributes',
    ]

    def __init__(self,
                 reward_program_id=APIHelper.SKIP,
                 category_name=APIHelper.SKIP,
                 category_id=APIHelper.SKIP,
                 multiplier=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RewardCategoryEntity class"""

        # Initialize members of the class
        if reward_program_id is not APIHelper.SKIP:
            self.reward_program_id = reward_program_id 
        if category_name is not APIHelper.SKIP:
            self.category_name = category_name 
        if category_id is not APIHelper.SKIP:
            self.category_id = category_id 
        if multiplier is not APIHelper.SKIP:
            self.multiplier = multiplier 
        if description is not APIHelper.SKIP:
            self.description = description 
        if fi_attributes is not APIHelper.SKIP:
            self.fi_attributes = fi_attributes 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        category_name = dictionary.get("categoryName") if dictionary.get("categoryName") else APIHelper.SKIP
        category_id = dictionary.get("categoryId") if dictionary.get("categoryId") else APIHelper.SKIP
        multiplier = dictionary.get("multiplier") if dictionary.get("multiplier") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(reward_program_id,
                   category_name,
                   category_id,
                   multiplier,
                   description,
                   fi_attributes,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'reward_program_id={(self.reward_program_id if hasattr(self, "reward_program_id") else None)!r}, '
                f'category_name={(self.category_name if hasattr(self, "category_name") else None)!r}, '
                f'category_id={(self.category_id if hasattr(self, "category_id") else None)!r}, '
                f'multiplier={(self.multiplier if hasattr(self, "multiplier") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'reward_program_id={(self.reward_program_id if hasattr(self, "reward_program_id") else None)!s}, '
                f'category_name={(self.category_name if hasattr(self, "category_name") else None)!s}, '
                f'category_id={(self.category_id if hasattr(self, "category_id") else None)!s}, '
                f'multiplier={(self.multiplier if hasattr(self, "multiplier") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
