# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.code_and_amount import CodeAndAmount
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding


class SecurityDetailIrsForm1099B(object):

    """Implementation of the 'Security Detail, IRS Form 1099-B' model.

    Tax information for a single security transaction

    Attributes:
        checkbox_on_form_8949 (str): Applicable checkbox on Form 8949
        security_name (str): Security name
        number_of_shares (float): Number of shares
        sale_description (str): Box 1a, Description of property
        date_acquired (date): Box 1b, Date acquired
        various_dates_acquired (bool): Box 1b, Date acquired Various
        date_of_sale (date): Box 1c, Date sold or disposed
        sales_price (float): Box 1d, Proceeds (not price per share)
        accrued_market_discount (float): Box 1f, Accrued market discount
        adjustment_codes (List[CodeAndAmount]): Other adjustments (code and
            amount)
        cost_basis (float): Box 1e, Cost or other basis
        corrected_cost_basis (float): Corrected cost basis. May be supplied in
            lieu of adjustmentCode code B. If both adjustmentCodes and
            correctedCostBasis are supplied, costBasis plus adjustmentCode B
            should equal correctedCostBasis
        wash_sale_loss_disallowed (float): Box 1g, Wash sale loss disallowed
        long_or_short (PositionType): Box 2, LONG or SHORT
        ordinary (bool): Box 2, Ordinary
        collectible (bool): Box 3, Collectibles
        qof (bool): Box 3, Qualified Opportunity Fund (QOF)
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        noncovered_security (bool): Box 5, Noncovered security
        gross_or_net (SaleProceedsType2): Box 6, Reported to IRS: GROSS or NET
        loss_not_allowed (bool): Box 7, Loss not allowed based on proceeds
        basis_reported (bool): Box 12, Basis reported to IRS
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 14-16,
            State and Local tax withholding
        cusip (str): CUSIP number
        foreign_account_tax_compliance (bool): Foreign account tax compliance
        expired_option (ExpiredOptionType2): To indicate gain or loss resulted
            from option expiration. If salesPrice (1d, proceeds) is zero, use
            PURCHASED. If costBasis (1e) is zero, use GRANTED
        investment_sale_type (InvestmentSaleType): Type of investment sale
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "checkbox_on_form_8949": 'checkboxOnForm8949',
        "security_name": 'securityName',
        "number_of_shares": 'numberOfShares',
        "sale_description": 'saleDescription',
        "date_acquired": 'dateAcquired',
        "various_dates_acquired": 'variousDatesAcquired',
        "date_of_sale": 'dateOfSale',
        "sales_price": 'salesPrice',
        "accrued_market_discount": 'accruedMarketDiscount',
        "adjustment_codes": 'adjustmentCodes',
        "cost_basis": 'costBasis',
        "corrected_cost_basis": 'correctedCostBasis',
        "wash_sale_loss_disallowed": 'washSaleLossDisallowed',
        "long_or_short": 'longOrShort',
        "ordinary": 'ordinary',
        "collectible": 'collectible',
        "qof": 'qof',
        "federal_tax_withheld": 'federalTaxWithheld',
        "noncovered_security": 'noncoveredSecurity',
        "gross_or_net": 'grossOrNet',
        "loss_not_allowed": 'lossNotAllowed',
        "basis_reported": 'basisReported',
        "state_and_local": 'stateAndLocal',
        "cusip": 'cusip',
        "foreign_account_tax_compliance": 'foreignAccountTaxCompliance',
        "expired_option": 'expiredOption',
        "investment_sale_type": 'investmentSaleType'
    }

    _optionals = [
        'checkbox_on_form_8949',
        'security_name',
        'number_of_shares',
        'sale_description',
        'date_acquired',
        'various_dates_acquired',
        'date_of_sale',
        'sales_price',
        'accrued_market_discount',
        'adjustment_codes',
        'cost_basis',
        'corrected_cost_basis',
        'wash_sale_loss_disallowed',
        'long_or_short',
        'ordinary',
        'collectible',
        'qof',
        'federal_tax_withheld',
        'noncovered_security',
        'gross_or_net',
        'loss_not_allowed',
        'basis_reported',
        'state_and_local',
        'cusip',
        'foreign_account_tax_compliance',
        'expired_option',
        'investment_sale_type',
    ]

    def __init__(self,
                 checkbox_on_form_8949=APIHelper.SKIP,
                 security_name=APIHelper.SKIP,
                 number_of_shares=APIHelper.SKIP,
                 sale_description=APIHelper.SKIP,
                 date_acquired=APIHelper.SKIP,
                 various_dates_acquired=APIHelper.SKIP,
                 date_of_sale=APIHelper.SKIP,
                 sales_price=APIHelper.SKIP,
                 accrued_market_discount=APIHelper.SKIP,
                 adjustment_codes=APIHelper.SKIP,
                 cost_basis=APIHelper.SKIP,
                 corrected_cost_basis=APIHelper.SKIP,
                 wash_sale_loss_disallowed=APIHelper.SKIP,
                 long_or_short=APIHelper.SKIP,
                 ordinary=APIHelper.SKIP,
                 collectible=APIHelper.SKIP,
                 qof=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 noncovered_security=APIHelper.SKIP,
                 gross_or_net=APIHelper.SKIP,
                 loss_not_allowed=APIHelper.SKIP,
                 basis_reported=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 cusip=APIHelper.SKIP,
                 foreign_account_tax_compliance=APIHelper.SKIP,
                 expired_option=APIHelper.SKIP,
                 investment_sale_type=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the SecurityDetailIrsForm1099B class"""

        # Initialize members of the class
        if checkbox_on_form_8949 is not APIHelper.SKIP:
            self.checkbox_on_form_8949 = checkbox_on_form_8949 
        if security_name is not APIHelper.SKIP:
            self.security_name = security_name 
        if number_of_shares is not APIHelper.SKIP:
            self.number_of_shares = number_of_shares 
        if sale_description is not APIHelper.SKIP:
            self.sale_description = sale_description 
        if date_acquired is not APIHelper.SKIP:
            self.date_acquired = date_acquired 
        if various_dates_acquired is not APIHelper.SKIP:
            self.various_dates_acquired = various_dates_acquired 
        if date_of_sale is not APIHelper.SKIP:
            self.date_of_sale = date_of_sale 
        if sales_price is not APIHelper.SKIP:
            self.sales_price = sales_price 
        if accrued_market_discount is not APIHelper.SKIP:
            self.accrued_market_discount = accrued_market_discount 
        if adjustment_codes is not APIHelper.SKIP:
            self.adjustment_codes = adjustment_codes 
        if cost_basis is not APIHelper.SKIP:
            self.cost_basis = cost_basis 
        if corrected_cost_basis is not APIHelper.SKIP:
            self.corrected_cost_basis = corrected_cost_basis 
        if wash_sale_loss_disallowed is not APIHelper.SKIP:
            self.wash_sale_loss_disallowed = wash_sale_loss_disallowed 
        if long_or_short is not APIHelper.SKIP:
            self.long_or_short = long_or_short 
        if ordinary is not APIHelper.SKIP:
            self.ordinary = ordinary 
        if collectible is not APIHelper.SKIP:
            self.collectible = collectible 
        if qof is not APIHelper.SKIP:
            self.qof = qof 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if noncovered_security is not APIHelper.SKIP:
            self.noncovered_security = noncovered_security 
        if gross_or_net is not APIHelper.SKIP:
            self.gross_or_net = gross_or_net 
        if loss_not_allowed is not APIHelper.SKIP:
            self.loss_not_allowed = loss_not_allowed 
        if basis_reported is not APIHelper.SKIP:
            self.basis_reported = basis_reported 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 
        if cusip is not APIHelper.SKIP:
            self.cusip = cusip 
        if foreign_account_tax_compliance is not APIHelper.SKIP:
            self.foreign_account_tax_compliance = foreign_account_tax_compliance 
        if expired_option is not APIHelper.SKIP:
            self.expired_option = expired_option 
        if investment_sale_type is not APIHelper.SKIP:
            self.investment_sale_type = investment_sale_type 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        checkbox_on_form_8949 = dictionary.get("checkboxOnForm8949") if dictionary.get("checkboxOnForm8949") else APIHelper.SKIP
        security_name = dictionary.get("securityName") if dictionary.get("securityName") else APIHelper.SKIP
        number_of_shares = dictionary.get("numberOfShares") if dictionary.get("numberOfShares") else APIHelper.SKIP
        sale_description = dictionary.get("saleDescription") if dictionary.get("saleDescription") else APIHelper.SKIP
        date_acquired = dateutil.parser.parse(dictionary.get('dateAcquired')).date() if dictionary.get('dateAcquired') else APIHelper.SKIP
        various_dates_acquired = dictionary.get("variousDatesAcquired") if "variousDatesAcquired" in dictionary.keys() else APIHelper.SKIP
        date_of_sale = dateutil.parser.parse(dictionary.get('dateOfSale')).date() if dictionary.get('dateOfSale') else APIHelper.SKIP
        sales_price = dictionary.get("salesPrice") if dictionary.get("salesPrice") else APIHelper.SKIP
        accrued_market_discount = dictionary.get("accruedMarketDiscount") if dictionary.get("accruedMarketDiscount") else APIHelper.SKIP
        adjustment_codes = None
        if dictionary.get('adjustmentCodes') is not None:
            adjustment_codes = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('adjustmentCodes')]
        else:
            adjustment_codes = APIHelper.SKIP
        cost_basis = dictionary.get("costBasis") if dictionary.get("costBasis") else APIHelper.SKIP
        corrected_cost_basis = dictionary.get("correctedCostBasis") if dictionary.get("correctedCostBasis") else APIHelper.SKIP
        wash_sale_loss_disallowed = dictionary.get("washSaleLossDisallowed") if dictionary.get("washSaleLossDisallowed") else APIHelper.SKIP
        long_or_short = dictionary.get("longOrShort") if dictionary.get("longOrShort") else APIHelper.SKIP
        ordinary = dictionary.get("ordinary") if "ordinary" in dictionary.keys() else APIHelper.SKIP
        collectible = dictionary.get("collectible") if "collectible" in dictionary.keys() else APIHelper.SKIP
        qof = dictionary.get("qof") if "qof" in dictionary.keys() else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        noncovered_security = dictionary.get("noncoveredSecurity") if "noncoveredSecurity" in dictionary.keys() else APIHelper.SKIP
        gross_or_net = dictionary.get("grossOrNet") if dictionary.get("grossOrNet") else APIHelper.SKIP
        loss_not_allowed = dictionary.get("lossNotAllowed") if "lossNotAllowed" in dictionary.keys() else APIHelper.SKIP
        basis_reported = dictionary.get("basisReported") if "basisReported" in dictionary.keys() else APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        cusip = dictionary.get("cusip") if dictionary.get("cusip") else APIHelper.SKIP
        foreign_account_tax_compliance = dictionary.get("foreignAccountTaxCompliance") if "foreignAccountTaxCompliance" in dictionary.keys() else APIHelper.SKIP
        expired_option = dictionary.get("expiredOption") if dictionary.get("expiredOption") else APIHelper.SKIP
        investment_sale_type = dictionary.get("investmentSaleType") if dictionary.get("investmentSaleType") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(checkbox_on_form_8949,
                   security_name,
                   number_of_shares,
                   sale_description,
                   date_acquired,
                   various_dates_acquired,
                   date_of_sale,
                   sales_price,
                   accrued_market_discount,
                   adjustment_codes,
                   cost_basis,
                   corrected_cost_basis,
                   wash_sale_loss_disallowed,
                   long_or_short,
                   ordinary,
                   collectible,
                   qof,
                   federal_tax_withheld,
                   noncovered_security,
                   gross_or_net,
                   loss_not_allowed,
                   basis_reported,
                   state_and_local,
                   cusip,
                   foreign_account_tax_compliance,
                   expired_option,
                   investment_sale_type,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'checkbox_on_form_8949={(self.checkbox_on_form_8949 if hasattr(self, "checkbox_on_form_8949") else None)!r}, '
                f'security_name={(self.security_name if hasattr(self, "security_name") else None)!r}, '
                f'number_of_shares={(self.number_of_shares if hasattr(self, "number_of_shares") else None)!r}, '
                f'sale_description={(self.sale_description if hasattr(self, "sale_description") else None)!r}, '
                f'date_acquired={(self.date_acquired if hasattr(self, "date_acquired") else None)!r}, '
                f'various_dates_acquired={(self.various_dates_acquired if hasattr(self, "various_dates_acquired") else None)!r}, '
                f'date_of_sale={(self.date_of_sale if hasattr(self, "date_of_sale") else None)!r}, '
                f'sales_price={(self.sales_price if hasattr(self, "sales_price") else None)!r}, '
                f'accrued_market_discount={(self.accrued_market_discount if hasattr(self, "accrued_market_discount") else None)!r}, '
                f'adjustment_codes={(self.adjustment_codes if hasattr(self, "adjustment_codes") else None)!r}, '
                f'cost_basis={(self.cost_basis if hasattr(self, "cost_basis") else None)!r}, '
                f'corrected_cost_basis={(self.corrected_cost_basis if hasattr(self, "corrected_cost_basis") else None)!r}, '
                f'wash_sale_loss_disallowed={(self.wash_sale_loss_disallowed if hasattr(self, "wash_sale_loss_disallowed") else None)!r}, '
                f'long_or_short={(self.long_or_short if hasattr(self, "long_or_short") else None)!r}, '
                f'ordinary={(self.ordinary if hasattr(self, "ordinary") else None)!r}, '
                f'collectible={(self.collectible if hasattr(self, "collectible") else None)!r}, '
                f'qof={(self.qof if hasattr(self, "qof") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'noncovered_security={(self.noncovered_security if hasattr(self, "noncovered_security") else None)!r}, '
                f'gross_or_net={(self.gross_or_net if hasattr(self, "gross_or_net") else None)!r}, '
                f'loss_not_allowed={(self.loss_not_allowed if hasattr(self, "loss_not_allowed") else None)!r}, '
                f'basis_reported={(self.basis_reported if hasattr(self, "basis_reported") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'cusip={(self.cusip if hasattr(self, "cusip") else None)!r}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!r}, '
                f'expired_option={(self.expired_option if hasattr(self, "expired_option") else None)!r}, '
                f'investment_sale_type={(self.investment_sale_type if hasattr(self, "investment_sale_type") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'checkbox_on_form_8949={(self.checkbox_on_form_8949 if hasattr(self, "checkbox_on_form_8949") else None)!s}, '
                f'security_name={(self.security_name if hasattr(self, "security_name") else None)!s}, '
                f'number_of_shares={(self.number_of_shares if hasattr(self, "number_of_shares") else None)!s}, '
                f'sale_description={(self.sale_description if hasattr(self, "sale_description") else None)!s}, '
                f'date_acquired={(self.date_acquired if hasattr(self, "date_acquired") else None)!s}, '
                f'various_dates_acquired={(self.various_dates_acquired if hasattr(self, "various_dates_acquired") else None)!s}, '
                f'date_of_sale={(self.date_of_sale if hasattr(self, "date_of_sale") else None)!s}, '
                f'sales_price={(self.sales_price if hasattr(self, "sales_price") else None)!s}, '
                f'accrued_market_discount={(self.accrued_market_discount if hasattr(self, "accrued_market_discount") else None)!s}, '
                f'adjustment_codes={(self.adjustment_codes if hasattr(self, "adjustment_codes") else None)!s}, '
                f'cost_basis={(self.cost_basis if hasattr(self, "cost_basis") else None)!s}, '
                f'corrected_cost_basis={(self.corrected_cost_basis if hasattr(self, "corrected_cost_basis") else None)!s}, '
                f'wash_sale_loss_disallowed={(self.wash_sale_loss_disallowed if hasattr(self, "wash_sale_loss_disallowed") else None)!s}, '
                f'long_or_short={(self.long_or_short if hasattr(self, "long_or_short") else None)!s}, '
                f'ordinary={(self.ordinary if hasattr(self, "ordinary") else None)!s}, '
                f'collectible={(self.collectible if hasattr(self, "collectible") else None)!s}, '
                f'qof={(self.qof if hasattr(self, "qof") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'noncovered_security={(self.noncovered_security if hasattr(self, "noncovered_security") else None)!s}, '
                f'gross_or_net={(self.gross_or_net if hasattr(self, "gross_or_net") else None)!s}, '
                f'loss_not_allowed={(self.loss_not_allowed if hasattr(self, "loss_not_allowed") else None)!s}, '
                f'basis_reported={(self.basis_reported if hasattr(self, "basis_reported") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'cusip={(self.cusip if hasattr(self, "cusip") else None)!s}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!s}, '
                f'expired_option={(self.expired_option if hasattr(self, "expired_option") else None)!s}, '
                f'investment_sale_type={(self.investment_sale_type if hasattr(self, "investment_sale_type") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
