# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.local_tax_withholding_1 import LocalTaxWithholding1
from fdxapi.models.state_tax_withholding_2 import StateTaxWithholding2


class StateAndLocalTaxWithholding2(object):

    """Implementation of the 'State and Local Tax Withholding2' model.

    State and Local tax withholding, from IRS's IRIS schema

    Attributes:
        state_code (StateCode): State two-digit code
        state (StateTaxWithholding2): Amount of state income tax withheld
        local (LocalTaxWithholding1): Amount of local income tax withheld, if
            any
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "state_code": 'stateCode',
        "state": 'state',
        "local": 'local'
    }

    _optionals = [
        'state_code',
        'state',
        'local',
    ]

    def __init__(self,
                 state_code=APIHelper.SKIP,
                 state=APIHelper.SKIP,
                 local=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the StateAndLocalTaxWithholding2 class"""

        # Initialize members of the class
        if state_code is not APIHelper.SKIP:
            self.state_code = state_code 
        if state is not APIHelper.SKIP:
            self.state = state 
        if local is not APIHelper.SKIP:
            self.local = local 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        state_code = dictionary.get("stateCode") if dictionary.get("stateCode") else APIHelper.SKIP
        state = StateTaxWithholding2.from_dictionary(dictionary.get('state')) if 'state' in dictionary.keys() else APIHelper.SKIP
        local = LocalTaxWithholding1.from_dictionary(dictionary.get('local')) if 'local' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(state_code,
                   state,
                   local,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'state_code={(self.state_code if hasattr(self, "state_code") else None)!r}, '
                f'state={(self.state if hasattr(self, "state") else None)!r}, '
                f'local={(self.local if hasattr(self, "local") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'state_code={(self.state_code if hasattr(self, "state_code") else None)!s}, '
                f'state={(self.state if hasattr(self, "state") else None)!s}, '
                f'local={(self.local if hasattr(self, "local") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
