# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.business_income_statement import BusinessIncomeStatement
from fdxapi.models.cryptocurrency_tax_statement_list_1 import CryptocurrencyTaxStatementList1
from fdxapi.models.farm_income_statement import FarmIncomeStatement
from fdxapi.models.farm_rental_income_statement import FarmRentalIncomeStatement
from fdxapi.models.form_1041_k_1 import Form1041K1
from fdxapi.models.form_1041_k_11 import Form1041K11
from fdxapi.models.form_1042_s_1 import Form1042S1
from fdxapi.models.form_1065_k_11 import Form1065K11
from fdxapi.models.form_1095_a_1 import Form1095A1
from fdxapi.models.form_1095_b_1 import Form1095B1
from fdxapi.models.form_1095_c_1 import Form1095C1
from fdxapi.models.form_1097_btc_1 import Form1097Btc1
from fdxapi.models.form_1098_c_1 import Form1098C1
from fdxapi.models.form_1098_e_1 import Form1098E1
from fdxapi.models.form_1098_ma_1 import Form1098Ma1
from fdxapi.models.form_1098_q_1 import Form1098Q1
from fdxapi.models.form_1098_t_1 import Form1098T1
from fdxapi.models.form_10981 import Form10981
from fdxapi.models.form_1099_a_1 import Form1099A1
from fdxapi.models.form_1099_b_1 import Form1099B1
from fdxapi.models.form_1099_c_1 import Form1099C1
from fdxapi.models.form_1099_cap_1 import Form1099Cap1
from fdxapi.models.form_1099_consolidated_statement_1 import Form1099ConsolidatedStatement1
from fdxapi.models.form_1099_div_1 import Form1099Div1
from fdxapi.models.form_1099_g_1 import Form1099G1
from fdxapi.models.form_1099_h_1 import Form1099H1
from fdxapi.models.form_1099_int_1 import Form1099Int1
from fdxapi.models.form_1099_k_1 import Form1099K1
from fdxapi.models.form_1099_ls_1 import Form1099Ls1
from fdxapi.models.form_1099_ltc_1 import Form1099Ltc1
from fdxapi.models.form_1099_misc_1 import Form1099Misc1
from fdxapi.models.form_1099_nec_1 import Form1099Nec1
from fdxapi.models.form_1099_oid_1 import Form1099Oid1
from fdxapi.models.form_1099_patr_1 import Form1099Patr1
from fdxapi.models.form_1099_q_1 import Form1099Q1
from fdxapi.models.form_1099_qa_1 import Form1099Qa1
from fdxapi.models.form_1099_r_1 import Form1099R1
from fdxapi.models.form_1099_s_1 import Form1099S1
from fdxapi.models.form_1099_sa_1 import Form1099Sa1
from fdxapi.models.form_1099_sb_1 import Form1099Sb1
from fdxapi.models.form_1120_sk_11 import Form1120SK11
from fdxapi.models.form_24391 import Form24391
from fdxapi.models.form_39211 import Form39211
from fdxapi.models.form_39221 import Form39221
from fdxapi.models.form_5498_esa_1 import Form5498Esa1
from fdxapi.models.form_5498_qa_1 import Form5498Qa1
from fdxapi.models.form_5498_sa_1 import Form5498Sa1
from fdxapi.models.form_54981 import Form54981
from fdxapi.models.form_w_2_c_2 import FormW2C2
from fdxapi.models.form_w_2_g_2 import FormW2G2
from fdxapi.models.form_w_24 import FormW24
from fdxapi.models.rental_income_statement import RentalIncomeStatement
from fdxapi.models.royalty_income_statement import RoyaltyIncomeStatement
from fdxapi.models.tax_refund_direct_deposit_2 import TaxRefundDirectDeposit2


class TaxData(object):

    """Implementation of the 'Tax Data' model.

    Tax data container for API requests and responses

    Attributes:
        business_income_statement (BusinessIncomeStatement): Business Income
            Statement for IRS Form 1040 Schedule C
        cryptocurrency_tax_statement (CryptocurrencyTaxStatementList1):
            Cryptocurrency Tax Statement list
        farm_income_statement (FarmIncomeStatement): Farm Income Statement for
            IRS Form 1040 Schedule F
        farm_rental_income_statement (FarmRentalIncomeStatement): Farm Rental
            Income Statement for IRS Form 4835
        rental_income_statement (RentalIncomeStatement): Rental Income
            Statement for IRS Form 1040 Schedule E
        royalty_income_statement (RoyaltyIncomeStatement): Royalty Income
            Statement for IRS Form 1040 Schedule E
        tax_1041_k_1 (Form1041K11): Beneficiary's Share of Income, Deductions,
            Credits, etc.
        tax_1042_s (Form1042S1): Foreign Person's U.S. Source Income Subject
            to Withholding
        tax_1065_k_1 (Form1065K11): Partner's Share of Income, Deductions,
            Credits, etc.
        tax_1095_a (Form1095A1): Health Insurance Marketplace Statement
        tax_1095_b (Form1095B1): Health Coverage
        tax_1095_c (Form1095C1): Employer-Provided Health Insurance Offer and
            Coverage
        tax_1097_btc (Form1097Btc1): Bond Tax Credit
        tax_1098 (Form10981): Mortgage Interest Statement
        tax_1098_c (Form1098C1): Contributions of Motor Vehicles, Boats, and
            Airplanes
        tax_1098_e (Form1098E1): Student Loan Interest Statement
        tax_1098_ma (Form1098Ma1): Mortgage Assistance Payments
        tax_1098_q (Form1098Q1): Qualifying Longevity Annuity Contract
            Information
        tax_1098_t (Form1098T1): Tuition Statement
        tax_1099_a (Form1099A1): Acquisition or Abandonment of Secured Property
        tax_1099_b (Form1099B1): Proceeds From Broker and Barter Exchange
            Transactions
        tax_1099_c (Form1099C1): Cancellation of Debt
        tax_1099_cap (Form1099Cap1): Changes in Corporate Control and Capital
            Structure
        tax_1099_consolidated_statement (Form1099ConsolidatedStatement1):
            Consolidated Statement for combined IRS Form 1099s
        tax_1099_div (Form1099Div1): Dividends and Distributions
        tax_1099_g (Form1099G1): Certain Government Payments
        tax_1099_h (Form1099H1): Health Coverage Tax Credit (HCTC) Advance
            Payments
        tax_1099_int (Form1099Int1): Interest Income
        tax_1099_k (Form1099K1): Merchant Card and Third-Party Network Payments
        tax_1099_ls (Form1099Ls1): Reportable Life Insurance Sale
        tax_1099_ltc (Form1099Ltc1): Long-Term Care and Accelerated Death
            Benefits
        tax_1099_misc (Form1099Misc1): Miscellaneous Income
        tax_1099_nec (Form1099Nec1): Nonemployee Compensation
        tax_1099_oid (Form1099Oid1): Original Issue Discount
        tax_1099_patr (Form1099Patr1): Taxable Distributions Received From
            Cooperatives
        tax_1099_q (Form1099Q1): Payments From Qualified Education Programs
        tax_1099_qa (Form1099Qa1): Distributions From ABLE Accounts
        tax_1099_r (Form1099R1): Distributions from Pensions, Annuities,
            Retirement or Profit-Sharing Plans, IRAs, Insurance Contracts, etc.
        tax_1099_s (Form1099S1): Proceeds From Real Estate Transactions
        tax_1099_sa (Form1099Sa1): Distributions From an HSA, Archer MSA, or
            Medicare Advantage MSA
        tax_1099_sb (Form1099Sb1): Seller's Investment in Life Insurance
            Contract
        tax_1120_sk_1 (Form1120Sk11): Shareholder's Share of Income,
            Deductions, Credits, etc.
        tax_2439 (Form24391): Notice to Shareholder of Undistributed Long-Term
            Capital Gains
        tax_3921 (Form39211): Exercise of an Incentive Stock Option Under
            Section 422(b)
        tax_3922 (Form39221): Transfer of Stock Acquired Through an Employee
            Stock Purchase Plan under Section 423(c)
        tax_5227_k_1 (Form1041K1): Split-Interest Trust Beneficiary's schedule
            K-1
        tax_5498 (Form54981): IRA Contribution Information
        tax_5498_esa (Form5498Esa1): Coverdell ESA Contribution Information
        tax_5498_qa (Form5498Qa1): ABLE Account Contribution Information
        tax_5498_sa (Form5498Sa1): HSA, Archer MSA, or Medicare Advantage MSA
            Information
        tax_w_2 (FormW24): Wage and Tax Statement
        tax_w_2_c (FormW2C2): IRS form W-2c, Corrected Wage and Tax Statement
        tax_w_2_g (FormW2G2): Certain Gambling Winnings
        tax_refund_direct_deposit (TaxRefundDirectDeposit2): Tax refund direct
            deposit information
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "business_income_statement": 'businessIncomeStatement',
        "cryptocurrency_tax_statement": 'cryptocurrencyTaxStatement',
        "farm_income_statement": 'farmIncomeStatement',
        "farm_rental_income_statement": 'farmRentalIncomeStatement',
        "rental_income_statement": 'rentalIncomeStatement',
        "royalty_income_statement": 'royaltyIncomeStatement',
        "tax_1041_k_1": 'tax1041K1',
        "tax_1042_s": 'tax1042S',
        "tax_1065_k_1": 'tax1065K1',
        "tax_1095_a": 'tax1095A',
        "tax_1095_b": 'tax1095B',
        "tax_1095_c": 'tax1095C',
        "tax_1097_btc": 'tax1097Btc',
        "tax_1098": 'tax1098',
        "tax_1098_c": 'tax1098C',
        "tax_1098_e": 'tax1098E',
        "tax_1098_ma": 'tax1098Ma',
        "tax_1098_q": 'tax1098Q',
        "tax_1098_t": 'tax1098T',
        "tax_1099_a": 'tax1099A',
        "tax_1099_b": 'tax1099B',
        "tax_1099_c": 'tax1099C',
        "tax_1099_cap": 'tax1099Cap',
        "tax_1099_consolidated_statement": 'tax1099ConsolidatedStatement',
        "tax_1099_div": 'tax1099Div',
        "tax_1099_g": 'tax1099G',
        "tax_1099_h": 'tax1099H',
        "tax_1099_int": 'tax1099Int',
        "tax_1099_k": 'tax1099K',
        "tax_1099_ls": 'tax1099Ls',
        "tax_1099_ltc": 'tax1099Ltc',
        "tax_1099_misc": 'tax1099Misc',
        "tax_1099_nec": 'tax1099Nec',
        "tax_1099_oid": 'tax1099Oid',
        "tax_1099_patr": 'tax1099Patr',
        "tax_1099_q": 'tax1099Q',
        "tax_1099_qa": 'tax1099Qa',
        "tax_1099_r": 'tax1099R',
        "tax_1099_s": 'tax1099S',
        "tax_1099_sa": 'tax1099Sa',
        "tax_1099_sb": 'tax1099Sb',
        "tax_1120_sk_1": 'tax1120SK1',
        "tax_2439": 'tax2439',
        "tax_3921": 'tax3921',
        "tax_3922": 'tax3922',
        "tax_5227_k_1": 'tax5227K1',
        "tax_5498": 'tax5498',
        "tax_5498_esa": 'tax5498Esa',
        "tax_5498_qa": 'tax5498Qa',
        "tax_5498_sa": 'tax5498Sa',
        "tax_w_2": 'taxW2',
        "tax_w_2_c": 'taxW2C',
        "tax_w_2_g": 'taxW2G',
        "tax_refund_direct_deposit": 'taxRefundDirectDeposit'
    }

    _optionals = [
        'business_income_statement',
        'cryptocurrency_tax_statement',
        'farm_income_statement',
        'farm_rental_income_statement',
        'rental_income_statement',
        'royalty_income_statement',
        'tax_1041_k_1',
        'tax_1042_s',
        'tax_1065_k_1',
        'tax_1095_a',
        'tax_1095_b',
        'tax_1095_c',
        'tax_1097_btc',
        'tax_1098',
        'tax_1098_c',
        'tax_1098_e',
        'tax_1098_ma',
        'tax_1098_q',
        'tax_1098_t',
        'tax_1099_a',
        'tax_1099_b',
        'tax_1099_c',
        'tax_1099_cap',
        'tax_1099_consolidated_statement',
        'tax_1099_div',
        'tax_1099_g',
        'tax_1099_h',
        'tax_1099_int',
        'tax_1099_k',
        'tax_1099_ls',
        'tax_1099_ltc',
        'tax_1099_misc',
        'tax_1099_nec',
        'tax_1099_oid',
        'tax_1099_patr',
        'tax_1099_q',
        'tax_1099_qa',
        'tax_1099_r',
        'tax_1099_s',
        'tax_1099_sa',
        'tax_1099_sb',
        'tax_1120_sk_1',
        'tax_2439',
        'tax_3921',
        'tax_3922',
        'tax_5227_k_1',
        'tax_5498',
        'tax_5498_esa',
        'tax_5498_qa',
        'tax_5498_sa',
        'tax_w_2',
        'tax_w_2_c',
        'tax_w_2_g',
        'tax_refund_direct_deposit',
    ]

    def __init__(self,
                 business_income_statement=APIHelper.SKIP,
                 cryptocurrency_tax_statement=APIHelper.SKIP,
                 farm_income_statement=APIHelper.SKIP,
                 farm_rental_income_statement=APIHelper.SKIP,
                 rental_income_statement=APIHelper.SKIP,
                 royalty_income_statement=APIHelper.SKIP,
                 tax_1041_k_1=APIHelper.SKIP,
                 tax_1042_s=APIHelper.SKIP,
                 tax_1065_k_1=APIHelper.SKIP,
                 tax_1095_a=APIHelper.SKIP,
                 tax_1095_b=APIHelper.SKIP,
                 tax_1095_c=APIHelper.SKIP,
                 tax_1097_btc=APIHelper.SKIP,
                 tax_1098=APIHelper.SKIP,
                 tax_1098_c=APIHelper.SKIP,
                 tax_1098_e=APIHelper.SKIP,
                 tax_1098_ma=APIHelper.SKIP,
                 tax_1098_q=APIHelper.SKIP,
                 tax_1098_t=APIHelper.SKIP,
                 tax_1099_a=APIHelper.SKIP,
                 tax_1099_b=APIHelper.SKIP,
                 tax_1099_c=APIHelper.SKIP,
                 tax_1099_cap=APIHelper.SKIP,
                 tax_1099_consolidated_statement=APIHelper.SKIP,
                 tax_1099_div=APIHelper.SKIP,
                 tax_1099_g=APIHelper.SKIP,
                 tax_1099_h=APIHelper.SKIP,
                 tax_1099_int=APIHelper.SKIP,
                 tax_1099_k=APIHelper.SKIP,
                 tax_1099_ls=APIHelper.SKIP,
                 tax_1099_ltc=APIHelper.SKIP,
                 tax_1099_misc=APIHelper.SKIP,
                 tax_1099_nec=APIHelper.SKIP,
                 tax_1099_oid=APIHelper.SKIP,
                 tax_1099_patr=APIHelper.SKIP,
                 tax_1099_q=APIHelper.SKIP,
                 tax_1099_qa=APIHelper.SKIP,
                 tax_1099_r=APIHelper.SKIP,
                 tax_1099_s=APIHelper.SKIP,
                 tax_1099_sa=APIHelper.SKIP,
                 tax_1099_sb=APIHelper.SKIP,
                 tax_1120_sk_1=APIHelper.SKIP,
                 tax_2439=APIHelper.SKIP,
                 tax_3921=APIHelper.SKIP,
                 tax_3922=APIHelper.SKIP,
                 tax_5227_k_1=APIHelper.SKIP,
                 tax_5498=APIHelper.SKIP,
                 tax_5498_esa=APIHelper.SKIP,
                 tax_5498_qa=APIHelper.SKIP,
                 tax_5498_sa=APIHelper.SKIP,
                 tax_w_2=APIHelper.SKIP,
                 tax_w_2_c=APIHelper.SKIP,
                 tax_w_2_g=APIHelper.SKIP,
                 tax_refund_direct_deposit=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the TaxData class"""

        # Initialize members of the class
        if business_income_statement is not APIHelper.SKIP:
            self.business_income_statement = business_income_statement 
        if cryptocurrency_tax_statement is not APIHelper.SKIP:
            self.cryptocurrency_tax_statement = cryptocurrency_tax_statement 
        if farm_income_statement is not APIHelper.SKIP:
            self.farm_income_statement = farm_income_statement 
        if farm_rental_income_statement is not APIHelper.SKIP:
            self.farm_rental_income_statement = farm_rental_income_statement 
        if rental_income_statement is not APIHelper.SKIP:
            self.rental_income_statement = rental_income_statement 
        if royalty_income_statement is not APIHelper.SKIP:
            self.royalty_income_statement = royalty_income_statement 
        if tax_1041_k_1 is not APIHelper.SKIP:
            self.tax_1041_k_1 = tax_1041_k_1 
        if tax_1042_s is not APIHelper.SKIP:
            self.tax_1042_s = tax_1042_s 
        if tax_1065_k_1 is not APIHelper.SKIP:
            self.tax_1065_k_1 = tax_1065_k_1 
        if tax_1095_a is not APIHelper.SKIP:
            self.tax_1095_a = tax_1095_a 
        if tax_1095_b is not APIHelper.SKIP:
            self.tax_1095_b = tax_1095_b 
        if tax_1095_c is not APIHelper.SKIP:
            self.tax_1095_c = tax_1095_c 
        if tax_1097_btc is not APIHelper.SKIP:
            self.tax_1097_btc = tax_1097_btc 
        if tax_1098 is not APIHelper.SKIP:
            self.tax_1098 = tax_1098 
        if tax_1098_c is not APIHelper.SKIP:
            self.tax_1098_c = tax_1098_c 
        if tax_1098_e is not APIHelper.SKIP:
            self.tax_1098_e = tax_1098_e 
        if tax_1098_ma is not APIHelper.SKIP:
            self.tax_1098_ma = tax_1098_ma 
        if tax_1098_q is not APIHelper.SKIP:
            self.tax_1098_q = tax_1098_q 
        if tax_1098_t is not APIHelper.SKIP:
            self.tax_1098_t = tax_1098_t 
        if tax_1099_a is not APIHelper.SKIP:
            self.tax_1099_a = tax_1099_a 
        if tax_1099_b is not APIHelper.SKIP:
            self.tax_1099_b = tax_1099_b 
        if tax_1099_c is not APIHelper.SKIP:
            self.tax_1099_c = tax_1099_c 
        if tax_1099_cap is not APIHelper.SKIP:
            self.tax_1099_cap = tax_1099_cap 
        if tax_1099_consolidated_statement is not APIHelper.SKIP:
            self.tax_1099_consolidated_statement = tax_1099_consolidated_statement 
        if tax_1099_div is not APIHelper.SKIP:
            self.tax_1099_div = tax_1099_div 
        if tax_1099_g is not APIHelper.SKIP:
            self.tax_1099_g = tax_1099_g 
        if tax_1099_h is not APIHelper.SKIP:
            self.tax_1099_h = tax_1099_h 
        if tax_1099_int is not APIHelper.SKIP:
            self.tax_1099_int = tax_1099_int 
        if tax_1099_k is not APIHelper.SKIP:
            self.tax_1099_k = tax_1099_k 
        if tax_1099_ls is not APIHelper.SKIP:
            self.tax_1099_ls = tax_1099_ls 
        if tax_1099_ltc is not APIHelper.SKIP:
            self.tax_1099_ltc = tax_1099_ltc 
        if tax_1099_misc is not APIHelper.SKIP:
            self.tax_1099_misc = tax_1099_misc 
        if tax_1099_nec is not APIHelper.SKIP:
            self.tax_1099_nec = tax_1099_nec 
        if tax_1099_oid is not APIHelper.SKIP:
            self.tax_1099_oid = tax_1099_oid 
        if tax_1099_patr is not APIHelper.SKIP:
            self.tax_1099_patr = tax_1099_patr 
        if tax_1099_q is not APIHelper.SKIP:
            self.tax_1099_q = tax_1099_q 
        if tax_1099_qa is not APIHelper.SKIP:
            self.tax_1099_qa = tax_1099_qa 
        if tax_1099_r is not APIHelper.SKIP:
            self.tax_1099_r = tax_1099_r 
        if tax_1099_s is not APIHelper.SKIP:
            self.tax_1099_s = tax_1099_s 
        if tax_1099_sa is not APIHelper.SKIP:
            self.tax_1099_sa = tax_1099_sa 
        if tax_1099_sb is not APIHelper.SKIP:
            self.tax_1099_sb = tax_1099_sb 
        if tax_1120_sk_1 is not APIHelper.SKIP:
            self.tax_1120_sk_1 = tax_1120_sk_1 
        if tax_2439 is not APIHelper.SKIP:
            self.tax_2439 = tax_2439 
        if tax_3921 is not APIHelper.SKIP:
            self.tax_3921 = tax_3921 
        if tax_3922 is not APIHelper.SKIP:
            self.tax_3922 = tax_3922 
        if tax_5227_k_1 is not APIHelper.SKIP:
            self.tax_5227_k_1 = tax_5227_k_1 
        if tax_5498 is not APIHelper.SKIP:
            self.tax_5498 = tax_5498 
        if tax_5498_esa is not APIHelper.SKIP:
            self.tax_5498_esa = tax_5498_esa 
        if tax_5498_qa is not APIHelper.SKIP:
            self.tax_5498_qa = tax_5498_qa 
        if tax_5498_sa is not APIHelper.SKIP:
            self.tax_5498_sa = tax_5498_sa 
        if tax_w_2 is not APIHelper.SKIP:
            self.tax_w_2 = tax_w_2 
        if tax_w_2_c is not APIHelper.SKIP:
            self.tax_w_2_c = tax_w_2_c 
        if tax_w_2_g is not APIHelper.SKIP:
            self.tax_w_2_g = tax_w_2_g 
        if tax_refund_direct_deposit is not APIHelper.SKIP:
            self.tax_refund_direct_deposit = tax_refund_direct_deposit 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        business_income_statement = BusinessIncomeStatement.from_dictionary(dictionary.get('businessIncomeStatement')) if 'businessIncomeStatement' in dictionary.keys() else APIHelper.SKIP
        cryptocurrency_tax_statement = CryptocurrencyTaxStatementList1.from_dictionary(dictionary.get('cryptocurrencyTaxStatement')) if 'cryptocurrencyTaxStatement' in dictionary.keys() else APIHelper.SKIP
        farm_income_statement = FarmIncomeStatement.from_dictionary(dictionary.get('farmIncomeStatement')) if 'farmIncomeStatement' in dictionary.keys() else APIHelper.SKIP
        farm_rental_income_statement = FarmRentalIncomeStatement.from_dictionary(dictionary.get('farmRentalIncomeStatement')) if 'farmRentalIncomeStatement' in dictionary.keys() else APIHelper.SKIP
        rental_income_statement = RentalIncomeStatement.from_dictionary(dictionary.get('rentalIncomeStatement')) if 'rentalIncomeStatement' in dictionary.keys() else APIHelper.SKIP
        royalty_income_statement = RoyaltyIncomeStatement.from_dictionary(dictionary.get('royaltyIncomeStatement')) if 'royaltyIncomeStatement' in dictionary.keys() else APIHelper.SKIP
        tax_1041_k_1 = Form1041K11.from_dictionary(dictionary.get('tax1041K1')) if 'tax1041K1' in dictionary.keys() else APIHelper.SKIP
        tax_1042_s = Form1042S1.from_dictionary(dictionary.get('tax1042S')) if 'tax1042S' in dictionary.keys() else APIHelper.SKIP
        tax_1065_k_1 = Form1065K11.from_dictionary(dictionary.get('tax1065K1')) if 'tax1065K1' in dictionary.keys() else APIHelper.SKIP
        tax_1095_a = Form1095A1.from_dictionary(dictionary.get('tax1095A')) if 'tax1095A' in dictionary.keys() else APIHelper.SKIP
        tax_1095_b = Form1095B1.from_dictionary(dictionary.get('tax1095B')) if 'tax1095B' in dictionary.keys() else APIHelper.SKIP
        tax_1095_c = Form1095C1.from_dictionary(dictionary.get('tax1095C')) if 'tax1095C' in dictionary.keys() else APIHelper.SKIP
        tax_1097_btc = Form1097Btc1.from_dictionary(dictionary.get('tax1097Btc')) if 'tax1097Btc' in dictionary.keys() else APIHelper.SKIP
        tax_1098 = Form10981.from_dictionary(dictionary.get('tax1098')) if 'tax1098' in dictionary.keys() else APIHelper.SKIP
        tax_1098_c = Form1098C1.from_dictionary(dictionary.get('tax1098C')) if 'tax1098C' in dictionary.keys() else APIHelper.SKIP
        tax_1098_e = Form1098E1.from_dictionary(dictionary.get('tax1098E')) if 'tax1098E' in dictionary.keys() else APIHelper.SKIP
        tax_1098_ma = Form1098Ma1.from_dictionary(dictionary.get('tax1098Ma')) if 'tax1098Ma' in dictionary.keys() else APIHelper.SKIP
        tax_1098_q = Form1098Q1.from_dictionary(dictionary.get('tax1098Q')) if 'tax1098Q' in dictionary.keys() else APIHelper.SKIP
        tax_1098_t = Form1098T1.from_dictionary(dictionary.get('tax1098T')) if 'tax1098T' in dictionary.keys() else APIHelper.SKIP
        tax_1099_a = Form1099A1.from_dictionary(dictionary.get('tax1099A')) if 'tax1099A' in dictionary.keys() else APIHelper.SKIP
        tax_1099_b = Form1099B1.from_dictionary(dictionary.get('tax1099B')) if 'tax1099B' in dictionary.keys() else APIHelper.SKIP
        tax_1099_c = Form1099C1.from_dictionary(dictionary.get('tax1099C')) if 'tax1099C' in dictionary.keys() else APIHelper.SKIP
        tax_1099_cap = Form1099Cap1.from_dictionary(dictionary.get('tax1099Cap')) if 'tax1099Cap' in dictionary.keys() else APIHelper.SKIP
        tax_1099_consolidated_statement = Form1099ConsolidatedStatement1.from_dictionary(dictionary.get('tax1099ConsolidatedStatement')) if 'tax1099ConsolidatedStatement' in dictionary.keys() else APIHelper.SKIP
        tax_1099_div = Form1099Div1.from_dictionary(dictionary.get('tax1099Div')) if 'tax1099Div' in dictionary.keys() else APIHelper.SKIP
        tax_1099_g = Form1099G1.from_dictionary(dictionary.get('tax1099G')) if 'tax1099G' in dictionary.keys() else APIHelper.SKIP
        tax_1099_h = Form1099H1.from_dictionary(dictionary.get('tax1099H')) if 'tax1099H' in dictionary.keys() else APIHelper.SKIP
        tax_1099_int = Form1099Int1.from_dictionary(dictionary.get('tax1099Int')) if 'tax1099Int' in dictionary.keys() else APIHelper.SKIP
        tax_1099_k = Form1099K1.from_dictionary(dictionary.get('tax1099K')) if 'tax1099K' in dictionary.keys() else APIHelper.SKIP
        tax_1099_ls = Form1099Ls1.from_dictionary(dictionary.get('tax1099Ls')) if 'tax1099Ls' in dictionary.keys() else APIHelper.SKIP
        tax_1099_ltc = Form1099Ltc1.from_dictionary(dictionary.get('tax1099Ltc')) if 'tax1099Ltc' in dictionary.keys() else APIHelper.SKIP
        tax_1099_misc = Form1099Misc1.from_dictionary(dictionary.get('tax1099Misc')) if 'tax1099Misc' in dictionary.keys() else APIHelper.SKIP
        tax_1099_nec = Form1099Nec1.from_dictionary(dictionary.get('tax1099Nec')) if 'tax1099Nec' in dictionary.keys() else APIHelper.SKIP
        tax_1099_oid = Form1099Oid1.from_dictionary(dictionary.get('tax1099Oid')) if 'tax1099Oid' in dictionary.keys() else APIHelper.SKIP
        tax_1099_patr = Form1099Patr1.from_dictionary(dictionary.get('tax1099Patr')) if 'tax1099Patr' in dictionary.keys() else APIHelper.SKIP
        tax_1099_q = Form1099Q1.from_dictionary(dictionary.get('tax1099Q')) if 'tax1099Q' in dictionary.keys() else APIHelper.SKIP
        tax_1099_qa = Form1099Qa1.from_dictionary(dictionary.get('tax1099Qa')) if 'tax1099Qa' in dictionary.keys() else APIHelper.SKIP
        tax_1099_r = Form1099R1.from_dictionary(dictionary.get('tax1099R')) if 'tax1099R' in dictionary.keys() else APIHelper.SKIP
        tax_1099_s = Form1099S1.from_dictionary(dictionary.get('tax1099S')) if 'tax1099S' in dictionary.keys() else APIHelper.SKIP
        tax_1099_sa = Form1099Sa1.from_dictionary(dictionary.get('tax1099Sa')) if 'tax1099Sa' in dictionary.keys() else APIHelper.SKIP
        tax_1099_sb = Form1099Sb1.from_dictionary(dictionary.get('tax1099Sb')) if 'tax1099Sb' in dictionary.keys() else APIHelper.SKIP
        tax_1120_sk_1 = Form1120SK11.from_dictionary(dictionary.get('tax1120SK1')) if 'tax1120SK1' in dictionary.keys() else APIHelper.SKIP
        tax_2439 = Form24391.from_dictionary(dictionary.get('tax2439')) if 'tax2439' in dictionary.keys() else APIHelper.SKIP
        tax_3921 = Form39211.from_dictionary(dictionary.get('tax3921')) if 'tax3921' in dictionary.keys() else APIHelper.SKIP
        tax_3922 = Form39221.from_dictionary(dictionary.get('tax3922')) if 'tax3922' in dictionary.keys() else APIHelper.SKIP
        tax_5227_k_1 = Form1041K1.from_dictionary(dictionary.get('tax5227K1')) if 'tax5227K1' in dictionary.keys() else APIHelper.SKIP
        tax_5498 = Form54981.from_dictionary(dictionary.get('tax5498')) if 'tax5498' in dictionary.keys() else APIHelper.SKIP
        tax_5498_esa = Form5498Esa1.from_dictionary(dictionary.get('tax5498Esa')) if 'tax5498Esa' in dictionary.keys() else APIHelper.SKIP
        tax_5498_qa = Form5498Qa1.from_dictionary(dictionary.get('tax5498Qa')) if 'tax5498Qa' in dictionary.keys() else APIHelper.SKIP
        tax_5498_sa = Form5498Sa1.from_dictionary(dictionary.get('tax5498Sa')) if 'tax5498Sa' in dictionary.keys() else APIHelper.SKIP
        tax_w_2 = FormW24.from_dictionary(dictionary.get('taxW2')) if 'taxW2' in dictionary.keys() else APIHelper.SKIP
        tax_w_2_c = FormW2C2.from_dictionary(dictionary.get('taxW2C')) if 'taxW2C' in dictionary.keys() else APIHelper.SKIP
        tax_w_2_g = FormW2G2.from_dictionary(dictionary.get('taxW2G')) if 'taxW2G' in dictionary.keys() else APIHelper.SKIP
        tax_refund_direct_deposit = TaxRefundDirectDeposit2.from_dictionary(dictionary.get('taxRefundDirectDeposit')) if 'taxRefundDirectDeposit' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(business_income_statement,
                   cryptocurrency_tax_statement,
                   farm_income_statement,
                   farm_rental_income_statement,
                   rental_income_statement,
                   royalty_income_statement,
                   tax_1041_k_1,
                   tax_1042_s,
                   tax_1065_k_1,
                   tax_1095_a,
                   tax_1095_b,
                   tax_1095_c,
                   tax_1097_btc,
                   tax_1098,
                   tax_1098_c,
                   tax_1098_e,
                   tax_1098_ma,
                   tax_1098_q,
                   tax_1098_t,
                   tax_1099_a,
                   tax_1099_b,
                   tax_1099_c,
                   tax_1099_cap,
                   tax_1099_consolidated_statement,
                   tax_1099_div,
                   tax_1099_g,
                   tax_1099_h,
                   tax_1099_int,
                   tax_1099_k,
                   tax_1099_ls,
                   tax_1099_ltc,
                   tax_1099_misc,
                   tax_1099_nec,
                   tax_1099_oid,
                   tax_1099_patr,
                   tax_1099_q,
                   tax_1099_qa,
                   tax_1099_r,
                   tax_1099_s,
                   tax_1099_sa,
                   tax_1099_sb,
                   tax_1120_sk_1,
                   tax_2439,
                   tax_3921,
                   tax_3922,
                   tax_5227_k_1,
                   tax_5498,
                   tax_5498_esa,
                   tax_5498_qa,
                   tax_5498_sa,
                   tax_w_2,
                   tax_w_2_c,
                   tax_w_2_g,
                   tax_refund_direct_deposit,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'business_income_statement={(self.business_income_statement if hasattr(self, "business_income_statement") else None)!r}, '
                f'cryptocurrency_tax_statement={(self.cryptocurrency_tax_statement if hasattr(self, "cryptocurrency_tax_statement") else None)!r}, '
                f'farm_income_statement={(self.farm_income_statement if hasattr(self, "farm_income_statement") else None)!r}, '
                f'farm_rental_income_statement={(self.farm_rental_income_statement if hasattr(self, "farm_rental_income_statement") else None)!r}, '
                f'rental_income_statement={(self.rental_income_statement if hasattr(self, "rental_income_statement") else None)!r}, '
                f'royalty_income_statement={(self.royalty_income_statement if hasattr(self, "royalty_income_statement") else None)!r}, '
                f'tax_1041_k_1={(self.tax_1041_k_1 if hasattr(self, "tax_1041_k_1") else None)!r}, '
                f'tax_1042_s={(self.tax_1042_s if hasattr(self, "tax_1042_s") else None)!r}, '
                f'tax_1065_k_1={(self.tax_1065_k_1 if hasattr(self, "tax_1065_k_1") else None)!r}, '
                f'tax_1095_a={(self.tax_1095_a if hasattr(self, "tax_1095_a") else None)!r}, '
                f'tax_1095_b={(self.tax_1095_b if hasattr(self, "tax_1095_b") else None)!r}, '
                f'tax_1095_c={(self.tax_1095_c if hasattr(self, "tax_1095_c") else None)!r}, '
                f'tax_1097_btc={(self.tax_1097_btc if hasattr(self, "tax_1097_btc") else None)!r}, '
                f'tax_1098={(self.tax_1098 if hasattr(self, "tax_1098") else None)!r}, '
                f'tax_1098_c={(self.tax_1098_c if hasattr(self, "tax_1098_c") else None)!r}, '
                f'tax_1098_e={(self.tax_1098_e if hasattr(self, "tax_1098_e") else None)!r}, '
                f'tax_1098_ma={(self.tax_1098_ma if hasattr(self, "tax_1098_ma") else None)!r}, '
                f'tax_1098_q={(self.tax_1098_q if hasattr(self, "tax_1098_q") else None)!r}, '
                f'tax_1098_t={(self.tax_1098_t if hasattr(self, "tax_1098_t") else None)!r}, '
                f'tax_1099_a={(self.tax_1099_a if hasattr(self, "tax_1099_a") else None)!r}, '
                f'tax_1099_b={(self.tax_1099_b if hasattr(self, "tax_1099_b") else None)!r}, '
                f'tax_1099_c={(self.tax_1099_c if hasattr(self, "tax_1099_c") else None)!r}, '
                f'tax_1099_cap={(self.tax_1099_cap if hasattr(self, "tax_1099_cap") else None)!r}, '
                f'tax_1099_consolidated_statement={(self.tax_1099_consolidated_statement if hasattr(self, "tax_1099_consolidated_statement") else None)!r}, '
                f'tax_1099_div={(self.tax_1099_div if hasattr(self, "tax_1099_div") else None)!r}, '
                f'tax_1099_g={(self.tax_1099_g if hasattr(self, "tax_1099_g") else None)!r}, '
                f'tax_1099_h={(self.tax_1099_h if hasattr(self, "tax_1099_h") else None)!r}, '
                f'tax_1099_int={(self.tax_1099_int if hasattr(self, "tax_1099_int") else None)!r}, '
                f'tax_1099_k={(self.tax_1099_k if hasattr(self, "tax_1099_k") else None)!r}, '
                f'tax_1099_ls={(self.tax_1099_ls if hasattr(self, "tax_1099_ls") else None)!r}, '
                f'tax_1099_ltc={(self.tax_1099_ltc if hasattr(self, "tax_1099_ltc") else None)!r}, '
                f'tax_1099_misc={(self.tax_1099_misc if hasattr(self, "tax_1099_misc") else None)!r}, '
                f'tax_1099_nec={(self.tax_1099_nec if hasattr(self, "tax_1099_nec") else None)!r}, '
                f'tax_1099_oid={(self.tax_1099_oid if hasattr(self, "tax_1099_oid") else None)!r}, '
                f'tax_1099_patr={(self.tax_1099_patr if hasattr(self, "tax_1099_patr") else None)!r}, '
                f'tax_1099_q={(self.tax_1099_q if hasattr(self, "tax_1099_q") else None)!r}, '
                f'tax_1099_qa={(self.tax_1099_qa if hasattr(self, "tax_1099_qa") else None)!r}, '
                f'tax_1099_r={(self.tax_1099_r if hasattr(self, "tax_1099_r") else None)!r}, '
                f'tax_1099_s={(self.tax_1099_s if hasattr(self, "tax_1099_s") else None)!r}, '
                f'tax_1099_sa={(self.tax_1099_sa if hasattr(self, "tax_1099_sa") else None)!r}, '
                f'tax_1099_sb={(self.tax_1099_sb if hasattr(self, "tax_1099_sb") else None)!r}, '
                f'tax_1120_sk_1={(self.tax_1120_sk_1 if hasattr(self, "tax_1120_sk_1") else None)!r}, '
                f'tax_2439={(self.tax_2439 if hasattr(self, "tax_2439") else None)!r}, '
                f'tax_3921={(self.tax_3921 if hasattr(self, "tax_3921") else None)!r}, '
                f'tax_3922={(self.tax_3922 if hasattr(self, "tax_3922") else None)!r}, '
                f'tax_5227_k_1={(self.tax_5227_k_1 if hasattr(self, "tax_5227_k_1") else None)!r}, '
                f'tax_5498={(self.tax_5498 if hasattr(self, "tax_5498") else None)!r}, '
                f'tax_5498_esa={(self.tax_5498_esa if hasattr(self, "tax_5498_esa") else None)!r}, '
                f'tax_5498_qa={(self.tax_5498_qa if hasattr(self, "tax_5498_qa") else None)!r}, '
                f'tax_5498_sa={(self.tax_5498_sa if hasattr(self, "tax_5498_sa") else None)!r}, '
                f'tax_w_2={(self.tax_w_2 if hasattr(self, "tax_w_2") else None)!r}, '
                f'tax_w_2_c={(self.tax_w_2_c if hasattr(self, "tax_w_2_c") else None)!r}, '
                f'tax_w_2_g={(self.tax_w_2_g if hasattr(self, "tax_w_2_g") else None)!r}, '
                f'tax_refund_direct_deposit={(self.tax_refund_direct_deposit if hasattr(self, "tax_refund_direct_deposit") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'business_income_statement={(self.business_income_statement if hasattr(self, "business_income_statement") else None)!s}, '
                f'cryptocurrency_tax_statement={(self.cryptocurrency_tax_statement if hasattr(self, "cryptocurrency_tax_statement") else None)!s}, '
                f'farm_income_statement={(self.farm_income_statement if hasattr(self, "farm_income_statement") else None)!s}, '
                f'farm_rental_income_statement={(self.farm_rental_income_statement if hasattr(self, "farm_rental_income_statement") else None)!s}, '
                f'rental_income_statement={(self.rental_income_statement if hasattr(self, "rental_income_statement") else None)!s}, '
                f'royalty_income_statement={(self.royalty_income_statement if hasattr(self, "royalty_income_statement") else None)!s}, '
                f'tax_1041_k_1={(self.tax_1041_k_1 if hasattr(self, "tax_1041_k_1") else None)!s}, '
                f'tax_1042_s={(self.tax_1042_s if hasattr(self, "tax_1042_s") else None)!s}, '
                f'tax_1065_k_1={(self.tax_1065_k_1 if hasattr(self, "tax_1065_k_1") else None)!s}, '
                f'tax_1095_a={(self.tax_1095_a if hasattr(self, "tax_1095_a") else None)!s}, '
                f'tax_1095_b={(self.tax_1095_b if hasattr(self, "tax_1095_b") else None)!s}, '
                f'tax_1095_c={(self.tax_1095_c if hasattr(self, "tax_1095_c") else None)!s}, '
                f'tax_1097_btc={(self.tax_1097_btc if hasattr(self, "tax_1097_btc") else None)!s}, '
                f'tax_1098={(self.tax_1098 if hasattr(self, "tax_1098") else None)!s}, '
                f'tax_1098_c={(self.tax_1098_c if hasattr(self, "tax_1098_c") else None)!s}, '
                f'tax_1098_e={(self.tax_1098_e if hasattr(self, "tax_1098_e") else None)!s}, '
                f'tax_1098_ma={(self.tax_1098_ma if hasattr(self, "tax_1098_ma") else None)!s}, '
                f'tax_1098_q={(self.tax_1098_q if hasattr(self, "tax_1098_q") else None)!s}, '
                f'tax_1098_t={(self.tax_1098_t if hasattr(self, "tax_1098_t") else None)!s}, '
                f'tax_1099_a={(self.tax_1099_a if hasattr(self, "tax_1099_a") else None)!s}, '
                f'tax_1099_b={(self.tax_1099_b if hasattr(self, "tax_1099_b") else None)!s}, '
                f'tax_1099_c={(self.tax_1099_c if hasattr(self, "tax_1099_c") else None)!s}, '
                f'tax_1099_cap={(self.tax_1099_cap if hasattr(self, "tax_1099_cap") else None)!s}, '
                f'tax_1099_consolidated_statement={(self.tax_1099_consolidated_statement if hasattr(self, "tax_1099_consolidated_statement") else None)!s}, '
                f'tax_1099_div={(self.tax_1099_div if hasattr(self, "tax_1099_div") else None)!s}, '
                f'tax_1099_g={(self.tax_1099_g if hasattr(self, "tax_1099_g") else None)!s}, '
                f'tax_1099_h={(self.tax_1099_h if hasattr(self, "tax_1099_h") else None)!s}, '
                f'tax_1099_int={(self.tax_1099_int if hasattr(self, "tax_1099_int") else None)!s}, '
                f'tax_1099_k={(self.tax_1099_k if hasattr(self, "tax_1099_k") else None)!s}, '
                f'tax_1099_ls={(self.tax_1099_ls if hasattr(self, "tax_1099_ls") else None)!s}, '
                f'tax_1099_ltc={(self.tax_1099_ltc if hasattr(self, "tax_1099_ltc") else None)!s}, '
                f'tax_1099_misc={(self.tax_1099_misc if hasattr(self, "tax_1099_misc") else None)!s}, '
                f'tax_1099_nec={(self.tax_1099_nec if hasattr(self, "tax_1099_nec") else None)!s}, '
                f'tax_1099_oid={(self.tax_1099_oid if hasattr(self, "tax_1099_oid") else None)!s}, '
                f'tax_1099_patr={(self.tax_1099_patr if hasattr(self, "tax_1099_patr") else None)!s}, '
                f'tax_1099_q={(self.tax_1099_q if hasattr(self, "tax_1099_q") else None)!s}, '
                f'tax_1099_qa={(self.tax_1099_qa if hasattr(self, "tax_1099_qa") else None)!s}, '
                f'tax_1099_r={(self.tax_1099_r if hasattr(self, "tax_1099_r") else None)!s}, '
                f'tax_1099_s={(self.tax_1099_s if hasattr(self, "tax_1099_s") else None)!s}, '
                f'tax_1099_sa={(self.tax_1099_sa if hasattr(self, "tax_1099_sa") else None)!s}, '
                f'tax_1099_sb={(self.tax_1099_sb if hasattr(self, "tax_1099_sb") else None)!s}, '
                f'tax_1120_sk_1={(self.tax_1120_sk_1 if hasattr(self, "tax_1120_sk_1") else None)!s}, '
                f'tax_2439={(self.tax_2439 if hasattr(self, "tax_2439") else None)!s}, '
                f'tax_3921={(self.tax_3921 if hasattr(self, "tax_3921") else None)!s}, '
                f'tax_3922={(self.tax_3922 if hasattr(self, "tax_3922") else None)!s}, '
                f'tax_5227_k_1={(self.tax_5227_k_1 if hasattr(self, "tax_5227_k_1") else None)!s}, '
                f'tax_5498={(self.tax_5498 if hasattr(self, "tax_5498") else None)!s}, '
                f'tax_5498_esa={(self.tax_5498_esa if hasattr(self, "tax_5498_esa") else None)!s}, '
                f'tax_5498_qa={(self.tax_5498_qa if hasattr(self, "tax_5498_qa") else None)!s}, '
                f'tax_5498_sa={(self.tax_5498_sa if hasattr(self, "tax_5498_sa") else None)!s}, '
                f'tax_w_2={(self.tax_w_2 if hasattr(self, "tax_w_2") else None)!s}, '
                f'tax_w_2_c={(self.tax_w_2_c if hasattr(self, "tax_w_2_c") else None)!s}, '
                f'tax_w_2_g={(self.tax_w_2_g if hasattr(self, "tax_w_2_g") else None)!s}, '
                f'tax_refund_direct_deposit={(self.tax_refund_direct_deposit if hasattr(self, "tax_refund_direct_deposit") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
