# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.occurrence_based_limits_for_a_payment_network_2 import OccurrenceBasedLimitsForAPaymentNetwork2
from fdxapi.models.timeframe_based_limits_for_a_payment_network_1 import TimeframeBasedLimitsForAPaymentNetwork1
from fdxapi.models.timeframe_based_limits_for_a_payment_network_2 import TimeframeBasedLimitsForAPaymentNetwork2
from fdxapi.models.timeframe_based_limits_for_a_payment_network_3 import TimeframeBasedLimitsForAPaymentNetwork3
from fdxapi.models.timeframe_based_limits_for_a_payment_network_5 import TimeframeBasedLimitsForAPaymentNetwork5


class TimeAndOccurrenceBasedTransferLimits(object):

    """Implementation of the 'Time and occurrence based transfer limits' model.

    The transfer amount limits for each timeframe or occurrence

    Attributes:
        day (TimeframeBasedLimitsForAPaymentNetwork5): The transfer limits for
            the current day
        week (TimeframeBasedLimitsForAPaymentNetwork1): The transfer limits
            for the current week
        month (TimeframeBasedLimitsForAPaymentNetwork2): The transfer limits
            for the current month
        year (TimeframeBasedLimitsForAPaymentNetwork3): The transfer limits
            for the current year
        transaction (OccurrenceBasedLimitsForAPaymentNetwork2): The transfer
            limits taking effect from all the timeframe limits
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "day": 'day',
        "week": 'week',
        "month": 'month',
        "year": 'year',
        "transaction": 'transaction'
    }

    _optionals = [
        'day',
        'week',
        'month',
        'year',
        'transaction',
    ]

    def __init__(self,
                 day=APIHelper.SKIP,
                 week=APIHelper.SKIP,
                 month=APIHelper.SKIP,
                 year=APIHelper.SKIP,
                 transaction=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the TimeAndOccurrenceBasedTransferLimits class"""

        # Initialize members of the class
        if day is not APIHelper.SKIP:
            self.day = day 
        if week is not APIHelper.SKIP:
            self.week = week 
        if month is not APIHelper.SKIP:
            self.month = month 
        if year is not APIHelper.SKIP:
            self.year = year 
        if transaction is not APIHelper.SKIP:
            self.transaction = transaction 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        day = TimeframeBasedLimitsForAPaymentNetwork5.from_dictionary(dictionary.get('day')) if 'day' in dictionary.keys() else APIHelper.SKIP
        week = TimeframeBasedLimitsForAPaymentNetwork1.from_dictionary(dictionary.get('week')) if 'week' in dictionary.keys() else APIHelper.SKIP
        month = TimeframeBasedLimitsForAPaymentNetwork2.from_dictionary(dictionary.get('month')) if 'month' in dictionary.keys() else APIHelper.SKIP
        year = TimeframeBasedLimitsForAPaymentNetwork3.from_dictionary(dictionary.get('year')) if 'year' in dictionary.keys() else APIHelper.SKIP
        transaction = OccurrenceBasedLimitsForAPaymentNetwork2.from_dictionary(dictionary.get('transaction')) if 'transaction' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(day,
                   week,
                   month,
                   year,
                   transaction,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'day={(self.day if hasattr(self, "day") else None)!r}, '
                f'week={(self.week if hasattr(self, "week") else None)!r}, '
                f'month={(self.month if hasattr(self, "month") else None)!r}, '
                f'year={(self.year if hasattr(self, "year") else None)!r}, '
                f'transaction={(self.transaction if hasattr(self, "transaction") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'day={(self.day if hasattr(self, "day") else None)!s}, '
                f'week={(self.week if hasattr(self, "week") else None)!s}, '
                f'month={(self.month if hasattr(self, "month") else None)!s}, '
                f'year={(self.year if hasattr(self, "year") else None)!s}, '
                f'transaction={(self.transaction if hasattr(self, "transaction") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
