# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.payment_details_entity import PaymentDetailsEntity


class TransferForCreateEntity(object):

    """Implementation of the 'Transfer for Create entity' model.

    Used to request a transfer

    Attributes:
        transfer_id (str): Client generated, long-term persistent identity of
            the transfer action. This ID should be maintained and returned by
            institution
        from_account_id (str): Long-term persistent identity of the source
            account
        to_account_id (str): Long-term persistent identity of the destination
            account
        amount (float): Positive amount of money to be transferred
        memo (str): User-entered reason for transfer
        payment_details (PaymentDetailsEntity): Payment details
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "transfer_id": 'transferId',
        "from_account_id": 'fromAccountId',
        "to_account_id": 'toAccountId',
        "amount": 'amount',
        "memo": 'memo',
        "payment_details": 'paymentDetails'
    }

    _optionals = [
        'transfer_id',
        'from_account_id',
        'to_account_id',
        'amount',
        'memo',
        'payment_details',
    ]

    def __init__(self,
                 transfer_id=APIHelper.SKIP,
                 from_account_id=APIHelper.SKIP,
                 to_account_id=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 payment_details=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the TransferForCreateEntity class"""

        # Initialize members of the class
        if transfer_id is not APIHelper.SKIP:
            self.transfer_id = transfer_id 
        if from_account_id is not APIHelper.SKIP:
            self.from_account_id = from_account_id 
        if to_account_id is not APIHelper.SKIP:
            self.to_account_id = to_account_id 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if memo is not APIHelper.SKIP:
            self.memo = memo 
        if payment_details is not APIHelper.SKIP:
            self.payment_details = payment_details 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        transfer_id = dictionary.get("transferId") if dictionary.get("transferId") else APIHelper.SKIP
        from_account_id = dictionary.get("fromAccountId") if dictionary.get("fromAccountId") else APIHelper.SKIP
        to_account_id = dictionary.get("toAccountId") if dictionary.get("toAccountId") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        payment_details = PaymentDetailsEntity.from_dictionary(dictionary.get('paymentDetails')) if 'paymentDetails' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(transfer_id,
                   from_account_id,
                   to_account_id,
                   amount,
                   memo,
                   payment_details,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'transfer_id={(self.transfer_id if hasattr(self, "transfer_id") else None)!r}, '
                f'from_account_id={(self.from_account_id if hasattr(self, "from_account_id") else None)!r}, '
                f'to_account_id={(self.to_account_id if hasattr(self, "to_account_id") else None)!r}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!r}, '
                f'memo={(self.memo if hasattr(self, "memo") else None)!r}, '
                f'payment_details={(self.payment_details if hasattr(self, "payment_details") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'transfer_id={(self.transfer_id if hasattr(self, "transfer_id") else None)!s}, '
                f'from_account_id={(self.from_account_id if hasattr(self, "from_account_id") else None)!s}, '
                f'to_account_id={(self.to_account_id if hasattr(self, "to_account_id") else None)!s}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!s}, '
                f'memo={(self.memo if hasattr(self, "memo") else None)!s}, '
                f'payment_details={(self.payment_details if hasattr(self, "payment_details") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
