# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class UpdatesMetadataEntity2(object):

    """Implementation of the 'Updates Metadata entity2' model.

    Update IDs for retrieving updates since query

    Attributes:
        next_update_id (str): Opaque identifier. Does not need to be numeric
            or have any specific pattern. Implementation specific
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "next_update_id": 'nextUpdateId'
    }

    _optionals = [
        'next_update_id',
    ]

    def __init__(self,
                 next_update_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the UpdatesMetadataEntity2 class"""

        # Initialize members of the class
        if next_update_id is not APIHelper.SKIP:
            self.next_update_id = next_update_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        next_update_id = dictionary.get("nextUpdateId") if dictionary.get("nextUpdateId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(next_update_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'next_update_id={(self.next_update_id if hasattr(self, "next_update_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'next_update_id={(self.next_update_id if hasattr(self, "next_update_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
