# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class VestingEntity(object):

    """Implementation of the 'Vesting entity' model.

    Represents the vesting of ownership of an investment account

    Attributes:
        vesting_date (date): Vesting date
        symbol (str): Security symbol
        strike_price (float): Strike price
        vesting_percentage (float): Vesting percentage
        other_vest_amount (float): Other vested amount
        other_vest_percentage (float): Other vested percentage
        vested_balance (float): Vested balance
        un_vested_balance (float): Unvested balance
        vested_quantity (float): Vested quantity
        un_vested_quantity (float): Unvested quantity
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "vesting_date": 'vestingDate',
        "symbol": 'symbol',
        "strike_price": 'strikePrice',
        "vesting_percentage": 'vestingPercentage',
        "other_vest_amount": 'otherVestAmount',
        "other_vest_percentage": 'otherVestPercentage',
        "vested_balance": 'vestedBalance',
        "un_vested_balance": 'unVestedBalance',
        "vested_quantity": 'vestedQuantity',
        "un_vested_quantity": 'unVestedQuantity'
    }

    _optionals = [
        'vesting_date',
        'symbol',
        'strike_price',
        'vesting_percentage',
        'other_vest_amount',
        'other_vest_percentage',
        'vested_balance',
        'un_vested_balance',
        'vested_quantity',
        'un_vested_quantity',
    ]

    def __init__(self,
                 vesting_date=APIHelper.SKIP,
                 symbol=APIHelper.SKIP,
                 strike_price=APIHelper.SKIP,
                 vesting_percentage=APIHelper.SKIP,
                 other_vest_amount=APIHelper.SKIP,
                 other_vest_percentage=APIHelper.SKIP,
                 vested_balance=APIHelper.SKIP,
                 un_vested_balance=APIHelper.SKIP,
                 vested_quantity=APIHelper.SKIP,
                 un_vested_quantity=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the VestingEntity class"""

        # Initialize members of the class
        if vesting_date is not APIHelper.SKIP:
            self.vesting_date = vesting_date 
        if symbol is not APIHelper.SKIP:
            self.symbol = symbol 
        if strike_price is not APIHelper.SKIP:
            self.strike_price = strike_price 
        if vesting_percentage is not APIHelper.SKIP:
            self.vesting_percentage = vesting_percentage 
        if other_vest_amount is not APIHelper.SKIP:
            self.other_vest_amount = other_vest_amount 
        if other_vest_percentage is not APIHelper.SKIP:
            self.other_vest_percentage = other_vest_percentage 
        if vested_balance is not APIHelper.SKIP:
            self.vested_balance = vested_balance 
        if un_vested_balance is not APIHelper.SKIP:
            self.un_vested_balance = un_vested_balance 
        if vested_quantity is not APIHelper.SKIP:
            self.vested_quantity = vested_quantity 
        if un_vested_quantity is not APIHelper.SKIP:
            self.un_vested_quantity = un_vested_quantity 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        vesting_date = dateutil.parser.parse(dictionary.get('vestingDate')).date() if dictionary.get('vestingDate') else APIHelper.SKIP
        symbol = dictionary.get("symbol") if dictionary.get("symbol") else APIHelper.SKIP
        strike_price = dictionary.get("strikePrice") if dictionary.get("strikePrice") else APIHelper.SKIP
        vesting_percentage = dictionary.get("vestingPercentage") if dictionary.get("vestingPercentage") else APIHelper.SKIP
        other_vest_amount = dictionary.get("otherVestAmount") if dictionary.get("otherVestAmount") else APIHelper.SKIP
        other_vest_percentage = dictionary.get("otherVestPercentage") if dictionary.get("otherVestPercentage") else APIHelper.SKIP
        vested_balance = dictionary.get("vestedBalance") if dictionary.get("vestedBalance") else APIHelper.SKIP
        un_vested_balance = dictionary.get("unVestedBalance") if dictionary.get("unVestedBalance") else APIHelper.SKIP
        vested_quantity = dictionary.get("vestedQuantity") if dictionary.get("vestedQuantity") else APIHelper.SKIP
        un_vested_quantity = dictionary.get("unVestedQuantity") if dictionary.get("unVestedQuantity") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(vesting_date,
                   symbol,
                   strike_price,
                   vesting_percentage,
                   other_vest_amount,
                   other_vest_percentage,
                   vested_balance,
                   un_vested_balance,
                   vested_quantity,
                   un_vested_quantity,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'vesting_date={(self.vesting_date if hasattr(self, "vesting_date") else None)!r}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!r}, '
                f'strike_price={(self.strike_price if hasattr(self, "strike_price") else None)!r}, '
                f'vesting_percentage={(self.vesting_percentage if hasattr(self, "vesting_percentage") else None)!r}, '
                f'other_vest_amount={(self.other_vest_amount if hasattr(self, "other_vest_amount") else None)!r}, '
                f'other_vest_percentage={(self.other_vest_percentage if hasattr(self, "other_vest_percentage") else None)!r}, '
                f'vested_balance={(self.vested_balance if hasattr(self, "vested_balance") else None)!r}, '
                f'un_vested_balance={(self.un_vested_balance if hasattr(self, "un_vested_balance") else None)!r}, '
                f'vested_quantity={(self.vested_quantity if hasattr(self, "vested_quantity") else None)!r}, '
                f'un_vested_quantity={(self.un_vested_quantity if hasattr(self, "un_vested_quantity") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'vesting_date={(self.vesting_date if hasattr(self, "vesting_date") else None)!s}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!s}, '
                f'strike_price={(self.strike_price if hasattr(self, "strike_price") else None)!s}, '
                f'vesting_percentage={(self.vesting_percentage if hasattr(self, "vesting_percentage") else None)!s}, '
                f'other_vest_amount={(self.other_vest_amount if hasattr(self, "other_vest_amount") else None)!s}, '
                f'other_vest_percentage={(self.other_vest_percentage if hasattr(self, "other_vest_percentage") else None)!s}, '
                f'vested_balance={(self.vested_balance if hasattr(self, "vested_balance") else None)!s}, '
                f'un_vested_balance={(self.un_vested_balance if hasattr(self, "un_vested_balance") else None)!s}, '
                f'vested_quantity={(self.vested_quantity if hasattr(self, "vested_quantity") else None)!s}, '
                f'un_vested_quantity={(self.un_vested_quantity if hasattr(self, "un_vested_quantity") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
