
# Getting Started with FDX API

## Introduction

Financial Data Exchange V6.2.0 Consent API

## Install the Package

The package is compatible with Python versions `3.7+`.
Install the package from PyPi using the following pip command:

```bash
pip install fdx-api-sdk-python==1.0.0
```

You can also view the package at:
https://pypi.python.org/pypi/fdx-api-sdk-python/1.0.0

## Initialize the API Client

**_Note:_** Documentation for the client can be found [here.](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/client.md)

The following parameters are configurable for the API Client:

| Parameter | Type | Description |
|  --- | --- | --- |
| environment | `Environment` | The API environment. <br> **Default: `Environment.PRODUCTION`** |
| http_client_instance | `HttpClient` | The Http Client passed from the sdk user for making requests |
| override_http_client_configuration | `bool` | The value which determines to override properties of the passed Http Client from the sdk user |
| http_call_back | `HttpCallBack` | The callback value that is invoked before and after an HTTP call is made to an endpoint |
| timeout | `float` | The value to use for connection timeout. <br> **Default: 60** |
| max_retries | `int` | The number of times to retry an endpoint call if it fails. <br> **Default: 0** |
| backoff_factor | `float` | A backoff factor to apply between attempts after the second try. <br> **Default: 2** |
| retry_statuses | `Array of int` | The http statuses on which retry is to be done. <br> **Default: [408, 413, 429, 500, 502, 503, 504, 521, 522, 524]** |
| retry_methods | `Array of string` | The http methods on which retry is to be done. <br> **Default: ['GET', 'PUT']** |
| proxy_settings | [`ProxySettings`](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/proxy-settings.md) | Optional proxy configuration to route HTTP requests through a proxy server. |
| logging_configuration | [`LoggingConfiguration`](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/logging-configuration.md) | The SDK logging configuration for API calls |
| bearer_auth_credentials | [`BearerAuthCredentials`](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/auth/oauth-2-bearer-token.md) | The credential object for OAuth 2 Bearer token |
| tax_basic_auth_credentials | [`TaxBasicAuthCredentials`](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/auth/basic-authentication.md) | The credential object for Basic Authentication |

The API client can be initialized as follows:

```python
import logging

from fdxapi.configuration import Environment
from fdxapi.fdxapi_client import FdxapiClient
from fdxapi.http.auth.bearer_auth import BearerAuthCredentials
from fdxapi.http.auth.tax_basic_auth import TaxBasicAuthCredentials
from fdxapi.logging.configuration.api_logging_configuration import LoggingConfiguration
from fdxapi.logging.configuration.api_logging_configuration import RequestLoggingConfiguration
from fdxapi.logging.configuration.api_logging_configuration import ResponseLoggingConfiguration

client = FdxapiClient(
    bearer_auth_credentials=BearerAuthCredentials(
        access_token='AccessToken'
    ),
    tax_basic_auth_credentials=TaxBasicAuthCredentials(
        username='Username',
        password='Password'
    ),
    environment=Environment.PRODUCTION,
    logging_configuration=LoggingConfiguration(
        log_level=logging.INFO,
        request_logging_config=RequestLoggingConfiguration(
            log_body=True
        ),
        response_logging_config=ResponseLoggingConfiguration(
            log_headers=True
        )
    )
)
```

## Authorization

This API uses the following authentication schemes.

* [`bearerAuth (OAuth 2 Bearer token)`](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/auth/oauth-2-bearer-token.md)
* [`TaxBasicAuth (Basic Authentication)`](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/auth/basic-authentication.md)

## List of APIs

* [User Consent](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/user-consent.md)
* [Account Information](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/account-information.md)
* [Account Statements](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/account-statements.md)
* [Account Transactions](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/account-transactions.md)
* [Money Movement](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/money-movement.md)
* [Personal Information](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/personal-information.md)
* [Reward Program Categories](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/reward-program-categories.md)
* [Reward Program Information](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/reward-program-information.md)
* [Event Notifications](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/event-notifications.md)
* [Fraud Notification](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/fraud-notification.md)
* [Internal Transfers](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/internal-transfers.md)
* [Payee Management](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/payee-management.md)
* [Payment Initiation Parties](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/payment-initiation-parties.md)
* [Recurring Payments](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/recurring-payments.md)
* [Payroll Information](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/payroll-information.md)
* [Submit Tax Forms](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/submit-tax-forms.md)
* [Tax Forms](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/tax-forms.md)
* [Resource Information](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/resource-information.md)
* [Meta](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/meta.md)
* [Payments](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/payments.md)
* [Recipients](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/controllers/recipients.md)

## SDK Infrastructure

### Configuration

* [ProxySettings](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/proxy-settings.md)
* [AbstractLogger](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/abstract-logger.md)
* [LoggingConfiguration](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/logging-configuration.md)
* [RequestLoggingConfiguration](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/request-logging-configuration.md)
* [ResponseLoggingConfiguration](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/response-logging-configuration.md)

### HTTP

* [HttpResponse](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/http-response.md)
* [HttpRequest](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/http-request.md)

### Utilities

* [ApiResponse](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/api-response.md)
* [ApiHelper](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/api-helper.md)
* [HttpDateTime](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/http-date-time.md)
* [RFC3339DateTime](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/rfc3339-date-time.md)
* [UnixDateTime](https://www.github.com/sdks-io/fdx-api-python-sdk/tree/1.0.0/doc/unix-date-time.md)

