# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.tax_statement_2 import TaxStatement2
from fdxapi.exceptions.error_exception import ErrorException


class SubmitTaxFormsController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(SubmitTaxFormsController, self).__init__(config)

    def create_tax_form(self,
                        authorization,
                        x_fapi_interaction_id,
                        fdx_api_actor_type=None,
                        body=None):
        """Does a POST request to /tax-forms.

        Submit the data for a specific tax document

        Args:
            authorization (str): The [Authorization HTTP request
                header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Heade
                rs/Authorization) provides credentials to allow access to a
                protected resources
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (TaxStatement1, optional): The request body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Created
                document for the tax data submitted

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.USTAX)
            .path('/tax-forms')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Authorization')
                          .value(authorization)
                          .is_required(True))
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TaxStatement2.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Tax Form type is not supported', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def update_tax_form(self,
                        tax_form_id,
                        authorization,
                        x_fapi_interaction_id,
                        fdx_api_actor_type=None,
                        body=None):
        """Does a PUT request to /tax-forms/{taxFormId}.

        Update tax document. Allows you to upload and replace binaries or json
        document

        Args:
            tax_form_id (str): The unique ID for this tax form or tax statement
            authorization (str): The [Authorization HTTP request
                header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Heade
                rs/Authorization) provides credentials to allow access to a
                protected resources
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (TaxStatement6, optional): The request body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.USTAX)
            .path('/tax-forms/{taxFormId}')
            .http_method(HttpMethodEnum.PUT)
            .template_param(Parameter()
                            .key('taxFormId')
                            .value(tax_form_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Authorization')
                          .value(authorization)
                          .is_required(True))
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
            .local_error('415', 'Server does not support the content type uploaded', ErrorException)
        ).execute()
