# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.exceptions.api_exception import ApiException


class ErrorException(ApiException):
    def __init__(self, reason, response):
        """Constructor for the ErrorException class

        Args:
            reason (string): The reason (or error message) for the Exception
                to be raised.
            response (HttpResponse): The HttpResponse of the API call.

        """
        super(ErrorException, self).__init__(reason, response)
        dictionary = APIHelper.json_deserialize(self.response.text)
        if isinstance(dictionary, dict):
            self.unbox(dictionary)

    def unbox(self, dictionary):
        """Populates the properties of this object by extracting them from a dictionary.

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        """
        self.code = dictionary.get("code") if dictionary.get("code") else None
        self.message = dictionary.get("message") if dictionary.get("message") else None
        self.debug_message = dictionary.get("debugMessage") if dictionary.get("debugMessage") else None

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'code={(self.code if hasattr(self, "code") else None)!s}, '
                f'message={(self.message if hasattr(self, "message") else None)!s}, '
                f'debug_message={(self.debug_message if hasattr(self, "debug_message") else None)!s})')
