# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

import dateutil.parser
from fdxapi.api_helper import APIHelper
from fdxapi.exceptions.api_exception import ApiException
from fdxapi.models.hateoas_link import HateoasLink


class PaymentEntityErrorException(ApiException):
    def __init__(self, reason, response):
        """Constructor for the PaymentEntityErrorException class

        Args:
            reason (string): The reason (or error message) for the Exception
                to be raised.
            response (HttpResponse): The HttpResponse of the API call.

        """
        super(PaymentEntityErrorException, self).__init__(reason, response)
        dictionary = APIHelper.json_deserialize(self.response.text)
        if isinstance(dictionary, dict):
            self.unbox(dictionary)

    def unbox(self, dictionary):
        """Populates the properties of this object by extracting them from a dictionary.

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        """
        self.from_account_id = dictionary.get("fromAccountId") if dictionary.get("fromAccountId") else None
        self.to_payee_id = dictionary.get("toPayeeId") if dictionary.get("toPayeeId") else None
        self.amount = dictionary.get("amount") if dictionary.get("amount") else None
        self.merchant_account_id = dictionary.get("merchantAccountId") if dictionary.get("merchantAccountId") else None
        self.due_date = dateutil.parser.parse(dictionary.get('dueDate')).date() if dictionary.get('dueDate') else None
        self.payment_id = dictionary.get("paymentId") if dictionary.get("paymentId") else None
        self.recurring_payment_id = dictionary.get("recurringPaymentId") if dictionary.get("recurringPaymentId") else None
        self.scheduled_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("scheduledTimestamp")).datetime if dictionary.get("scheduledTimestamp") else None
        self.processed_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("processedTimestamp")).datetime if dictionary.get("processedTimestamp") else None
        self.failed_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("failedTimestamp")).datetime if dictionary.get("failedTimestamp") else None
        self.cancelled_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("cancelledTimestamp")).datetime if dictionary.get("cancelledTimestamp") else None
        self.started_processing_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("startedProcessingTimestamp")).datetime if dictionary.get("startedProcessingTimestamp") else None
        self.status = dictionary.get("status") if dictionary.get("status") else None
        self.links = None
        if dictionary.get('links') is not None:
            self.links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            self.links = None

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'from_account_id={self.from_account_id!s}, '
                f'to_payee_id={self.to_payee_id!s}, '
                f'amount={self.amount!s}, '
                f'merchant_account_id={(self.merchant_account_id if hasattr(self, "merchant_account_id") else None)!s}, '
                f'due_date={self.due_date!s}, '
                f'payment_id={self.payment_id!s}, '
                f'recurring_payment_id={(self.recurring_payment_id if hasattr(self, "recurring_payment_id") else None)!s}, '
                f'scheduled_timestamp={(self.scheduled_timestamp if hasattr(self, "scheduled_timestamp") else None)!s}, '
                f'processed_timestamp={(self.processed_timestamp if hasattr(self, "processed_timestamp") else None)!s}, '
                f'failed_timestamp={(self.failed_timestamp if hasattr(self, "failed_timestamp") else None)!s}, '
                f'cancelled_timestamp={(self.cancelled_timestamp if hasattr(self, "cancelled_timestamp") else None)!s}, '
                f'started_processing_timestamp={(self.started_processing_timestamp if hasattr(self, "started_processing_timestamp") else None)!s}, '
                f'status={self.status!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s})')
