# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class AssetTransferNetwork(object):

    """Implementation of the 'Asset Transfer Network' model.

    Information required to facilitate asset transfer from this account

    Attributes:
        identifier (str): The number used to identify the account within the
            asset transfer network. If identifierType is ACCOUNT_NUMBER, this
            is the account number; if identifierType is
            TOKENIZED_ACCOUNT_NUMBER, this is a tokenized account number
        identifier_type (PaymentNetworkIdentifierType1): Type of identifier
        institution_name (str): The name of the institution holding the account
        institution_id (str): Institution identifier used by the asset
            transfer network ie. the Depository Trust and Clearing Corporation
            code for the institution holding the account
        mtype (AssetTransferType2): Type of asset transfer
        joint_account (bool): Whether this account has joint owners
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "identifier": 'identifier',
        "identifier_type": 'identifierType',
        "institution_name": 'institutionName',
        "institution_id": 'institutionId',
        "mtype": 'type',
        "joint_account": 'jointAccount'
    }

    _optionals = [
        'identifier',
        'identifier_type',
        'institution_name',
        'institution_id',
        'mtype',
        'joint_account',
    ]

    def __init__(self,
                 identifier=APIHelper.SKIP,
                 identifier_type=APIHelper.SKIP,
                 institution_name=APIHelper.SKIP,
                 institution_id=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 joint_account=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AssetTransferNetwork class"""

        # Initialize members of the class
        if identifier is not APIHelper.SKIP:
            self.identifier = identifier 
        if identifier_type is not APIHelper.SKIP:
            self.identifier_type = identifier_type 
        if institution_name is not APIHelper.SKIP:
            self.institution_name = institution_name 
        if institution_id is not APIHelper.SKIP:
            self.institution_id = institution_id 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if joint_account is not APIHelper.SKIP:
            self.joint_account = joint_account 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        identifier = dictionary.get("identifier") if dictionary.get("identifier") else APIHelper.SKIP
        identifier_type = dictionary.get("identifierType") if dictionary.get("identifierType") else APIHelper.SKIP
        institution_name = dictionary.get("institutionName") if dictionary.get("institutionName") else APIHelper.SKIP
        institution_id = dictionary.get("institutionId") if dictionary.get("institutionId") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        joint_account = dictionary.get("jointAccount") if "jointAccount" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(identifier,
                   identifier_type,
                   institution_name,
                   institution_id,
                   mtype,
                   joint_account,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'identifier={(self.identifier if hasattr(self, "identifier") else None)!r}, '
                f'identifier_type={(self.identifier_type if hasattr(self, "identifier_type") else None)!r}, '
                f'institution_name={(self.institution_name if hasattr(self, "institution_name") else None)!r}, '
                f'institution_id={(self.institution_id if hasattr(self, "institution_id") else None)!r}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'joint_account={(self.joint_account if hasattr(self, "joint_account") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'identifier={(self.identifier if hasattr(self, "identifier") else None)!s}, '
                f'identifier_type={(self.identifier_type if hasattr(self, "identifier_type") else None)!s}, '
                f'institution_name={(self.institution_name if hasattr(self, "institution_name") else None)!s}, '
                f'institution_id={(self.institution_id if hasattr(self, "institution_id") else None)!s}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'joint_account={(self.joint_account if hasattr(self, "joint_account") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
