# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.availability_entity import AvailabilityEntity


class AvailabilityListEntity(object):

    """Implementation of the 'Availability List entity' model.

    Response object for /availability API

    Attributes:
        availability (List[AvailabilityEntity]): Zero or more API availability
            metrics
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "availability": 'availability'
    }

    _optionals = [
        'availability',
    ]

    def __init__(self,
                 availability=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AvailabilityListEntity class"""

        # Initialize members of the class
        if availability is not APIHelper.SKIP:
            self.availability = availability 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        availability = None
        if dictionary.get('availability') is not None:
            availability = [AvailabilityEntity.from_dictionary(x) for x in dictionary.get('availability')]
        else:
            availability = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(availability,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'availability={(self.availability if hasattr(self, "availability") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'availability={(self.availability if hasattr(self, "availability") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
