# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.monetary_amount import MonetaryAmount


class BasePayrollRate1(object):

    """Implementation of the 'Base Payroll Rate1' model.

    The employee's base payroll rate

    Attributes:
        rate (MonetaryAmount): The amount and currency of the base pay rate of
            employee
        rate_type (PayrollRateType2): Whether the worker's rate is ANNUAL,
            DAILY, HOURLY, OTHER
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "rate": 'rate',
        "rate_type": 'rateType'
    }

    def __init__(self,
                 rate=None,
                 rate_type=None,
                 additional_properties=None):
        """Constructor for the BasePayrollRate1 class"""

        # Initialize members of the class
        self.rate = rate 
        self.rate_type = rate_type 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        rate = MonetaryAmount.from_dictionary(dictionary.get('rate')) if dictionary.get('rate') else None
        rate_type = dictionary.get("rateType") if dictionary.get("rateType") else None
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(rate,
                   rate_type,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'rate={self.rate!r}, '
                f'rate_type={self.rate_type!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'rate={self.rate!s}, '
                f'rate_type={self.rate_type!s}, '
                f'additional_properties={self.additional_properties!s})')
