# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class BasicAuthCredentials1(object):

    """Implementation of the 'Basic Auth Credentials1' model.

    The Basic Authentication credentials to retrieve a tax form

    Attributes:
        tax_year (int): Year for which taxes are being paid
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        id (str): Confidential and unique identifier of the tax form
        passcode (str): Unique, randomized and restricted password for this
            document
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "tax_form_type": 'taxFormType',
        "id": 'id',
        "passcode": 'passcode'
    }

    _optionals = [
        'tax_year',
        'tax_form_type',
        'id',
        'passcode',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 passcode=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the BasicAuthCredentials1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if id is not APIHelper.SKIP:
            self.id = id 
        if passcode is not APIHelper.SKIP:
            self.passcode = passcode 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        passcode = dictionary.get("passcode") if dictionary.get("passcode") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   tax_form_type,
                   id,
                   passcode,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'id={(self.id if hasattr(self, "id") else None)!r}, '
                f'passcode={(self.passcode if hasattr(self, "passcode") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'id={(self.id if hasattr(self, "id") else None)!s}, '
                f'passcode={(self.passcode if hasattr(self, "passcode") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
