# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.date_and_amount import DateAndAmount
from fdxapi.models.description_and_amount import DescriptionAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class BusinessIncomeStatement(object):

    """Implementation of the 'Business Income Statement' model.

    Business Income Statement for IRS Form 1040 Schedule C

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        business_name (str): Box C, Business name
        sales (float): Box 1, Gross receipts or sales
        returns (float): Box 2, Returns and allowances
        other_income (List[DescriptionAndAmount]): Box 6, Other income,
            including federal and state gasoline or fuel tax credit or refund
        advertising (float): Box 8, Advertising
        car_and_truck (float): Box 9, Car and truck expenses
        commissions (float): Box 10, Commissions and fees
        contract_labor (float): Box 11, Contract labor
        depletion (float): Box 12, Depletion
        depreciation (float): Box 13, Depreciation
        employee_benefits (float): Box 14, Employee benefit programs
        insurance (float): Box 15, Insurance
        mortgage_interest (float): Box 16a, Mortgage interest
        other_interest (float): Box 16b, Other interest
        legal (float): Box 17, Legal and professional services
        office (float): Box 18, Office expense
        pension (float): Box 19, Pension and profit-sharing plans
        equipment_rent (float): Box 20a, Equipment rent
        other_rent (float): Box 20b, Other rent
        repairs (float): Box 21, Repairs and maintenance
        supplies (float): Box 22, Supplies
        taxes (float): Box 23, Taxes and licenses
        travel (float): Box 24a, Travel
        meals (float): Box 24b, Deductible meals
        utilities (float): Box 25, Utilities
        wages (float): Box 26, Wages
        other_expenses (List[DescriptionAndAmount]): Box 27, Other expenses
        beginning_inventory (float): Box 35, Inventory at beginning of year
        purchases (float): Box 36, Purchases
        cost_of_labor (float): Box 37, Cost of labor
        materials (float): Box 38, Materials and supplies
        other_costs (List[DescriptionAndAmount]): Box 39, Other costs
        ending_inventory (float): Box 41, Inventory at end of year
        capital_expenditures (List[DateAndAmount]): Capital expenditures, for
            use in calculating Depreciation
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "business_name": 'businessName',
        "sales": 'sales',
        "returns": 'returns',
        "other_income": 'otherIncome',
        "advertising": 'advertising',
        "car_and_truck": 'carAndTruck',
        "commissions": 'commissions',
        "contract_labor": 'contractLabor',
        "depletion": 'depletion',
        "depreciation": 'depreciation',
        "employee_benefits": 'employeeBenefits',
        "insurance": 'insurance',
        "mortgage_interest": 'mortgageInterest',
        "other_interest": 'otherInterest',
        "legal": 'legal',
        "office": 'office',
        "pension": 'pension',
        "equipment_rent": 'equipmentRent',
        "other_rent": 'otherRent',
        "repairs": 'repairs',
        "supplies": 'supplies',
        "taxes": 'taxes',
        "travel": 'travel',
        "meals": 'meals',
        "utilities": 'utilities',
        "wages": 'wages',
        "other_expenses": 'otherExpenses',
        "beginning_inventory": 'beginningInventory',
        "purchases": 'purchases',
        "cost_of_labor": 'costOfLabor',
        "materials": 'materials',
        "other_costs": 'otherCosts',
        "ending_inventory": 'endingInventory',
        "capital_expenditures": 'capitalExpenditures'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'business_name',
        'sales',
        'returns',
        'other_income',
        'advertising',
        'car_and_truck',
        'commissions',
        'contract_labor',
        'depletion',
        'depreciation',
        'employee_benefits',
        'insurance',
        'mortgage_interest',
        'other_interest',
        'legal',
        'office',
        'pension',
        'equipment_rent',
        'other_rent',
        'repairs',
        'supplies',
        'taxes',
        'travel',
        'meals',
        'utilities',
        'wages',
        'other_expenses',
        'beginning_inventory',
        'purchases',
        'cost_of_labor',
        'materials',
        'other_costs',
        'ending_inventory',
        'capital_expenditures',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 business_name=APIHelper.SKIP,
                 sales=APIHelper.SKIP,
                 returns=APIHelper.SKIP,
                 other_income=APIHelper.SKIP,
                 advertising=APIHelper.SKIP,
                 car_and_truck=APIHelper.SKIP,
                 commissions=APIHelper.SKIP,
                 contract_labor=APIHelper.SKIP,
                 depletion=APIHelper.SKIP,
                 depreciation=APIHelper.SKIP,
                 employee_benefits=APIHelper.SKIP,
                 insurance=APIHelper.SKIP,
                 mortgage_interest=APIHelper.SKIP,
                 other_interest=APIHelper.SKIP,
                 legal=APIHelper.SKIP,
                 office=APIHelper.SKIP,
                 pension=APIHelper.SKIP,
                 equipment_rent=APIHelper.SKIP,
                 other_rent=APIHelper.SKIP,
                 repairs=APIHelper.SKIP,
                 supplies=APIHelper.SKIP,
                 taxes=APIHelper.SKIP,
                 travel=APIHelper.SKIP,
                 meals=APIHelper.SKIP,
                 utilities=APIHelper.SKIP,
                 wages=APIHelper.SKIP,
                 other_expenses=APIHelper.SKIP,
                 beginning_inventory=APIHelper.SKIP,
                 purchases=APIHelper.SKIP,
                 cost_of_labor=APIHelper.SKIP,
                 materials=APIHelper.SKIP,
                 other_costs=APIHelper.SKIP,
                 ending_inventory=APIHelper.SKIP,
                 capital_expenditures=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the BusinessIncomeStatement class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if business_name is not APIHelper.SKIP:
            self.business_name = business_name 
        if sales is not APIHelper.SKIP:
            self.sales = sales 
        if returns is not APIHelper.SKIP:
            self.returns = returns 
        if other_income is not APIHelper.SKIP:
            self.other_income = other_income 
        if advertising is not APIHelper.SKIP:
            self.advertising = advertising 
        if car_and_truck is not APIHelper.SKIP:
            self.car_and_truck = car_and_truck 
        if commissions is not APIHelper.SKIP:
            self.commissions = commissions 
        if contract_labor is not APIHelper.SKIP:
            self.contract_labor = contract_labor 
        if depletion is not APIHelper.SKIP:
            self.depletion = depletion 
        if depreciation is not APIHelper.SKIP:
            self.depreciation = depreciation 
        if employee_benefits is not APIHelper.SKIP:
            self.employee_benefits = employee_benefits 
        if insurance is not APIHelper.SKIP:
            self.insurance = insurance 
        if mortgage_interest is not APIHelper.SKIP:
            self.mortgage_interest = mortgage_interest 
        if other_interest is not APIHelper.SKIP:
            self.other_interest = other_interest 
        if legal is not APIHelper.SKIP:
            self.legal = legal 
        if office is not APIHelper.SKIP:
            self.office = office 
        if pension is not APIHelper.SKIP:
            self.pension = pension 
        if equipment_rent is not APIHelper.SKIP:
            self.equipment_rent = equipment_rent 
        if other_rent is not APIHelper.SKIP:
            self.other_rent = other_rent 
        if repairs is not APIHelper.SKIP:
            self.repairs = repairs 
        if supplies is not APIHelper.SKIP:
            self.supplies = supplies 
        if taxes is not APIHelper.SKIP:
            self.taxes = taxes 
        if travel is not APIHelper.SKIP:
            self.travel = travel 
        if meals is not APIHelper.SKIP:
            self.meals = meals 
        if utilities is not APIHelper.SKIP:
            self.utilities = utilities 
        if wages is not APIHelper.SKIP:
            self.wages = wages 
        if other_expenses is not APIHelper.SKIP:
            self.other_expenses = other_expenses 
        if beginning_inventory is not APIHelper.SKIP:
            self.beginning_inventory = beginning_inventory 
        if purchases is not APIHelper.SKIP:
            self.purchases = purchases 
        if cost_of_labor is not APIHelper.SKIP:
            self.cost_of_labor = cost_of_labor 
        if materials is not APIHelper.SKIP:
            self.materials = materials 
        if other_costs is not APIHelper.SKIP:
            self.other_costs = other_costs 
        if ending_inventory is not APIHelper.SKIP:
            self.ending_inventory = ending_inventory 
        if capital_expenditures is not APIHelper.SKIP:
            self.capital_expenditures = capital_expenditures 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        business_name = dictionary.get("businessName") if dictionary.get("businessName") else APIHelper.SKIP
        sales = dictionary.get("sales") if dictionary.get("sales") else APIHelper.SKIP
        returns = dictionary.get("returns") if dictionary.get("returns") else APIHelper.SKIP
        other_income = None
        if dictionary.get('otherIncome') is not None:
            other_income = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('otherIncome')]
        else:
            other_income = APIHelper.SKIP
        advertising = dictionary.get("advertising") if dictionary.get("advertising") else APIHelper.SKIP
        car_and_truck = dictionary.get("carAndTruck") if dictionary.get("carAndTruck") else APIHelper.SKIP
        commissions = dictionary.get("commissions") if dictionary.get("commissions") else APIHelper.SKIP
        contract_labor = dictionary.get("contractLabor") if dictionary.get("contractLabor") else APIHelper.SKIP
        depletion = dictionary.get("depletion") if dictionary.get("depletion") else APIHelper.SKIP
        depreciation = dictionary.get("depreciation") if dictionary.get("depreciation") else APIHelper.SKIP
        employee_benefits = dictionary.get("employeeBenefits") if dictionary.get("employeeBenefits") else APIHelper.SKIP
        insurance = dictionary.get("insurance") if dictionary.get("insurance") else APIHelper.SKIP
        mortgage_interest = dictionary.get("mortgageInterest") if dictionary.get("mortgageInterest") else APIHelper.SKIP
        other_interest = dictionary.get("otherInterest") if dictionary.get("otherInterest") else APIHelper.SKIP
        legal = dictionary.get("legal") if dictionary.get("legal") else APIHelper.SKIP
        office = dictionary.get("office") if dictionary.get("office") else APIHelper.SKIP
        pension = dictionary.get("pension") if dictionary.get("pension") else APIHelper.SKIP
        equipment_rent = dictionary.get("equipmentRent") if dictionary.get("equipmentRent") else APIHelper.SKIP
        other_rent = dictionary.get("otherRent") if dictionary.get("otherRent") else APIHelper.SKIP
        repairs = dictionary.get("repairs") if dictionary.get("repairs") else APIHelper.SKIP
        supplies = dictionary.get("supplies") if dictionary.get("supplies") else APIHelper.SKIP
        taxes = dictionary.get("taxes") if dictionary.get("taxes") else APIHelper.SKIP
        travel = dictionary.get("travel") if dictionary.get("travel") else APIHelper.SKIP
        meals = dictionary.get("meals") if dictionary.get("meals") else APIHelper.SKIP
        utilities = dictionary.get("utilities") if dictionary.get("utilities") else APIHelper.SKIP
        wages = dictionary.get("wages") if dictionary.get("wages") else APIHelper.SKIP
        other_expenses = None
        if dictionary.get('otherExpenses') is not None:
            other_expenses = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('otherExpenses')]
        else:
            other_expenses = APIHelper.SKIP
        beginning_inventory = dictionary.get("beginningInventory") if dictionary.get("beginningInventory") else APIHelper.SKIP
        purchases = dictionary.get("purchases") if dictionary.get("purchases") else APIHelper.SKIP
        cost_of_labor = dictionary.get("costOfLabor") if dictionary.get("costOfLabor") else APIHelper.SKIP
        materials = dictionary.get("materials") if dictionary.get("materials") else APIHelper.SKIP
        other_costs = None
        if dictionary.get('otherCosts') is not None:
            other_costs = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('otherCosts')]
        else:
            other_costs = APIHelper.SKIP
        ending_inventory = dictionary.get("endingInventory") if dictionary.get("endingInventory") else APIHelper.SKIP
        capital_expenditures = None
        if dictionary.get('capitalExpenditures') is not None:
            capital_expenditures = [DateAndAmount.from_dictionary(x) for x in dictionary.get('capitalExpenditures')]
        else:
            capital_expenditures = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   business_name,
                   sales,
                   returns,
                   other_income,
                   advertising,
                   car_and_truck,
                   commissions,
                   contract_labor,
                   depletion,
                   depreciation,
                   employee_benefits,
                   insurance,
                   mortgage_interest,
                   other_interest,
                   legal,
                   office,
                   pension,
                   equipment_rent,
                   other_rent,
                   repairs,
                   supplies,
                   taxes,
                   travel,
                   meals,
                   utilities,
                   wages,
                   other_expenses,
                   beginning_inventory,
                   purchases,
                   cost_of_labor,
                   materials,
                   other_costs,
                   ending_inventory,
                   capital_expenditures,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'business_name={(self.business_name if hasattr(self, "business_name") else None)!r}, '
                f'sales={(self.sales if hasattr(self, "sales") else None)!r}, '
                f'returns={(self.returns if hasattr(self, "returns") else None)!r}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!r}, '
                f'advertising={(self.advertising if hasattr(self, "advertising") else None)!r}, '
                f'car_and_truck={(self.car_and_truck if hasattr(self, "car_and_truck") else None)!r}, '
                f'commissions={(self.commissions if hasattr(self, "commissions") else None)!r}, '
                f'contract_labor={(self.contract_labor if hasattr(self, "contract_labor") else None)!r}, '
                f'depletion={(self.depletion if hasattr(self, "depletion") else None)!r}, '
                f'depreciation={(self.depreciation if hasattr(self, "depreciation") else None)!r}, '
                f'employee_benefits={(self.employee_benefits if hasattr(self, "employee_benefits") else None)!r}, '
                f'insurance={(self.insurance if hasattr(self, "insurance") else None)!r}, '
                f'mortgage_interest={(self.mortgage_interest if hasattr(self, "mortgage_interest") else None)!r}, '
                f'other_interest={(self.other_interest if hasattr(self, "other_interest") else None)!r}, '
                f'legal={(self.legal if hasattr(self, "legal") else None)!r}, '
                f'office={(self.office if hasattr(self, "office") else None)!r}, '
                f'pension={(self.pension if hasattr(self, "pension") else None)!r}, '
                f'equipment_rent={(self.equipment_rent if hasattr(self, "equipment_rent") else None)!r}, '
                f'other_rent={(self.other_rent if hasattr(self, "other_rent") else None)!r}, '
                f'repairs={(self.repairs if hasattr(self, "repairs") else None)!r}, '
                f'supplies={(self.supplies if hasattr(self, "supplies") else None)!r}, '
                f'taxes={(self.taxes if hasattr(self, "taxes") else None)!r}, '
                f'travel={(self.travel if hasattr(self, "travel") else None)!r}, '
                f'meals={(self.meals if hasattr(self, "meals") else None)!r}, '
                f'utilities={(self.utilities if hasattr(self, "utilities") else None)!r}, '
                f'wages={(self.wages if hasattr(self, "wages") else None)!r}, '
                f'other_expenses={(self.other_expenses if hasattr(self, "other_expenses") else None)!r}, '
                f'beginning_inventory={(self.beginning_inventory if hasattr(self, "beginning_inventory") else None)!r}, '
                f'purchases={(self.purchases if hasattr(self, "purchases") else None)!r}, '
                f'cost_of_labor={(self.cost_of_labor if hasattr(self, "cost_of_labor") else None)!r}, '
                f'materials={(self.materials if hasattr(self, "materials") else None)!r}, '
                f'other_costs={(self.other_costs if hasattr(self, "other_costs") else None)!r}, '
                f'ending_inventory={(self.ending_inventory if hasattr(self, "ending_inventory") else None)!r}, '
                f'capital_expenditures={(self.capital_expenditures if hasattr(self, "capital_expenditures") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'business_name={(self.business_name if hasattr(self, "business_name") else None)!s}, '
                f'sales={(self.sales if hasattr(self, "sales") else None)!s}, '
                f'returns={(self.returns if hasattr(self, "returns") else None)!s}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!s}, '
                f'advertising={(self.advertising if hasattr(self, "advertising") else None)!s}, '
                f'car_and_truck={(self.car_and_truck if hasattr(self, "car_and_truck") else None)!s}, '
                f'commissions={(self.commissions if hasattr(self, "commissions") else None)!s}, '
                f'contract_labor={(self.contract_labor if hasattr(self, "contract_labor") else None)!s}, '
                f'depletion={(self.depletion if hasattr(self, "depletion") else None)!s}, '
                f'depreciation={(self.depreciation if hasattr(self, "depreciation") else None)!s}, '
                f'employee_benefits={(self.employee_benefits if hasattr(self, "employee_benefits") else None)!s}, '
                f'insurance={(self.insurance if hasattr(self, "insurance") else None)!s}, '
                f'mortgage_interest={(self.mortgage_interest if hasattr(self, "mortgage_interest") else None)!s}, '
                f'other_interest={(self.other_interest if hasattr(self, "other_interest") else None)!s}, '
                f'legal={(self.legal if hasattr(self, "legal") else None)!s}, '
                f'office={(self.office if hasattr(self, "office") else None)!s}, '
                f'pension={(self.pension if hasattr(self, "pension") else None)!s}, '
                f'equipment_rent={(self.equipment_rent if hasattr(self, "equipment_rent") else None)!s}, '
                f'other_rent={(self.other_rent if hasattr(self, "other_rent") else None)!s}, '
                f'repairs={(self.repairs if hasattr(self, "repairs") else None)!s}, '
                f'supplies={(self.supplies if hasattr(self, "supplies") else None)!s}, '
                f'taxes={(self.taxes if hasattr(self, "taxes") else None)!s}, '
                f'travel={(self.travel if hasattr(self, "travel") else None)!s}, '
                f'meals={(self.meals if hasattr(self, "meals") else None)!s}, '
                f'utilities={(self.utilities if hasattr(self, "utilities") else None)!s}, '
                f'wages={(self.wages if hasattr(self, "wages") else None)!s}, '
                f'other_expenses={(self.other_expenses if hasattr(self, "other_expenses") else None)!s}, '
                f'beginning_inventory={(self.beginning_inventory if hasattr(self, "beginning_inventory") else None)!s}, '
                f'purchases={(self.purchases if hasattr(self, "purchases") else None)!s}, '
                f'cost_of_labor={(self.cost_of_labor if hasattr(self, "cost_of_labor") else None)!s}, '
                f'materials={(self.materials if hasattr(self, "materials") else None)!s}, '
                f'other_costs={(self.other_costs if hasattr(self, "other_costs") else None)!s}, '
                f'ending_inventory={(self.ending_inventory if hasattr(self, "ending_inventory") else None)!s}, '
                f'capital_expenditures={(self.capital_expenditures if hasattr(self, "capital_expenditures") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
