# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class CardArtEntity(object):

    """Implementation of the 'Card Art entity' model.

    Art associated with the card

    Attributes:
        label (str): Display label for the specific image
        image_uri (str): The
            [URI](https://datatracker.ietf.org/doc/html/rfc2397) link of a
            PNG, JPG or GIF image with proportions defined by [ISO 8710
            ID-1](https://en.wikipedia.org/wiki/ISO/IEC_7810) with 340x210
            ratio and width no greater than 512 pixels. The image at this URI
            must be accessible at all times, with no additional authentication
            headers. Typically this is an image resource located in the data
            provider's public web site or Content Delivery Network
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "label": 'label',
        "image_uri": 'imageUri'
    }

    _optionals = [
        'label',
        'image_uri',
    ]

    def __init__(self,
                 label=APIHelper.SKIP,
                 image_uri=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CardArtEntity class"""

        # Initialize members of the class
        if label is not APIHelper.SKIP:
            self.label = label 
        if image_uri is not APIHelper.SKIP:
            self.image_uri = image_uri 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        label = dictionary.get("label") if dictionary.get("label") else APIHelper.SKIP
        image_uri = dictionary.get("imageUri") if dictionary.get("imageUri") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(label,
                   image_uri,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'label={(self.label if hasattr(self, "label") else None)!r}, '
                f'image_uri={(self.image_uri if hasattr(self, "image_uri") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'label={(self.label if hasattr(self, "label") else None)!s}, '
                f'image_uri={(self.image_uri if hasattr(self, "image_uri") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
