# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.consent_grant_resource_entity import ConsentGrantResourceEntity
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.party_entity import PartyEntity


class ConsentGrantEntity(object):

    """Implementation of the 'Consent Grant entity' model.

    Record of user consent

    Attributes:
        id (str): The persistent identifier of the consent
        status (ConsentGrantStatus3): The current status of the consent
        parties (List[PartyEntity]): The non-end user parties participating in
            the Consent Grant
        created_time (datetime): When the consent was initially granted
        expiration_time (datetime): When the consent grant will become expired
        updated_time (datetime): When the consent grant was updated
        duration_type (ConsentDurationType): The type of duration of the
            consent
        duration_period (int): The consent duration in days from day of
            original grant
        lookback_period (int): Period, in days, for which historical data may
            be requested; measured from request time, not grant time
        resources (List[ConsentGrantResourceEntity]): The permissioned
            resource entities
        links (List[HateoasLink]): Links for related Consent Grant records
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "status": 'status',
        "parties": 'parties',
        "created_time": 'createdTime',
        "expiration_time": 'expirationTime',
        "updated_time": 'updatedTime',
        "duration_type": 'durationType',
        "duration_period": 'durationPeriod',
        "lookback_period": 'lookbackPeriod',
        "resources": 'resources',
        "links": 'links'
    }

    _optionals = [
        'id',
        'status',
        'parties',
        'created_time',
        'expiration_time',
        'updated_time',
        'duration_type',
        'duration_period',
        'lookback_period',
        'resources',
        'links',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 parties=APIHelper.SKIP,
                 created_time=APIHelper.SKIP,
                 expiration_time=APIHelper.SKIP,
                 updated_time=APIHelper.SKIP,
                 duration_type=APIHelper.SKIP,
                 duration_period=APIHelper.SKIP,
                 lookback_period=APIHelper.SKIP,
                 resources=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ConsentGrantEntity class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if status is not APIHelper.SKIP:
            self.status = status 
        if parties is not APIHelper.SKIP:
            self.parties = parties 
        if created_time is not APIHelper.SKIP:
            self.created_time = APIHelper.apply_datetime_converter(created_time, APIHelper.RFC3339DateTime) if created_time else None 
        if expiration_time is not APIHelper.SKIP:
            self.expiration_time = APIHelper.apply_datetime_converter(expiration_time, APIHelper.RFC3339DateTime) if expiration_time else None 
        if updated_time is not APIHelper.SKIP:
            self.updated_time = APIHelper.apply_datetime_converter(updated_time, APIHelper.RFC3339DateTime) if updated_time else None 
        if duration_type is not APIHelper.SKIP:
            self.duration_type = duration_type 
        if duration_period is not APIHelper.SKIP:
            self.duration_period = duration_period 
        if lookback_period is not APIHelper.SKIP:
            self.lookback_period = lookback_period 
        if resources is not APIHelper.SKIP:
            self.resources = resources 
        if links is not APIHelper.SKIP:
            self.links = links 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        parties = None
        if dictionary.get('parties') is not None:
            parties = [PartyEntity.from_dictionary(x) for x in dictionary.get('parties')]
        else:
            parties = APIHelper.SKIP
        created_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdTime")).datetime if dictionary.get("createdTime") else APIHelper.SKIP
        expiration_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("expirationTime")).datetime if dictionary.get("expirationTime") else APIHelper.SKIP
        updated_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("updatedTime")).datetime if dictionary.get("updatedTime") else APIHelper.SKIP
        duration_type = dictionary.get("durationType") if dictionary.get("durationType") else APIHelper.SKIP
        duration_period = dictionary.get("durationPeriod") if dictionary.get("durationPeriod") else APIHelper.SKIP
        lookback_period = dictionary.get("lookbackPeriod") if dictionary.get("lookbackPeriod") else APIHelper.SKIP
        resources = None
        if dictionary.get('resources') is not None:
            resources = [ConsentGrantResourceEntity.from_dictionary(x) for x in dictionary.get('resources')]
        else:
            resources = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(id,
                   status,
                   parties,
                   created_time,
                   expiration_time,
                   updated_time,
                   duration_type,
                   duration_period,
                   lookback_period,
                   resources,
                   links,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'id={(self.id if hasattr(self, "id") else None)!r}, '
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'parties={(self.parties if hasattr(self, "parties") else None)!r}, '
                f'created_time={(self.created_time if hasattr(self, "created_time") else None)!r}, '
                f'expiration_time={(self.expiration_time if hasattr(self, "expiration_time") else None)!r}, '
                f'updated_time={(self.updated_time if hasattr(self, "updated_time") else None)!r}, '
                f'duration_type={(self.duration_type if hasattr(self, "duration_type") else None)!r}, '
                f'duration_period={(self.duration_period if hasattr(self, "duration_period") else None)!r}, '
                f'lookback_period={(self.lookback_period if hasattr(self, "lookback_period") else None)!r}, '
                f'resources={(self.resources if hasattr(self, "resources") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'id={(self.id if hasattr(self, "id") else None)!s}, '
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'parties={(self.parties if hasattr(self, "parties") else None)!s}, '
                f'created_time={(self.created_time if hasattr(self, "created_time") else None)!s}, '
                f'expiration_time={(self.expiration_time if hasattr(self, "expiration_time") else None)!s}, '
                f'updated_time={(self.updated_time if hasattr(self, "updated_time") else None)!s}, '
                f'duration_type={(self.duration_type if hasattr(self, "duration_type") else None)!s}, '
                f'duration_period={(self.duration_period if hasattr(self, "duration_period") else None)!s}, '
                f'lookback_period={(self.lookback_period if hasattr(self, "lookback_period") else None)!s}, '
                f'resources={(self.resources if hasattr(self, "resources") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
