# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.delivery_address import DeliveryAddress
from fdxapi.models.telephone_number import TelephoneNumber


class ContactsEntity(object):

    """Implementation of the 'Contacts entity' model.

    Employer's various contact information

    Attributes:
        emails (List[str]): Array of the contact email addresses
        addresses (List[DeliveryAddress]): Array of the contact physical
            addresses
        telephones (List[TelephoneNumber]): Array of the contact telephone
            numbers
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "emails": 'emails',
        "addresses": 'addresses',
        "telephones": 'telephones'
    }

    _optionals = [
        'emails',
        'addresses',
        'telephones',
    ]

    def __init__(self,
                 emails=APIHelper.SKIP,
                 addresses=APIHelper.SKIP,
                 telephones=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ContactsEntity class"""

        # Initialize members of the class
        if emails is not APIHelper.SKIP:
            self.emails = emails 
        if addresses is not APIHelper.SKIP:
            self.addresses = addresses 
        if telephones is not APIHelper.SKIP:
            self.telephones = telephones 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        emails = dictionary.get("emails") if dictionary.get("emails") else APIHelper.SKIP
        addresses = None
        if dictionary.get('addresses') is not None:
            addresses = [DeliveryAddress.from_dictionary(x) for x in dictionary.get('addresses')]
        else:
            addresses = APIHelper.SKIP
        telephones = None
        if dictionary.get('telephones') is not None:
            telephones = [TelephoneNumber.from_dictionary(x) for x in dictionary.get('telephones')]
        else:
            telephones = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(emails,
                   addresses,
                   telephones,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'emails={(self.emails if hasattr(self, "emails") else None)!r}, '
                f'addresses={(self.addresses if hasattr(self, "addresses") else None)!r}, '
                f'telephones={(self.telephones if hasattr(self, "telephones") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'emails={(self.emails if hasattr(self, "emails") else None)!s}, '
                f'addresses={(self.addresses if hasattr(self, "addresses") else None)!s}, '
                f'telephones={(self.telephones if hasattr(self, "telephones") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
