# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class ContributionEntity(object):

    """Implementation of the 'Contribution entity' model.

    Contribution information to an investment account

    Attributes:
        security_id (str): Unique identifier of security
        security_id_type (SecurityIdType1): CINS, CMC, CME, CUSIP, ISIN, ITSA,
            NASDAQ, SEDOL, SICC, VALOR, WKN
        employer_match_percentage (float): Employer contribution match
            percentage
        employer_match_amount (float): Employer contribution match amount
        employee_pre_tax_amount (float): Employee pre-tax contribution amount
        employee_pre_tax_percentage (float): Employee pre-tax contribution
            percentage
        employee_after_tax_amount (float): Employee after tax contribution
            amount
        employee_after_tax_percentage (float): Employee after tax contribution
            percentage
        employee_defer_pre_tax_amount (float): Employee defer pre-tax
            contribution match amount
        employee_defer_pre_tax_percentage (float): Employee defer pre-tax
            contribution match percentage
        employee_year_to_date (float): Employee total year to date contribution
        employer_year_to_date (float): Employer total year to date contribution
        rollover_contribution_percentage (float): Rollover contribution
            percentage
        rollover_contribution_amount (float): Rollover contribution Amount
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "security_id": 'securityId',
        "security_id_type": 'securityIdType',
        "employer_match_percentage": 'employerMatchPercentage',
        "employer_match_amount": 'employerMatchAmount',
        "employee_pre_tax_amount": 'employeePreTaxAmount',
        "employee_pre_tax_percentage": 'employeePreTaxPercentage',
        "employee_after_tax_amount": 'employeeAfterTaxAmount',
        "employee_after_tax_percentage": 'employeeAfterTaxPercentage',
        "employee_defer_pre_tax_amount": 'employeeDeferPreTaxAmount',
        "employee_defer_pre_tax_percentage": 'employeeDeferPreTaxPercentage',
        "employee_year_to_date": 'employeeYearToDate',
        "employer_year_to_date": 'employerYearToDate',
        "rollover_contribution_percentage": 'rolloverContributionPercentage',
        "rollover_contribution_amount": 'rolloverContributionAmount'
    }

    _optionals = [
        'security_id',
        'security_id_type',
        'employer_match_percentage',
        'employer_match_amount',
        'employee_pre_tax_amount',
        'employee_pre_tax_percentage',
        'employee_after_tax_amount',
        'employee_after_tax_percentage',
        'employee_defer_pre_tax_amount',
        'employee_defer_pre_tax_percentage',
        'employee_year_to_date',
        'employer_year_to_date',
        'rollover_contribution_percentage',
        'rollover_contribution_amount',
    ]

    def __init__(self,
                 security_id=APIHelper.SKIP,
                 security_id_type=APIHelper.SKIP,
                 employer_match_percentage=APIHelper.SKIP,
                 employer_match_amount=APIHelper.SKIP,
                 employee_pre_tax_amount=APIHelper.SKIP,
                 employee_pre_tax_percentage=APIHelper.SKIP,
                 employee_after_tax_amount=APIHelper.SKIP,
                 employee_after_tax_percentage=APIHelper.SKIP,
                 employee_defer_pre_tax_amount=APIHelper.SKIP,
                 employee_defer_pre_tax_percentage=APIHelper.SKIP,
                 employee_year_to_date=APIHelper.SKIP,
                 employer_year_to_date=APIHelper.SKIP,
                 rollover_contribution_percentage=APIHelper.SKIP,
                 rollover_contribution_amount=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ContributionEntity class"""

        # Initialize members of the class
        if security_id is not APIHelper.SKIP:
            self.security_id = security_id 
        if security_id_type is not APIHelper.SKIP:
            self.security_id_type = security_id_type 
        if employer_match_percentage is not APIHelper.SKIP:
            self.employer_match_percentage = employer_match_percentage 
        if employer_match_amount is not APIHelper.SKIP:
            self.employer_match_amount = employer_match_amount 
        if employee_pre_tax_amount is not APIHelper.SKIP:
            self.employee_pre_tax_amount = employee_pre_tax_amount 
        if employee_pre_tax_percentage is not APIHelper.SKIP:
            self.employee_pre_tax_percentage = employee_pre_tax_percentage 
        if employee_after_tax_amount is not APIHelper.SKIP:
            self.employee_after_tax_amount = employee_after_tax_amount 
        if employee_after_tax_percentage is not APIHelper.SKIP:
            self.employee_after_tax_percentage = employee_after_tax_percentage 
        if employee_defer_pre_tax_amount is not APIHelper.SKIP:
            self.employee_defer_pre_tax_amount = employee_defer_pre_tax_amount 
        if employee_defer_pre_tax_percentage is not APIHelper.SKIP:
            self.employee_defer_pre_tax_percentage = employee_defer_pre_tax_percentage 
        if employee_year_to_date is not APIHelper.SKIP:
            self.employee_year_to_date = employee_year_to_date 
        if employer_year_to_date is not APIHelper.SKIP:
            self.employer_year_to_date = employer_year_to_date 
        if rollover_contribution_percentage is not APIHelper.SKIP:
            self.rollover_contribution_percentage = rollover_contribution_percentage 
        if rollover_contribution_amount is not APIHelper.SKIP:
            self.rollover_contribution_amount = rollover_contribution_amount 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        security_id = dictionary.get("securityId") if dictionary.get("securityId") else APIHelper.SKIP
        security_id_type = dictionary.get("securityIdType") if dictionary.get("securityIdType") else APIHelper.SKIP
        employer_match_percentage = dictionary.get("employerMatchPercentage") if dictionary.get("employerMatchPercentage") else APIHelper.SKIP
        employer_match_amount = dictionary.get("employerMatchAmount") if dictionary.get("employerMatchAmount") else APIHelper.SKIP
        employee_pre_tax_amount = dictionary.get("employeePreTaxAmount") if dictionary.get("employeePreTaxAmount") else APIHelper.SKIP
        employee_pre_tax_percentage = dictionary.get("employeePreTaxPercentage") if dictionary.get("employeePreTaxPercentage") else APIHelper.SKIP
        employee_after_tax_amount = dictionary.get("employeeAfterTaxAmount") if dictionary.get("employeeAfterTaxAmount") else APIHelper.SKIP
        employee_after_tax_percentage = dictionary.get("employeeAfterTaxPercentage") if dictionary.get("employeeAfterTaxPercentage") else APIHelper.SKIP
        employee_defer_pre_tax_amount = dictionary.get("employeeDeferPreTaxAmount") if dictionary.get("employeeDeferPreTaxAmount") else APIHelper.SKIP
        employee_defer_pre_tax_percentage = dictionary.get("employeeDeferPreTaxPercentage") if dictionary.get("employeeDeferPreTaxPercentage") else APIHelper.SKIP
        employee_year_to_date = dictionary.get("employeeYearToDate") if dictionary.get("employeeYearToDate") else APIHelper.SKIP
        employer_year_to_date = dictionary.get("employerYearToDate") if dictionary.get("employerYearToDate") else APIHelper.SKIP
        rollover_contribution_percentage = dictionary.get("rolloverContributionPercentage") if dictionary.get("rolloverContributionPercentage") else APIHelper.SKIP
        rollover_contribution_amount = dictionary.get("rolloverContributionAmount") if dictionary.get("rolloverContributionAmount") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(security_id,
                   security_id_type,
                   employer_match_percentage,
                   employer_match_amount,
                   employee_pre_tax_amount,
                   employee_pre_tax_percentage,
                   employee_after_tax_amount,
                   employee_after_tax_percentage,
                   employee_defer_pre_tax_amount,
                   employee_defer_pre_tax_percentage,
                   employee_year_to_date,
                   employer_year_to_date,
                   rollover_contribution_percentage,
                   rollover_contribution_amount,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'security_id={(self.security_id if hasattr(self, "security_id") else None)!r}, '
                f'security_id_type={(self.security_id_type if hasattr(self, "security_id_type") else None)!r}, '
                f'employer_match_percentage={(self.employer_match_percentage if hasattr(self, "employer_match_percentage") else None)!r}, '
                f'employer_match_amount={(self.employer_match_amount if hasattr(self, "employer_match_amount") else None)!r}, '
                f'employee_pre_tax_amount={(self.employee_pre_tax_amount if hasattr(self, "employee_pre_tax_amount") else None)!r}, '
                f'employee_pre_tax_percentage={(self.employee_pre_tax_percentage if hasattr(self, "employee_pre_tax_percentage") else None)!r}, '
                f'employee_after_tax_amount={(self.employee_after_tax_amount if hasattr(self, "employee_after_tax_amount") else None)!r}, '
                f'employee_after_tax_percentage={(self.employee_after_tax_percentage if hasattr(self, "employee_after_tax_percentage") else None)!r}, '
                f'employee_defer_pre_tax_amount={(self.employee_defer_pre_tax_amount if hasattr(self, "employee_defer_pre_tax_amount") else None)!r}, '
                f'employee_defer_pre_tax_percentage={(self.employee_defer_pre_tax_percentage if hasattr(self, "employee_defer_pre_tax_percentage") else None)!r}, '
                f'employee_year_to_date={(self.employee_year_to_date if hasattr(self, "employee_year_to_date") else None)!r}, '
                f'employer_year_to_date={(self.employer_year_to_date if hasattr(self, "employer_year_to_date") else None)!r}, '
                f'rollover_contribution_percentage={(self.rollover_contribution_percentage if hasattr(self, "rollover_contribution_percentage") else None)!r}, '
                f'rollover_contribution_amount={(self.rollover_contribution_amount if hasattr(self, "rollover_contribution_amount") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'security_id={(self.security_id if hasattr(self, "security_id") else None)!s}, '
                f'security_id_type={(self.security_id_type if hasattr(self, "security_id_type") else None)!s}, '
                f'employer_match_percentage={(self.employer_match_percentage if hasattr(self, "employer_match_percentage") else None)!s}, '
                f'employer_match_amount={(self.employer_match_amount if hasattr(self, "employer_match_amount") else None)!s}, '
                f'employee_pre_tax_amount={(self.employee_pre_tax_amount if hasattr(self, "employee_pre_tax_amount") else None)!s}, '
                f'employee_pre_tax_percentage={(self.employee_pre_tax_percentage if hasattr(self, "employee_pre_tax_percentage") else None)!s}, '
                f'employee_after_tax_amount={(self.employee_after_tax_amount if hasattr(self, "employee_after_tax_amount") else None)!s}, '
                f'employee_after_tax_percentage={(self.employee_after_tax_percentage if hasattr(self, "employee_after_tax_percentage") else None)!s}, '
                f'employee_defer_pre_tax_amount={(self.employee_defer_pre_tax_amount if hasattr(self, "employee_defer_pre_tax_amount") else None)!s}, '
                f'employee_defer_pre_tax_percentage={(self.employee_defer_pre_tax_percentage if hasattr(self, "employee_defer_pre_tax_percentage") else None)!s}, '
                f'employee_year_to_date={(self.employee_year_to_date if hasattr(self, "employee_year_to_date") else None)!s}, '
                f'employer_year_to_date={(self.employer_year_to_date if hasattr(self, "employer_year_to_date") else None)!s}, '
                f'rollover_contribution_percentage={(self.rollover_contribution_percentage if hasattr(self, "rollover_contribution_percentage") else None)!s}, '
                f'rollover_contribution_amount={(self.rollover_contribution_amount if hasattr(self, "rollover_contribution_amount") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
