# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class CustomerNameEntity(object):

    """Implementation of the 'Customer Name entity' model.

    The customer's name

    Attributes:
        first (str): First name
        middle (str): Middle initial
        last (str): Last name
        suffix (str): Generational or academic suffix
        prefix (str): Name prefix, e.g. Mr.
        company (str): Company name
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "first": 'first',
        "middle": 'middle',
        "last": 'last',
        "suffix": 'suffix',
        "prefix": 'prefix',
        "company": 'company'
    }

    _optionals = [
        'first',
        'middle',
        'last',
        'suffix',
        'prefix',
        'company',
    ]

    def __init__(self,
                 first=APIHelper.SKIP,
                 middle=APIHelper.SKIP,
                 last=APIHelper.SKIP,
                 suffix=APIHelper.SKIP,
                 prefix=APIHelper.SKIP,
                 company=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CustomerNameEntity class"""

        # Initialize members of the class
        if first is not APIHelper.SKIP:
            self.first = first 
        if middle is not APIHelper.SKIP:
            self.middle = middle 
        if last is not APIHelper.SKIP:
            self.last = last 
        if suffix is not APIHelper.SKIP:
            self.suffix = suffix 
        if prefix is not APIHelper.SKIP:
            self.prefix = prefix 
        if company is not APIHelper.SKIP:
            self.company = company 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        first = dictionary.get("first") if dictionary.get("first") else APIHelper.SKIP
        middle = dictionary.get("middle") if dictionary.get("middle") else APIHelper.SKIP
        last = dictionary.get("last") if dictionary.get("last") else APIHelper.SKIP
        suffix = dictionary.get("suffix") if dictionary.get("suffix") else APIHelper.SKIP
        prefix = dictionary.get("prefix") if dictionary.get("prefix") else APIHelper.SKIP
        company = dictionary.get("company") if dictionary.get("company") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(first,
                   middle,
                   last,
                   suffix,
                   prefix,
                   company,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'first={(self.first if hasattr(self, "first") else None)!r}, '
                f'middle={(self.middle if hasattr(self, "middle") else None)!r}, '
                f'last={(self.last if hasattr(self, "last") else None)!r}, '
                f'suffix={(self.suffix if hasattr(self, "suffix") else None)!r}, '
                f'prefix={(self.prefix if hasattr(self, "prefix") else None)!r}, '
                f'company={(self.company if hasattr(self, "company") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'first={(self.first if hasattr(self, "first") else None)!s}, '
                f'middle={(self.middle if hasattr(self, "middle") else None)!s}, '
                f'last={(self.last if hasattr(self, "last") else None)!s}, '
                f'suffix={(self.suffix if hasattr(self, "suffix") else None)!s}, '
                f'prefix={(self.prefix if hasattr(self, "prefix") else None)!s}, '
                f'company={(self.company if hasattr(self, "company") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
