# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.delivery_address import DeliveryAddress
from fdxapi.models.individual_name import IndividualName
from fdxapi.models.telephone_number import TelephoneNumber


class EmployeeEntity1(object):

    """Implementation of the 'Employee entity1' model.

    The employee

    Attributes:
        emails (List[str]): Array of the contact email addresses
        addresses (List[DeliveryAddress]): Array of the contact physical
            addresses
        telephones (List[TelephoneNumber]): Array of the contact telephone
            numbers
        date_of_birth (date): The person's date of birth
        tax_id (str): Country specific Tax Id associated with this customer
            (SIN or NAS in Canada, SSN or TIN in US, etc.)
        tax_id_country (Iso3166CountryCode): Country originating the
            Customer's taxId element
        government_id (str): A federal (such as passport) or state (such as
            driver's license) issued identifier
        employee_id (str): Provider's long-term persistent id for the employee
        name (IndividualName): Employee's full name
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "emails": 'emails',
        "addresses": 'addresses',
        "telephones": 'telephones',
        "date_of_birth": 'dateOfBirth',
        "tax_id": 'taxId',
        "tax_id_country": 'taxIdCountry',
        "government_id": 'governmentId',
        "employee_id": 'employeeId'
    }

    _optionals = [
        'emails',
        'addresses',
        'telephones',
        'date_of_birth',
        'tax_id',
        'tax_id_country',
        'government_id',
        'employee_id',
    ]

    def __init__(self,
                 name=None,
                 emails=APIHelper.SKIP,
                 addresses=APIHelper.SKIP,
                 telephones=APIHelper.SKIP,
                 date_of_birth=APIHelper.SKIP,
                 tax_id=APIHelper.SKIP,
                 tax_id_country=APIHelper.SKIP,
                 government_id=APIHelper.SKIP,
                 employee_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the EmployeeEntity1 class"""

        # Initialize members of the class
        if emails is not APIHelper.SKIP:
            self.emails = emails 
        if addresses is not APIHelper.SKIP:
            self.addresses = addresses 
        if telephones is not APIHelper.SKIP:
            self.telephones = telephones 
        if date_of_birth is not APIHelper.SKIP:
            self.date_of_birth = date_of_birth 
        if tax_id is not APIHelper.SKIP:
            self.tax_id = tax_id 
        if tax_id_country is not APIHelper.SKIP:
            self.tax_id_country = tax_id_country 
        if government_id is not APIHelper.SKIP:
            self.government_id = government_id 
        if employee_id is not APIHelper.SKIP:
            self.employee_id = employee_id 
        self.name = name 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = IndividualName.from_dictionary(dictionary.get('name')) if dictionary.get('name') else None
        emails = dictionary.get("emails") if dictionary.get("emails") else APIHelper.SKIP
        addresses = None
        if dictionary.get('addresses') is not None:
            addresses = [DeliveryAddress.from_dictionary(x) for x in dictionary.get('addresses')]
        else:
            addresses = APIHelper.SKIP
        telephones = None
        if dictionary.get('telephones') is not None:
            telephones = [TelephoneNumber.from_dictionary(x) for x in dictionary.get('telephones')]
        else:
            telephones = APIHelper.SKIP
        date_of_birth = dateutil.parser.parse(dictionary.get('dateOfBirth')).date() if dictionary.get('dateOfBirth') else APIHelper.SKIP
        tax_id = dictionary.get("taxId") if dictionary.get("taxId") else APIHelper.SKIP
        tax_id_country = dictionary.get("taxIdCountry") if dictionary.get("taxIdCountry") else APIHelper.SKIP
        government_id = dictionary.get("governmentId") if dictionary.get("governmentId") else APIHelper.SKIP
        employee_id = dictionary.get("employeeId") if dictionary.get("employeeId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   emails,
                   addresses,
                   telephones,
                   date_of_birth,
                   tax_id,
                   tax_id_country,
                   government_id,
                   employee_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'emails={(self.emails if hasattr(self, "emails") else None)!r}, '
                f'addresses={(self.addresses if hasattr(self, "addresses") else None)!r}, '
                f'telephones={(self.telephones if hasattr(self, "telephones") else None)!r}, '
                f'date_of_birth={(self.date_of_birth if hasattr(self, "date_of_birth") else None)!r}, '
                f'tax_id={(self.tax_id if hasattr(self, "tax_id") else None)!r}, '
                f'tax_id_country={(self.tax_id_country if hasattr(self, "tax_id_country") else None)!r}, '
                f'government_id={(self.government_id if hasattr(self, "government_id") else None)!r}, '
                f'employee_id={(self.employee_id if hasattr(self, "employee_id") else None)!r}, '
                f'name={self.name!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'emails={(self.emails if hasattr(self, "emails") else None)!s}, '
                f'addresses={(self.addresses if hasattr(self, "addresses") else None)!s}, '
                f'telephones={(self.telephones if hasattr(self, "telephones") else None)!s}, '
                f'date_of_birth={(self.date_of_birth if hasattr(self, "date_of_birth") else None)!s}, '
                f'tax_id={(self.tax_id if hasattr(self, "tax_id") else None)!s}, '
                f'tax_id_country={(self.tax_id_country if hasattr(self, "tax_id_country") else None)!s}, '
                f'government_id={(self.government_id if hasattr(self, "government_id") else None)!s}, '
                f'employee_id={(self.employee_id if hasattr(self, "employee_id") else None)!s}, '
                f'name={self.name!s}, '
                f'additional_properties={self.additional_properties!s})')
