# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class FdxOauthTokenIntrospectionResponse(object):

    """Implementation of the 'FDX OAuth Token Introspection Response' model.

    FDX response enabling transport of ConsentGrant details extended from
    [JSON Web Token (JWT) Profile for OAuth 2.0 Access
    Tokens](https://datatracker.ietf.org/doc/html/rfc9068)

    Attributes:
        active (bool): Flag indicating whether 'ConsentGrant' is active
        iss (str): Issuer claim 'iss' identifies the principal that issued the
            JWT. Contains a
            [StringOrURI](https://datatracker.ietf.org/doc/html/rfc7519#section
            -2) value
        sub (str): Subject claim 'sub' identifies the principal that is the
            subject of the JWT. Contains a
            [StringOrURI](https://datatracker.ietf.org/doc/html/rfc7519#section
            -2) value
        aud (str): Audience claim 'aud' identifies the recipients for whom the
            JWT is intended. May be a single StringOrURI value or an array of
            [StringOrURI](https://datatracker.ietf.org/doc/html/rfc7519#section
            -2) values
        exp (float): Expiration Time claim 'exp' identifies the time on or
            after which the JWT MUST NOT be accepted Contains a number which
            is a
            [NumericDate](https://datatracker.ietf.org/doc/html/rfc7519#section
            -2) value
        iat (float): Issued At claim 'iat' identifies the time at which the
            JWT was issued. Contains a number which is a
            [NumericDate](https://datatracker.ietf.org/doc/html/rfc7519#section
            -2) value
        jti (str): JWT ID claim 'jti' provides a unique identifier for the
            JWT. Contains a case-sensitive string value
        client_id (str): The unique client identifier for the Data Recipient
            granted the consent
        scope (str): Space-delimited array of any number of scopes from those
            in FdxOauthScope, plus 'openid' and 'offline_access'
        fdx_consent_id (str): Unique ID for a consent grant
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "active": 'active',
        "iss": 'iss',
        "sub": 'sub',
        "aud": 'aud',
        "exp": 'exp',
        "iat": 'iat',
        "jti": 'jti',
        "client_id": 'client_id',
        "scope": 'scope',
        "fdx_consent_id": 'fdxConsentId'
    }

    _optionals = [
        'active',
        'iss',
        'sub',
        'aud',
        'exp',
        'iat',
        'jti',
        'client_id',
        'scope',
        'fdx_consent_id',
    ]

    def __init__(self,
                 active=APIHelper.SKIP,
                 iss=APIHelper.SKIP,
                 sub=APIHelper.SKIP,
                 aud=APIHelper.SKIP,
                 exp=APIHelper.SKIP,
                 iat=APIHelper.SKIP,
                 jti=APIHelper.SKIP,
                 client_id=APIHelper.SKIP,
                 scope=APIHelper.SKIP,
                 fdx_consent_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the FdxOauthTokenIntrospectionResponse class"""

        # Initialize members of the class
        if active is not APIHelper.SKIP:
            self.active = active 
        if iss is not APIHelper.SKIP:
            self.iss = iss 
        if sub is not APIHelper.SKIP:
            self.sub = sub 
        if aud is not APIHelper.SKIP:
            self.aud = aud 
        if exp is not APIHelper.SKIP:
            self.exp = exp 
        if iat is not APIHelper.SKIP:
            self.iat = iat 
        if jti is not APIHelper.SKIP:
            self.jti = jti 
        if client_id is not APIHelper.SKIP:
            self.client_id = client_id 
        if scope is not APIHelper.SKIP:
            self.scope = scope 
        if fdx_consent_id is not APIHelper.SKIP:
            self.fdx_consent_id = fdx_consent_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        active = dictionary.get("active") if "active" in dictionary.keys() else APIHelper.SKIP
        iss = dictionary.get("iss") if dictionary.get("iss") else APIHelper.SKIP
        sub = dictionary.get("sub") if dictionary.get("sub") else APIHelper.SKIP
        aud = dictionary.get("aud") if dictionary.get("aud") else APIHelper.SKIP
        exp = dictionary.get("exp") if dictionary.get("exp") else APIHelper.SKIP
        iat = dictionary.get("iat") if dictionary.get("iat") else APIHelper.SKIP
        jti = dictionary.get("jti") if dictionary.get("jti") else APIHelper.SKIP
        client_id = dictionary.get("client_id") if dictionary.get("client_id") else APIHelper.SKIP
        scope = dictionary.get("scope") if dictionary.get("scope") else APIHelper.SKIP
        fdx_consent_id = dictionary.get("fdxConsentId") if dictionary.get("fdxConsentId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(active,
                   iss,
                   sub,
                   aud,
                   exp,
                   iat,
                   jti,
                   client_id,
                   scope,
                   fdx_consent_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'active={(self.active if hasattr(self, "active") else None)!r}, '
                f'iss={(self.iss if hasattr(self, "iss") else None)!r}, '
                f'sub={(self.sub if hasattr(self, "sub") else None)!r}, '
                f'aud={(self.aud if hasattr(self, "aud") else None)!r}, '
                f'exp={(self.exp if hasattr(self, "exp") else None)!r}, '
                f'iat={(self.iat if hasattr(self, "iat") else None)!r}, '
                f'jti={(self.jti if hasattr(self, "jti") else None)!r}, '
                f'client_id={(self.client_id if hasattr(self, "client_id") else None)!r}, '
                f'scope={(self.scope if hasattr(self, "scope") else None)!r}, '
                f'fdx_consent_id={(self.fdx_consent_id if hasattr(self, "fdx_consent_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'active={(self.active if hasattr(self, "active") else None)!s}, '
                f'iss={(self.iss if hasattr(self, "iss") else None)!s}, '
                f'sub={(self.sub if hasattr(self, "sub") else None)!s}, '
                f'aud={(self.aud if hasattr(self, "aud") else None)!s}, '
                f'exp={(self.exp if hasattr(self, "exp") else None)!s}, '
                f'iat={(self.iat if hasattr(self, "iat") else None)!s}, '
                f'jti={(self.jti if hasattr(self, "jti") else None)!s}, '
                f'client_id={(self.client_id if hasattr(self, "client_id") else None)!s}, '
                f'scope={(self.scope if hasattr(self, "scope") else None)!s}, '
                f'fdx_consent_id={(self.fdx_consent_id if hasattr(self, "fdx_consent_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
