# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.payment_delivery_address_entity import PaymentDeliveryAddressEntity


class FinancialInstitutionEntity2(object):

    """Implementation of the 'Financial Institution entity2' model.

    Financial institution associated with the branch

    Attributes:
        name (str): Name of the financial institution
        fi_id (Iso93622014BusinessIdentifierCodeEntity |
            Iso93622022BusinessIdentifierCodeEntity |
            GenericFinancialInstitutionIdEntity | None): Financial institution
            identifier
        locations (List[PaymentDeliveryAddressEntity]): Location of the
            financial institution
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "fi_id": 'fiId',
        "locations": 'locations'
    }

    _optionals = [
        'name',
        'fi_id',
        'locations',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 fi_id=APIHelper.SKIP,
                 locations=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the FinancialInstitutionEntity2 class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if fi_id is not APIHelper.SKIP:
            self.fi_id = fi_id 
        if locations is not APIHelper.SKIP:
            self.locations = locations 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        fi_id = APIHelper.deserialize_union_type(UnionTypeLookUp.get('FinancialInstitutionEntity2FiId'), dictionary.get('fiId'), False) if dictionary.get('fiId') is not None else APIHelper.SKIP
        locations = None
        if dictionary.get('locations') is not None:
            locations = [PaymentDeliveryAddressEntity.from_dictionary(x) for x in dictionary.get('locations')]
        else:
            locations = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   fi_id,
                   locations,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'fi_id={(self.fi_id if hasattr(self, "fi_id") else None)!r}, '
                f'locations={(self.locations if hasattr(self, "locations") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'fi_id={(self.fi_id if hasattr(self, "fi_id") else None)!s}, '
                f'locations={(self.locations if hasattr(self, "locations") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
