# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.address import Address
from fdxapi.models.business_name import BusinessName
from fdxapi.models.individual_name import IndividualName
from fdxapi.models.telephone_number_plus_extension import TelephoneNumberPlusExtension


class Form1042SRecipient1(object):

    """Implementation of the 'Form 1042-S Recipient1' model.

    Boxes 13a-j, 13l, Recipient for Form 1042-S

    Attributes:
        tin (str): Issuer or recipient Tax Identification Number. Usually EIN
            for issuer and SSN for recipient
        party_type (TaxPartyType2): Type of issuer or recipient legal entity,
            as "BUSINESS" or "INDIVIDUAL". Commonly BUSINESS for issuer and
            INDIVIDUAL for recipient
        individual_name (IndividualName): Individual issuer or recipient name
        business_name (BusinessName): Business issuer or recipient name
        address (Address): Issuer or recipient address
        phone (TelephoneNumberPlusExtension): Issuer or recipient telephone
            number
        email (str): Issuer or recipient email address. (Additional
            information, not part of IRS forms)
        ch_3_status_code (str): Ch. 3 status code,   * Box 12b, Withholding
            Agent,   * Box 13f, Recipient,   * Box 15b, Intermediary or
            flow-through entity,   * Box 16d, Payer
        ch_4_status_code (str): Ch. 4 status code,   * Box 12c, Withholding
            Agent,   * Box 13g, Recipient,   * Box 15c, Intermediary or
            flow-through entity,   * Box 16e, Payer
        giin (str): Agent's Global Intermediary Identification Number (GIIN), 
            * Box 12e, Withholding Agent,   * Box 13h, Recipient,   * Box 15e,
            Intermediary or flow-through entity,   * Box 16c, Payer
        foreign_tin (str): Foreign tax identification number, if any,   * Box
            12g, Withholding Agent,   * Box 13i, Recipient,   * Box 15g,
            Intermediary or flow-through entity
        lob_code (str): Box 13j, Recipient's LOB code, if any
        date_of_birth (date): Box 13l, Recipient's date of birth
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tin": 'tin',
        "party_type": 'partyType',
        "individual_name": 'individualName',
        "business_name": 'businessName',
        "address": 'address',
        "phone": 'phone',
        "email": 'email',
        "ch_3_status_code": 'ch3StatusCode',
        "ch_4_status_code": 'ch4StatusCode',
        "giin": 'giin',
        "foreign_tin": 'foreignTin',
        "lob_code": 'lobCode',
        "date_of_birth": 'dateOfBirth'
    }

    _optionals = [
        'tin',
        'party_type',
        'individual_name',
        'business_name',
        'address',
        'phone',
        'email',
        'ch_3_status_code',
        'ch_4_status_code',
        'giin',
        'foreign_tin',
        'lob_code',
        'date_of_birth',
    ]

    def __init__(self,
                 tin=APIHelper.SKIP,
                 party_type=APIHelper.SKIP,
                 individual_name=APIHelper.SKIP,
                 business_name=APIHelper.SKIP,
                 address=APIHelper.SKIP,
                 phone=APIHelper.SKIP,
                 email=APIHelper.SKIP,
                 ch_3_status_code=APIHelper.SKIP,
                 ch_4_status_code=APIHelper.SKIP,
                 giin=APIHelper.SKIP,
                 foreign_tin=APIHelper.SKIP,
                 lob_code=APIHelper.SKIP,
                 date_of_birth=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1042SRecipient1 class"""

        # Initialize members of the class
        if tin is not APIHelper.SKIP:
            self.tin = tin 
        if party_type is not APIHelper.SKIP:
            self.party_type = party_type 
        if individual_name is not APIHelper.SKIP:
            self.individual_name = individual_name 
        if business_name is not APIHelper.SKIP:
            self.business_name = business_name 
        if address is not APIHelper.SKIP:
            self.address = address 
        if phone is not APIHelper.SKIP:
            self.phone = phone 
        if email is not APIHelper.SKIP:
            self.email = email 
        if ch_3_status_code is not APIHelper.SKIP:
            self.ch_3_status_code = ch_3_status_code 
        if ch_4_status_code is not APIHelper.SKIP:
            self.ch_4_status_code = ch_4_status_code 
        if giin is not APIHelper.SKIP:
            self.giin = giin 
        if foreign_tin is not APIHelper.SKIP:
            self.foreign_tin = foreign_tin 
        if lob_code is not APIHelper.SKIP:
            self.lob_code = lob_code 
        if date_of_birth is not APIHelper.SKIP:
            self.date_of_birth = date_of_birth 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tin = dictionary.get("tin") if dictionary.get("tin") else APIHelper.SKIP
        party_type = dictionary.get("partyType") if dictionary.get("partyType") else APIHelper.SKIP
        individual_name = IndividualName.from_dictionary(dictionary.get('individualName')) if 'individualName' in dictionary.keys() else APIHelper.SKIP
        business_name = BusinessName.from_dictionary(dictionary.get('businessName')) if 'businessName' in dictionary.keys() else APIHelper.SKIP
        address = Address.from_dictionary(dictionary.get('address')) if 'address' in dictionary.keys() else APIHelper.SKIP
        phone = TelephoneNumberPlusExtension.from_dictionary(dictionary.get('phone')) if 'phone' in dictionary.keys() else APIHelper.SKIP
        email = dictionary.get("email") if dictionary.get("email") else APIHelper.SKIP
        ch_3_status_code = dictionary.get("ch3StatusCode") if dictionary.get("ch3StatusCode") else APIHelper.SKIP
        ch_4_status_code = dictionary.get("ch4StatusCode") if dictionary.get("ch4StatusCode") else APIHelper.SKIP
        giin = dictionary.get("giin") if dictionary.get("giin") else APIHelper.SKIP
        foreign_tin = dictionary.get("foreignTin") if dictionary.get("foreignTin") else APIHelper.SKIP
        lob_code = dictionary.get("lobCode") if dictionary.get("lobCode") else APIHelper.SKIP
        date_of_birth = dateutil.parser.parse(dictionary.get('dateOfBirth')).date() if dictionary.get('dateOfBirth') else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tin,
                   party_type,
                   individual_name,
                   business_name,
                   address,
                   phone,
                   email,
                   ch_3_status_code,
                   ch_4_status_code,
                   giin,
                   foreign_tin,
                   lob_code,
                   date_of_birth,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tin={(self.tin if hasattr(self, "tin") else None)!r}, '
                f'party_type={(self.party_type if hasattr(self, "party_type") else None)!r}, '
                f'individual_name={(self.individual_name if hasattr(self, "individual_name") else None)!r}, '
                f'business_name={(self.business_name if hasattr(self, "business_name") else None)!r}, '
                f'address={(self.address if hasattr(self, "address") else None)!r}, '
                f'phone={(self.phone if hasattr(self, "phone") else None)!r}, '
                f'email={(self.email if hasattr(self, "email") else None)!r}, '
                f'ch_3_status_code={(self.ch_3_status_code if hasattr(self, "ch_3_status_code") else None)!r}, '
                f'ch_4_status_code={(self.ch_4_status_code if hasattr(self, "ch_4_status_code") else None)!r}, '
                f'giin={(self.giin if hasattr(self, "giin") else None)!r}, '
                f'foreign_tin={(self.foreign_tin if hasattr(self, "foreign_tin") else None)!r}, '
                f'lob_code={(self.lob_code if hasattr(self, "lob_code") else None)!r}, '
                f'date_of_birth={(self.date_of_birth if hasattr(self, "date_of_birth") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tin={(self.tin if hasattr(self, "tin") else None)!s}, '
                f'party_type={(self.party_type if hasattr(self, "party_type") else None)!s}, '
                f'individual_name={(self.individual_name if hasattr(self, "individual_name") else None)!s}, '
                f'business_name={(self.business_name if hasattr(self, "business_name") else None)!s}, '
                f'address={(self.address if hasattr(self, "address") else None)!s}, '
                f'phone={(self.phone if hasattr(self, "phone") else None)!s}, '
                f'email={(self.email if hasattr(self, "email") else None)!s}, '
                f'ch_3_status_code={(self.ch_3_status_code if hasattr(self, "ch_3_status_code") else None)!s}, '
                f'ch_4_status_code={(self.ch_4_status_code if hasattr(self, "ch_4_status_code") else None)!s}, '
                f'giin={(self.giin if hasattr(self, "giin") else None)!s}, '
                f'foreign_tin={(self.foreign_tin if hasattr(self, "foreign_tin") else None)!s}, '
                f'lob_code={(self.lob_code if hasattr(self, "lob_code") else None)!s}, '
                f'date_of_birth={(self.date_of_birth if hasattr(self, "date_of_birth") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
