# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.address import Address
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1098(object):

    """Implementation of the 'Form 1098' model.

    Mortgage Interest Statement, from RECIPIENT/LENDER (1st-2nd boxes as
    issuer) to PAYER/BORROWER (3rd-6th boxes as recipient)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        mortgaged_properties (int): Box 9, Number of properties securing the
            mortgage
        other_information (str): Box 10, Other (property tax)
        account_number (str): Account number
        mortgage_interest (float): Box 1, Mortgage interest received from
            borrower
        outstanding_principal (float): Box 2, Outstanding mortgage principal
        origination_date (date): Box 3, Mortgage origination date
        overpaid_refund (float): Box 4, Refund of overpaid interest
        mortgage_insurance (float): Box 5, Mortgage insurance premiums
        points_paid (float): Box 6, Points paid on purchase of principal
            residence
        is_property_address_same_as_borrower_address (bool): Box 7, Is address
            of property securing mortgage same as PAYER'S/BORROWER'S address
        acquisition_date (date): Box 11, Mortgage acquisition date
        property_address (Address): Box 8, Address of property securing
            mortgage
        property_tax (float): Box 10, Property tax
        property_description (str): Box 8, Description of property securing
            mortgage, if property securing mortgage has no address
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "mortgaged_properties": 'mortgagedProperties',
        "other_information": 'otherInformation',
        "account_number": 'accountNumber',
        "mortgage_interest": 'mortgageInterest',
        "outstanding_principal": 'outstandingPrincipal',
        "origination_date": 'originationDate',
        "overpaid_refund": 'overpaidRefund',
        "mortgage_insurance": 'mortgageInsurance',
        "points_paid": 'pointsPaid',
        "is_property_address_same_as_borrower_address": 'isPropertyAddressSameAsBorrowerAddress',
        "acquisition_date": 'acquisitionDate',
        "property_address": 'propertyAddress',
        "property_tax": 'propertyTax',
        "property_description": 'propertyDescription'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'mortgaged_properties',
        'other_information',
        'account_number',
        'mortgage_interest',
        'outstanding_principal',
        'origination_date',
        'overpaid_refund',
        'mortgage_insurance',
        'points_paid',
        'is_property_address_same_as_borrower_address',
        'acquisition_date',
        'property_address',
        'property_tax',
        'property_description',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 mortgaged_properties=APIHelper.SKIP,
                 other_information=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 mortgage_interest=APIHelper.SKIP,
                 outstanding_principal=APIHelper.SKIP,
                 origination_date=APIHelper.SKIP,
                 overpaid_refund=APIHelper.SKIP,
                 mortgage_insurance=APIHelper.SKIP,
                 points_paid=APIHelper.SKIP,
                 is_property_address_same_as_borrower_address=APIHelper.SKIP,
                 acquisition_date=APIHelper.SKIP,
                 property_address=APIHelper.SKIP,
                 property_tax=APIHelper.SKIP,
                 property_description=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1098 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if mortgaged_properties is not APIHelper.SKIP:
            self.mortgaged_properties = mortgaged_properties 
        if other_information is not APIHelper.SKIP:
            self.other_information = other_information 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if mortgage_interest is not APIHelper.SKIP:
            self.mortgage_interest = mortgage_interest 
        if outstanding_principal is not APIHelper.SKIP:
            self.outstanding_principal = outstanding_principal 
        if origination_date is not APIHelper.SKIP:
            self.origination_date = origination_date 
        if overpaid_refund is not APIHelper.SKIP:
            self.overpaid_refund = overpaid_refund 
        if mortgage_insurance is not APIHelper.SKIP:
            self.mortgage_insurance = mortgage_insurance 
        if points_paid is not APIHelper.SKIP:
            self.points_paid = points_paid 
        if is_property_address_same_as_borrower_address is not APIHelper.SKIP:
            self.is_property_address_same_as_borrower_address = is_property_address_same_as_borrower_address 
        if acquisition_date is not APIHelper.SKIP:
            self.acquisition_date = acquisition_date 
        if property_address is not APIHelper.SKIP:
            self.property_address = property_address 
        if property_tax is not APIHelper.SKIP:
            self.property_tax = property_tax 
        if property_description is not APIHelper.SKIP:
            self.property_description = property_description 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        mortgaged_properties = dictionary.get("mortgagedProperties") if dictionary.get("mortgagedProperties") else APIHelper.SKIP
        other_information = dictionary.get("otherInformation") if dictionary.get("otherInformation") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        mortgage_interest = dictionary.get("mortgageInterest") if dictionary.get("mortgageInterest") else APIHelper.SKIP
        outstanding_principal = dictionary.get("outstandingPrincipal") if dictionary.get("outstandingPrincipal") else APIHelper.SKIP
        origination_date = dateutil.parser.parse(dictionary.get('originationDate')).date() if dictionary.get('originationDate') else APIHelper.SKIP
        overpaid_refund = dictionary.get("overpaidRefund") if dictionary.get("overpaidRefund") else APIHelper.SKIP
        mortgage_insurance = dictionary.get("mortgageInsurance") if dictionary.get("mortgageInsurance") else APIHelper.SKIP
        points_paid = dictionary.get("pointsPaid") if dictionary.get("pointsPaid") else APIHelper.SKIP
        is_property_address_same_as_borrower_address = dictionary.get("isPropertyAddressSameAsBorrowerAddress") if "isPropertyAddressSameAsBorrowerAddress" in dictionary.keys() else APIHelper.SKIP
        acquisition_date = dateutil.parser.parse(dictionary.get('acquisitionDate')).date() if dictionary.get('acquisitionDate') else APIHelper.SKIP
        property_address = Address.from_dictionary(dictionary.get('propertyAddress')) if 'propertyAddress' in dictionary.keys() else APIHelper.SKIP
        property_tax = dictionary.get("propertyTax") if dictionary.get("propertyTax") else APIHelper.SKIP
        property_description = dictionary.get("propertyDescription") if dictionary.get("propertyDescription") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   mortgaged_properties,
                   other_information,
                   account_number,
                   mortgage_interest,
                   outstanding_principal,
                   origination_date,
                   overpaid_refund,
                   mortgage_insurance,
                   points_paid,
                   is_property_address_same_as_borrower_address,
                   acquisition_date,
                   property_address,
                   property_tax,
                   property_description,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'mortgaged_properties={(self.mortgaged_properties if hasattr(self, "mortgaged_properties") else None)!r}, '
                f'other_information={(self.other_information if hasattr(self, "other_information") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'mortgage_interest={(self.mortgage_interest if hasattr(self, "mortgage_interest") else None)!r}, '
                f'outstanding_principal={(self.outstanding_principal if hasattr(self, "outstanding_principal") else None)!r}, '
                f'origination_date={(self.origination_date if hasattr(self, "origination_date") else None)!r}, '
                f'overpaid_refund={(self.overpaid_refund if hasattr(self, "overpaid_refund") else None)!r}, '
                f'mortgage_insurance={(self.mortgage_insurance if hasattr(self, "mortgage_insurance") else None)!r}, '
                f'points_paid={(self.points_paid if hasattr(self, "points_paid") else None)!r}, '
                f'is_property_address_same_as_borrower_address={(self.is_property_address_same_as_borrower_address if hasattr(self, "is_property_address_same_as_borrower_address") else None)!r}, '
                f'acquisition_date={(self.acquisition_date if hasattr(self, "acquisition_date") else None)!r}, '
                f'property_address={(self.property_address if hasattr(self, "property_address") else None)!r}, '
                f'property_tax={(self.property_tax if hasattr(self, "property_tax") else None)!r}, '
                f'property_description={(self.property_description if hasattr(self, "property_description") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'mortgaged_properties={(self.mortgaged_properties if hasattr(self, "mortgaged_properties") else None)!s}, '
                f'other_information={(self.other_information if hasattr(self, "other_information") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'mortgage_interest={(self.mortgage_interest if hasattr(self, "mortgage_interest") else None)!s}, '
                f'outstanding_principal={(self.outstanding_principal if hasattr(self, "outstanding_principal") else None)!s}, '
                f'origination_date={(self.origination_date if hasattr(self, "origination_date") else None)!s}, '
                f'overpaid_refund={(self.overpaid_refund if hasattr(self, "overpaid_refund") else None)!s}, '
                f'mortgage_insurance={(self.mortgage_insurance if hasattr(self, "mortgage_insurance") else None)!s}, '
                f'points_paid={(self.points_paid if hasattr(self, "points_paid") else None)!s}, '
                f'is_property_address_same_as_borrower_address={(self.is_property_address_same_as_borrower_address if hasattr(self, "is_property_address_same_as_borrower_address") else None)!s}, '
                f'acquisition_date={(self.acquisition_date if hasattr(self, "acquisition_date") else None)!s}, '
                f'property_address={(self.property_address if hasattr(self, "property_address") else None)!s}, '
                f'property_tax={(self.property_tax if hasattr(self, "property_tax") else None)!s}, '
                f'property_description={(self.property_description if hasattr(self, "property_description") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
