# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099G1(object):

    """Implementation of the 'Form 1099-G1' model.

    Certain Government Payments

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        unemployment_compensation (float): Box 1, Unemployment compensation
        tax_refund (float): Box 2, State or local income tax refunds, credits,
            or offsets
        refund_year (int): Box 3, Box 2 amount is for tax year
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        rtaa_payments (float): Box 5, RTAA payments
        grants (float): Box 6, Taxable grants
        agriculture_payments (float): Box 7, Agriculture payments
        business_income (bool): Box 8, If checked, box 2 is trade or business
            income
        market_gain (float): Box 9, Market gain
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 10-11,
            State and Local tax withholding
        second_tin_notice (bool): Second TIN Notice
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "unemployment_compensation": 'unemploymentCompensation',
        "tax_refund": 'taxRefund',
        "refund_year": 'refundYear',
        "federal_tax_withheld": 'federalTaxWithheld',
        "rtaa_payments": 'rtaaPayments',
        "grants": 'grants',
        "agriculture_payments": 'agriculturePayments',
        "business_income": 'businessIncome',
        "market_gain": 'marketGain',
        "state_and_local": 'stateAndLocal',
        "second_tin_notice": 'secondTinNotice'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'unemployment_compensation',
        'tax_refund',
        'refund_year',
        'federal_tax_withheld',
        'rtaa_payments',
        'grants',
        'agriculture_payments',
        'business_income',
        'market_gain',
        'state_and_local',
        'second_tin_notice',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 unemployment_compensation=APIHelper.SKIP,
                 tax_refund=APIHelper.SKIP,
                 refund_year=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 rtaa_payments=APIHelper.SKIP,
                 grants=APIHelper.SKIP,
                 agriculture_payments=APIHelper.SKIP,
                 business_income=APIHelper.SKIP,
                 market_gain=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 second_tin_notice=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099G1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if unemployment_compensation is not APIHelper.SKIP:
            self.unemployment_compensation = unemployment_compensation 
        if tax_refund is not APIHelper.SKIP:
            self.tax_refund = tax_refund 
        if refund_year is not APIHelper.SKIP:
            self.refund_year = refund_year 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if rtaa_payments is not APIHelper.SKIP:
            self.rtaa_payments = rtaa_payments 
        if grants is not APIHelper.SKIP:
            self.grants = grants 
        if agriculture_payments is not APIHelper.SKIP:
            self.agriculture_payments = agriculture_payments 
        if business_income is not APIHelper.SKIP:
            self.business_income = business_income 
        if market_gain is not APIHelper.SKIP:
            self.market_gain = market_gain 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 
        if second_tin_notice is not APIHelper.SKIP:
            self.second_tin_notice = second_tin_notice 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        unemployment_compensation = dictionary.get("unemploymentCompensation") if dictionary.get("unemploymentCompensation") else APIHelper.SKIP
        tax_refund = dictionary.get("taxRefund") if dictionary.get("taxRefund") else APIHelper.SKIP
        refund_year = dictionary.get("refundYear") if dictionary.get("refundYear") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        rtaa_payments = dictionary.get("rtaaPayments") if dictionary.get("rtaaPayments") else APIHelper.SKIP
        grants = dictionary.get("grants") if dictionary.get("grants") else APIHelper.SKIP
        agriculture_payments = dictionary.get("agriculturePayments") if dictionary.get("agriculturePayments") else APIHelper.SKIP
        business_income = dictionary.get("businessIncome") if "businessIncome" in dictionary.keys() else APIHelper.SKIP
        market_gain = dictionary.get("marketGain") if dictionary.get("marketGain") else APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        second_tin_notice = dictionary.get("secondTinNotice") if "secondTinNotice" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   unemployment_compensation,
                   tax_refund,
                   refund_year,
                   federal_tax_withheld,
                   rtaa_payments,
                   grants,
                   agriculture_payments,
                   business_income,
                   market_gain,
                   state_and_local,
                   second_tin_notice,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'unemployment_compensation={(self.unemployment_compensation if hasattr(self, "unemployment_compensation") else None)!r}, '
                f'tax_refund={(self.tax_refund if hasattr(self, "tax_refund") else None)!r}, '
                f'refund_year={(self.refund_year if hasattr(self, "refund_year") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'rtaa_payments={(self.rtaa_payments if hasattr(self, "rtaa_payments") else None)!r}, '
                f'grants={(self.grants if hasattr(self, "grants") else None)!r}, '
                f'agriculture_payments={(self.agriculture_payments if hasattr(self, "agriculture_payments") else None)!r}, '
                f'business_income={(self.business_income if hasattr(self, "business_income") else None)!r}, '
                f'market_gain={(self.market_gain if hasattr(self, "market_gain") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'unemployment_compensation={(self.unemployment_compensation if hasattr(self, "unemployment_compensation") else None)!s}, '
                f'tax_refund={(self.tax_refund if hasattr(self, "tax_refund") else None)!s}, '
                f'refund_year={(self.refund_year if hasattr(self, "refund_year") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'rtaa_payments={(self.rtaa_payments if hasattr(self, "rtaa_payments") else None)!s}, '
                f'grants={(self.grants if hasattr(self, "grants") else None)!s}, '
                f'agriculture_payments={(self.agriculture_payments if hasattr(self, "agriculture_payments") else None)!s}, '
                f'business_income={(self.business_income if hasattr(self, "business_income") else None)!s}, '
                f'market_gain={(self.market_gain if hasattr(self, "market_gain") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
