# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.month_and_amount import MonthAndAmount
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8
from fdxapi.models.telephone_number_plus_extension_1 import TelephoneNumberPlusExtension1


class Form1099K(object):

    """Implementation of the 'Form 1099-K' model.

    Merchant Card and Third-Party Network Payments, from FILER (1st, 7th boxes
    as issuer) to PAYEE (4th, 8th boxes as recipient)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        payment_settlement_entity (bool): Check to indicate if FILER is a
            Payment Settlement Entity (PSE)
        electronic_payment_facilitator (bool): Check to indicate if FILER is
            an Electronic Payment Facilitator (EPF) / Other third party
        payment_card (bool): Check to indicate transactions reported are:
            Payment card
        third_party_network (bool): Check to indicate transactions reported
            are: Third party network
        pse_name (str): PSE's name
        pse_phone (TelephoneNumberPlusExtension1): PSE's phone number
        account_number (str): Account number
        gross_amount (float): Box 1a, Gross amount of payment card/third party
            network transactions
        card_not_present (float): Box 1b, Card Not Present Transactions
        merchant_category_code (str): Box 2, Merchant category code
        number_of_transactions (float): Box 3, Number of purchase transactions
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        month_amounts (List[MonthAndAmount]): Box 5, Monthly amounts
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 6-8, State
            and Local tax withholding
        second_tin_notice (bool): Second TIN Notice
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "payment_settlement_entity": 'paymentSettlementEntity',
        "electronic_payment_facilitator": 'electronicPaymentFacilitator',
        "payment_card": 'paymentCard',
        "third_party_network": 'thirdPartyNetwork',
        "pse_name": 'pseName',
        "pse_phone": 'psePhone',
        "account_number": 'accountNumber',
        "gross_amount": 'grossAmount',
        "card_not_present": 'cardNotPresent',
        "merchant_category_code": 'merchantCategoryCode',
        "number_of_transactions": 'numberOfTransactions',
        "federal_tax_withheld": 'federalTaxWithheld',
        "month_amounts": 'monthAmounts',
        "state_and_local": 'stateAndLocal',
        "second_tin_notice": 'secondTinNotice'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'payment_settlement_entity',
        'electronic_payment_facilitator',
        'payment_card',
        'third_party_network',
        'pse_name',
        'pse_phone',
        'account_number',
        'gross_amount',
        'card_not_present',
        'merchant_category_code',
        'number_of_transactions',
        'federal_tax_withheld',
        'month_amounts',
        'state_and_local',
        'second_tin_notice',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 payment_settlement_entity=APIHelper.SKIP,
                 electronic_payment_facilitator=APIHelper.SKIP,
                 payment_card=APIHelper.SKIP,
                 third_party_network=APIHelper.SKIP,
                 pse_name=APIHelper.SKIP,
                 pse_phone=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 gross_amount=APIHelper.SKIP,
                 card_not_present=APIHelper.SKIP,
                 merchant_category_code=APIHelper.SKIP,
                 number_of_transactions=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 month_amounts=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 second_tin_notice=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099K class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if payment_settlement_entity is not APIHelper.SKIP:
            self.payment_settlement_entity = payment_settlement_entity 
        if electronic_payment_facilitator is not APIHelper.SKIP:
            self.electronic_payment_facilitator = electronic_payment_facilitator 
        if payment_card is not APIHelper.SKIP:
            self.payment_card = payment_card 
        if third_party_network is not APIHelper.SKIP:
            self.third_party_network = third_party_network 
        if pse_name is not APIHelper.SKIP:
            self.pse_name = pse_name 
        if pse_phone is not APIHelper.SKIP:
            self.pse_phone = pse_phone 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if gross_amount is not APIHelper.SKIP:
            self.gross_amount = gross_amount 
        if card_not_present is not APIHelper.SKIP:
            self.card_not_present = card_not_present 
        if merchant_category_code is not APIHelper.SKIP:
            self.merchant_category_code = merchant_category_code 
        if number_of_transactions is not APIHelper.SKIP:
            self.number_of_transactions = number_of_transactions 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if month_amounts is not APIHelper.SKIP:
            self.month_amounts = month_amounts 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 
        if second_tin_notice is not APIHelper.SKIP:
            self.second_tin_notice = second_tin_notice 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        payment_settlement_entity = dictionary.get("paymentSettlementEntity") if "paymentSettlementEntity" in dictionary.keys() else APIHelper.SKIP
        electronic_payment_facilitator = dictionary.get("electronicPaymentFacilitator") if "electronicPaymentFacilitator" in dictionary.keys() else APIHelper.SKIP
        payment_card = dictionary.get("paymentCard") if "paymentCard" in dictionary.keys() else APIHelper.SKIP
        third_party_network = dictionary.get("thirdPartyNetwork") if "thirdPartyNetwork" in dictionary.keys() else APIHelper.SKIP
        pse_name = dictionary.get("pseName") if dictionary.get("pseName") else APIHelper.SKIP
        pse_phone = TelephoneNumberPlusExtension1.from_dictionary(dictionary.get('psePhone')) if 'psePhone' in dictionary.keys() else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        gross_amount = dictionary.get("grossAmount") if dictionary.get("grossAmount") else APIHelper.SKIP
        card_not_present = dictionary.get("cardNotPresent") if dictionary.get("cardNotPresent") else APIHelper.SKIP
        merchant_category_code = dictionary.get("merchantCategoryCode") if dictionary.get("merchantCategoryCode") else APIHelper.SKIP
        number_of_transactions = dictionary.get("numberOfTransactions") if dictionary.get("numberOfTransactions") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        month_amounts = None
        if dictionary.get('monthAmounts') is not None:
            month_amounts = [MonthAndAmount.from_dictionary(x) for x in dictionary.get('monthAmounts')]
        else:
            month_amounts = APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        second_tin_notice = dictionary.get("secondTinNotice") if "secondTinNotice" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   payment_settlement_entity,
                   electronic_payment_facilitator,
                   payment_card,
                   third_party_network,
                   pse_name,
                   pse_phone,
                   account_number,
                   gross_amount,
                   card_not_present,
                   merchant_category_code,
                   number_of_transactions,
                   federal_tax_withheld,
                   month_amounts,
                   state_and_local,
                   second_tin_notice,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'payment_settlement_entity={(self.payment_settlement_entity if hasattr(self, "payment_settlement_entity") else None)!r}, '
                f'electronic_payment_facilitator={(self.electronic_payment_facilitator if hasattr(self, "electronic_payment_facilitator") else None)!r}, '
                f'payment_card={(self.payment_card if hasattr(self, "payment_card") else None)!r}, '
                f'third_party_network={(self.third_party_network if hasattr(self, "third_party_network") else None)!r}, '
                f'pse_name={(self.pse_name if hasattr(self, "pse_name") else None)!r}, '
                f'pse_phone={(self.pse_phone if hasattr(self, "pse_phone") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'gross_amount={(self.gross_amount if hasattr(self, "gross_amount") else None)!r}, '
                f'card_not_present={(self.card_not_present if hasattr(self, "card_not_present") else None)!r}, '
                f'merchant_category_code={(self.merchant_category_code if hasattr(self, "merchant_category_code") else None)!r}, '
                f'number_of_transactions={(self.number_of_transactions if hasattr(self, "number_of_transactions") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'month_amounts={(self.month_amounts if hasattr(self, "month_amounts") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'payment_settlement_entity={(self.payment_settlement_entity if hasattr(self, "payment_settlement_entity") else None)!s}, '
                f'electronic_payment_facilitator={(self.electronic_payment_facilitator if hasattr(self, "electronic_payment_facilitator") else None)!s}, '
                f'payment_card={(self.payment_card if hasattr(self, "payment_card") else None)!s}, '
                f'third_party_network={(self.third_party_network if hasattr(self, "third_party_network") else None)!s}, '
                f'pse_name={(self.pse_name if hasattr(self, "pse_name") else None)!s}, '
                f'pse_phone={(self.pse_phone if hasattr(self, "pse_phone") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'gross_amount={(self.gross_amount if hasattr(self, "gross_amount") else None)!s}, '
                f'card_not_present={(self.card_not_present if hasattr(self, "card_not_present") else None)!s}, '
                f'merchant_category_code={(self.merchant_category_code if hasattr(self, "merchant_category_code") else None)!s}, '
                f'number_of_transactions={(self.number_of_transactions if hasattr(self, "number_of_transactions") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'month_amounts={(self.month_amounts if hasattr(self, "month_amounts") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
