# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099Misc(object):

    """Implementation of the 'Form 1099-MISC' model.

    Miscellaneous Income, from PAYER (1st-2nd boxes as issuer) to RECIPIENT
    (3rd-4th boxes)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        rents (float): Box 1, Rents
        royalties (float): Box 2, Royalties
        other_income (float): Box 3, Other income
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        fishing_boat_proceeds (float): Box 5, Fishing boat proceeds
        medical_health_payment (float): Box 6, Medical and health care payments
        payer_direct_sales (bool): Box 7, Payer made direct sales of $5,000 or
            more of consumer products to a buyer (recipient) for resale
        substitute_payments (float): Box 8, Substitute payments in lieu of
            dividends or interest
        crop_insurance (float): Box 9, Crop insurance proceeds
        second_tin_notice (bool): Second TIN Notice
        gross_attorney (float): Box 10, Gross proceeds paid to an attorney
        fish_purchased (float): Box 11, Fish purchased for resale
        section_409_a_deferrals (float): Box 12, Section 409A deferrals
        foreign_account_tax_compliance (bool): Box 13, FATCA filing requirement
        excess_golden (float): Box 14, Excess golden parachute payments
        non_qualified_deferred_compensation (float): Box 15, Nonqualified
            Deferred Compensation
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 16-18,
            State and Local tax withholding
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "rents": 'rents',
        "royalties": 'royalties',
        "other_income": 'otherIncome',
        "federal_tax_withheld": 'federalTaxWithheld',
        "fishing_boat_proceeds": 'fishingBoatProceeds',
        "medical_health_payment": 'medicalHealthPayment',
        "payer_direct_sales": 'payerDirectSales',
        "substitute_payments": 'substitutePayments',
        "crop_insurance": 'cropInsurance',
        "second_tin_notice": 'secondTinNotice',
        "gross_attorney": 'grossAttorney',
        "fish_purchased": 'fishPurchased',
        "section_409_a_deferrals": 'section409ADeferrals',
        "foreign_account_tax_compliance": 'foreignAccountTaxCompliance',
        "excess_golden": 'excessGolden',
        "non_qualified_deferred_compensation": 'nonQualifiedDeferredCompensation',
        "state_and_local": 'stateAndLocal'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'rents',
        'royalties',
        'other_income',
        'federal_tax_withheld',
        'fishing_boat_proceeds',
        'medical_health_payment',
        'payer_direct_sales',
        'substitute_payments',
        'crop_insurance',
        'second_tin_notice',
        'gross_attorney',
        'fish_purchased',
        'section_409_a_deferrals',
        'foreign_account_tax_compliance',
        'excess_golden',
        'non_qualified_deferred_compensation',
        'state_and_local',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 rents=APIHelper.SKIP,
                 royalties=APIHelper.SKIP,
                 other_income=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 fishing_boat_proceeds=APIHelper.SKIP,
                 medical_health_payment=APIHelper.SKIP,
                 payer_direct_sales=APIHelper.SKIP,
                 substitute_payments=APIHelper.SKIP,
                 crop_insurance=APIHelper.SKIP,
                 second_tin_notice=APIHelper.SKIP,
                 gross_attorney=APIHelper.SKIP,
                 fish_purchased=APIHelper.SKIP,
                 section_409_a_deferrals=APIHelper.SKIP,
                 foreign_account_tax_compliance=APIHelper.SKIP,
                 excess_golden=APIHelper.SKIP,
                 non_qualified_deferred_compensation=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099Misc class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if rents is not APIHelper.SKIP:
            self.rents = rents 
        if royalties is not APIHelper.SKIP:
            self.royalties = royalties 
        if other_income is not APIHelper.SKIP:
            self.other_income = other_income 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if fishing_boat_proceeds is not APIHelper.SKIP:
            self.fishing_boat_proceeds = fishing_boat_proceeds 
        if medical_health_payment is not APIHelper.SKIP:
            self.medical_health_payment = medical_health_payment 
        if payer_direct_sales is not APIHelper.SKIP:
            self.payer_direct_sales = payer_direct_sales 
        if substitute_payments is not APIHelper.SKIP:
            self.substitute_payments = substitute_payments 
        if crop_insurance is not APIHelper.SKIP:
            self.crop_insurance = crop_insurance 
        if second_tin_notice is not APIHelper.SKIP:
            self.second_tin_notice = second_tin_notice 
        if gross_attorney is not APIHelper.SKIP:
            self.gross_attorney = gross_attorney 
        if fish_purchased is not APIHelper.SKIP:
            self.fish_purchased = fish_purchased 
        if section_409_a_deferrals is not APIHelper.SKIP:
            self.section_409_a_deferrals = section_409_a_deferrals 
        if foreign_account_tax_compliance is not APIHelper.SKIP:
            self.foreign_account_tax_compliance = foreign_account_tax_compliance 
        if excess_golden is not APIHelper.SKIP:
            self.excess_golden = excess_golden 
        if non_qualified_deferred_compensation is not APIHelper.SKIP:
            self.non_qualified_deferred_compensation = non_qualified_deferred_compensation 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        rents = dictionary.get("rents") if dictionary.get("rents") else APIHelper.SKIP
        royalties = dictionary.get("royalties") if dictionary.get("royalties") else APIHelper.SKIP
        other_income = dictionary.get("otherIncome") if dictionary.get("otherIncome") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        fishing_boat_proceeds = dictionary.get("fishingBoatProceeds") if dictionary.get("fishingBoatProceeds") else APIHelper.SKIP
        medical_health_payment = dictionary.get("medicalHealthPayment") if dictionary.get("medicalHealthPayment") else APIHelper.SKIP
        payer_direct_sales = dictionary.get("payerDirectSales") if "payerDirectSales" in dictionary.keys() else APIHelper.SKIP
        substitute_payments = dictionary.get("substitutePayments") if dictionary.get("substitutePayments") else APIHelper.SKIP
        crop_insurance = dictionary.get("cropInsurance") if dictionary.get("cropInsurance") else APIHelper.SKIP
        second_tin_notice = dictionary.get("secondTinNotice") if "secondTinNotice" in dictionary.keys() else APIHelper.SKIP
        gross_attorney = dictionary.get("grossAttorney") if dictionary.get("grossAttorney") else APIHelper.SKIP
        fish_purchased = dictionary.get("fishPurchased") if dictionary.get("fishPurchased") else APIHelper.SKIP
        section_409_a_deferrals = dictionary.get("section409ADeferrals") if dictionary.get("section409ADeferrals") else APIHelper.SKIP
        foreign_account_tax_compliance = dictionary.get("foreignAccountTaxCompliance") if "foreignAccountTaxCompliance" in dictionary.keys() else APIHelper.SKIP
        excess_golden = dictionary.get("excessGolden") if dictionary.get("excessGolden") else APIHelper.SKIP
        non_qualified_deferred_compensation = dictionary.get("nonQualifiedDeferredCompensation") if dictionary.get("nonQualifiedDeferredCompensation") else APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   rents,
                   royalties,
                   other_income,
                   federal_tax_withheld,
                   fishing_boat_proceeds,
                   medical_health_payment,
                   payer_direct_sales,
                   substitute_payments,
                   crop_insurance,
                   second_tin_notice,
                   gross_attorney,
                   fish_purchased,
                   section_409_a_deferrals,
                   foreign_account_tax_compliance,
                   excess_golden,
                   non_qualified_deferred_compensation,
                   state_and_local,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'rents={(self.rents if hasattr(self, "rents") else None)!r}, '
                f'royalties={(self.royalties if hasattr(self, "royalties") else None)!r}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'fishing_boat_proceeds={(self.fishing_boat_proceeds if hasattr(self, "fishing_boat_proceeds") else None)!r}, '
                f'medical_health_payment={(self.medical_health_payment if hasattr(self, "medical_health_payment") else None)!r}, '
                f'payer_direct_sales={(self.payer_direct_sales if hasattr(self, "payer_direct_sales") else None)!r}, '
                f'substitute_payments={(self.substitute_payments if hasattr(self, "substitute_payments") else None)!r}, '
                f'crop_insurance={(self.crop_insurance if hasattr(self, "crop_insurance") else None)!r}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!r}, '
                f'gross_attorney={(self.gross_attorney if hasattr(self, "gross_attorney") else None)!r}, '
                f'fish_purchased={(self.fish_purchased if hasattr(self, "fish_purchased") else None)!r}, '
                f'section_409_a_deferrals={(self.section_409_a_deferrals if hasattr(self, "section_409_a_deferrals") else None)!r}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!r}, '
                f'excess_golden={(self.excess_golden if hasattr(self, "excess_golden") else None)!r}, '
                f'non_qualified_deferred_compensation={(self.non_qualified_deferred_compensation if hasattr(self, "non_qualified_deferred_compensation") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'rents={(self.rents if hasattr(self, "rents") else None)!s}, '
                f'royalties={(self.royalties if hasattr(self, "royalties") else None)!s}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'fishing_boat_proceeds={(self.fishing_boat_proceeds if hasattr(self, "fishing_boat_proceeds") else None)!s}, '
                f'medical_health_payment={(self.medical_health_payment if hasattr(self, "medical_health_payment") else None)!s}, '
                f'payer_direct_sales={(self.payer_direct_sales if hasattr(self, "payer_direct_sales") else None)!s}, '
                f'substitute_payments={(self.substitute_payments if hasattr(self, "substitute_payments") else None)!s}, '
                f'crop_insurance={(self.crop_insurance if hasattr(self, "crop_insurance") else None)!s}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!s}, '
                f'gross_attorney={(self.gross_attorney if hasattr(self, "gross_attorney") else None)!s}, '
                f'fish_purchased={(self.fish_purchased if hasattr(self, "fish_purchased") else None)!s}, '
                f'section_409_a_deferrals={(self.section_409_a_deferrals if hasattr(self, "section_409_a_deferrals") else None)!s}, '
                f'foreign_account_tax_compliance={(self.foreign_account_tax_compliance if hasattr(self, "foreign_account_tax_compliance") else None)!s}, '
                f'excess_golden={(self.excess_golden if hasattr(self, "excess_golden") else None)!s}, '
                f'non_qualified_deferred_compensation={(self.non_qualified_deferred_compensation if hasattr(self, "non_qualified_deferred_compensation") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
