# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form5498(object):

    """Implementation of the 'Form 5498' model.

    IRA Contribution Information, from TRUSTEE/ISSUER (1st-2nd boxes as
    issuer) to PARTICIPANT (3rd-4th boxes as recipient)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        ira_contributions (float): Box 1, IRA contributions
        rollover_contributions (float): Box 2, Rollover contributions
        roth_ira_conversion (float): Box 3, Roth IRA conversion amount
        recharacterized_contributions (float): Box 4, Recharacterized
            contributions
        fair_market_value (float): Box 5, Fair market value of account
        life_insurance_cost (float): Box 6, Life insurance cost included in
            box 1
        ira (bool): Box 7a, IRA
        sep (bool): Box 7b, SEP
        simple (bool): Box 7c, SIMPLE
        roth_ira (bool): Box 7d, Roth IRA
        sep_contributions (float): Box 8, SEP contributions
        simple_contributions (float): Box 9, SIMPLE contributions
        roth_ira_contributions (float): Box 10, Roth IRA contributions
        rmd_next_year (bool): Box 11, If checked, required minimum
            distribution for next year
        rmd_date (date): Box 12a, RMD date
        rmd_amount (float): Box 12b, RMD amount
        postponed_contribution (float): Box 13a, Postponed contribution
        postponed_year (int): Box 13b, Year
        postponed_code (str): Box 13c, Code
        repayments (float): Box 14a, Repayments
        repay_code (str): Box 14b, Code
        fmv_specified_assets (float): Box 15a, FMV of certain specified assets
        specified_codes (str): Box 15b, Code(s)
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "ira_contributions": 'iraContributions',
        "rollover_contributions": 'rolloverContributions',
        "roth_ira_conversion": 'rothIraConversion',
        "recharacterized_contributions": 'recharacterizedContributions',
        "fair_market_value": 'fairMarketValue',
        "life_insurance_cost": 'lifeInsuranceCost',
        "ira": 'ira',
        "sep": 'sep',
        "simple": 'simple',
        "roth_ira": 'rothIra',
        "sep_contributions": 'sepContributions',
        "simple_contributions": 'simpleContributions',
        "roth_ira_contributions": 'rothIraContributions',
        "rmd_next_year": 'rmdNextYear',
        "rmd_date": 'rmdDate',
        "rmd_amount": 'rmdAmount',
        "postponed_contribution": 'postponedContribution',
        "postponed_year": 'postponedYear',
        "postponed_code": 'postponedCode',
        "repayments": 'repayments',
        "repay_code": 'repayCode',
        "fmv_specified_assets": 'fmvSpecifiedAssets',
        "specified_codes": 'specifiedCodes'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'ira_contributions',
        'rollover_contributions',
        'roth_ira_conversion',
        'recharacterized_contributions',
        'fair_market_value',
        'life_insurance_cost',
        'ira',
        'sep',
        'simple',
        'roth_ira',
        'sep_contributions',
        'simple_contributions',
        'roth_ira_contributions',
        'rmd_next_year',
        'rmd_date',
        'rmd_amount',
        'postponed_contribution',
        'postponed_year',
        'postponed_code',
        'repayments',
        'repay_code',
        'fmv_specified_assets',
        'specified_codes',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 ira_contributions=APIHelper.SKIP,
                 rollover_contributions=APIHelper.SKIP,
                 roth_ira_conversion=APIHelper.SKIP,
                 recharacterized_contributions=APIHelper.SKIP,
                 fair_market_value=APIHelper.SKIP,
                 life_insurance_cost=APIHelper.SKIP,
                 ira=APIHelper.SKIP,
                 sep=APIHelper.SKIP,
                 simple=APIHelper.SKIP,
                 roth_ira=APIHelper.SKIP,
                 sep_contributions=APIHelper.SKIP,
                 simple_contributions=APIHelper.SKIP,
                 roth_ira_contributions=APIHelper.SKIP,
                 rmd_next_year=APIHelper.SKIP,
                 rmd_date=APIHelper.SKIP,
                 rmd_amount=APIHelper.SKIP,
                 postponed_contribution=APIHelper.SKIP,
                 postponed_year=APIHelper.SKIP,
                 postponed_code=APIHelper.SKIP,
                 repayments=APIHelper.SKIP,
                 repay_code=APIHelper.SKIP,
                 fmv_specified_assets=APIHelper.SKIP,
                 specified_codes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form5498 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if ira_contributions is not APIHelper.SKIP:
            self.ira_contributions = ira_contributions 
        if rollover_contributions is not APIHelper.SKIP:
            self.rollover_contributions = rollover_contributions 
        if roth_ira_conversion is not APIHelper.SKIP:
            self.roth_ira_conversion = roth_ira_conversion 
        if recharacterized_contributions is not APIHelper.SKIP:
            self.recharacterized_contributions = recharacterized_contributions 
        if fair_market_value is not APIHelper.SKIP:
            self.fair_market_value = fair_market_value 
        if life_insurance_cost is not APIHelper.SKIP:
            self.life_insurance_cost = life_insurance_cost 
        if ira is not APIHelper.SKIP:
            self.ira = ira 
        if sep is not APIHelper.SKIP:
            self.sep = sep 
        if simple is not APIHelper.SKIP:
            self.simple = simple 
        if roth_ira is not APIHelper.SKIP:
            self.roth_ira = roth_ira 
        if sep_contributions is not APIHelper.SKIP:
            self.sep_contributions = sep_contributions 
        if simple_contributions is not APIHelper.SKIP:
            self.simple_contributions = simple_contributions 
        if roth_ira_contributions is not APIHelper.SKIP:
            self.roth_ira_contributions = roth_ira_contributions 
        if rmd_next_year is not APIHelper.SKIP:
            self.rmd_next_year = rmd_next_year 
        if rmd_date is not APIHelper.SKIP:
            self.rmd_date = rmd_date 
        if rmd_amount is not APIHelper.SKIP:
            self.rmd_amount = rmd_amount 
        if postponed_contribution is not APIHelper.SKIP:
            self.postponed_contribution = postponed_contribution 
        if postponed_year is not APIHelper.SKIP:
            self.postponed_year = postponed_year 
        if postponed_code is not APIHelper.SKIP:
            self.postponed_code = postponed_code 
        if repayments is not APIHelper.SKIP:
            self.repayments = repayments 
        if repay_code is not APIHelper.SKIP:
            self.repay_code = repay_code 
        if fmv_specified_assets is not APIHelper.SKIP:
            self.fmv_specified_assets = fmv_specified_assets 
        if specified_codes is not APIHelper.SKIP:
            self.specified_codes = specified_codes 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        ira_contributions = dictionary.get("iraContributions") if dictionary.get("iraContributions") else APIHelper.SKIP
        rollover_contributions = dictionary.get("rolloverContributions") if dictionary.get("rolloverContributions") else APIHelper.SKIP
        roth_ira_conversion = dictionary.get("rothIraConversion") if dictionary.get("rothIraConversion") else APIHelper.SKIP
        recharacterized_contributions = dictionary.get("recharacterizedContributions") if dictionary.get("recharacterizedContributions") else APIHelper.SKIP
        fair_market_value = dictionary.get("fairMarketValue") if dictionary.get("fairMarketValue") else APIHelper.SKIP
        life_insurance_cost = dictionary.get("lifeInsuranceCost") if dictionary.get("lifeInsuranceCost") else APIHelper.SKIP
        ira = dictionary.get("ira") if "ira" in dictionary.keys() else APIHelper.SKIP
        sep = dictionary.get("sep") if "sep" in dictionary.keys() else APIHelper.SKIP
        simple = dictionary.get("simple") if "simple" in dictionary.keys() else APIHelper.SKIP
        roth_ira = dictionary.get("rothIra") if "rothIra" in dictionary.keys() else APIHelper.SKIP
        sep_contributions = dictionary.get("sepContributions") if dictionary.get("sepContributions") else APIHelper.SKIP
        simple_contributions = dictionary.get("simpleContributions") if dictionary.get("simpleContributions") else APIHelper.SKIP
        roth_ira_contributions = dictionary.get("rothIraContributions") if dictionary.get("rothIraContributions") else APIHelper.SKIP
        rmd_next_year = dictionary.get("rmdNextYear") if "rmdNextYear" in dictionary.keys() else APIHelper.SKIP
        rmd_date = dateutil.parser.parse(dictionary.get('rmdDate')).date() if dictionary.get('rmdDate') else APIHelper.SKIP
        rmd_amount = dictionary.get("rmdAmount") if dictionary.get("rmdAmount") else APIHelper.SKIP
        postponed_contribution = dictionary.get("postponedContribution") if dictionary.get("postponedContribution") else APIHelper.SKIP
        postponed_year = dictionary.get("postponedYear") if dictionary.get("postponedYear") else APIHelper.SKIP
        postponed_code = dictionary.get("postponedCode") if dictionary.get("postponedCode") else APIHelper.SKIP
        repayments = dictionary.get("repayments") if dictionary.get("repayments") else APIHelper.SKIP
        repay_code = dictionary.get("repayCode") if dictionary.get("repayCode") else APIHelper.SKIP
        fmv_specified_assets = dictionary.get("fmvSpecifiedAssets") if dictionary.get("fmvSpecifiedAssets") else APIHelper.SKIP
        specified_codes = dictionary.get("specifiedCodes") if dictionary.get("specifiedCodes") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   ira_contributions,
                   rollover_contributions,
                   roth_ira_conversion,
                   recharacterized_contributions,
                   fair_market_value,
                   life_insurance_cost,
                   ira,
                   sep,
                   simple,
                   roth_ira,
                   sep_contributions,
                   simple_contributions,
                   roth_ira_contributions,
                   rmd_next_year,
                   rmd_date,
                   rmd_amount,
                   postponed_contribution,
                   postponed_year,
                   postponed_code,
                   repayments,
                   repay_code,
                   fmv_specified_assets,
                   specified_codes,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'ira_contributions={(self.ira_contributions if hasattr(self, "ira_contributions") else None)!r}, '
                f'rollover_contributions={(self.rollover_contributions if hasattr(self, "rollover_contributions") else None)!r}, '
                f'roth_ira_conversion={(self.roth_ira_conversion if hasattr(self, "roth_ira_conversion") else None)!r}, '
                f'recharacterized_contributions={(self.recharacterized_contributions if hasattr(self, "recharacterized_contributions") else None)!r}, '
                f'fair_market_value={(self.fair_market_value if hasattr(self, "fair_market_value") else None)!r}, '
                f'life_insurance_cost={(self.life_insurance_cost if hasattr(self, "life_insurance_cost") else None)!r}, '
                f'ira={(self.ira if hasattr(self, "ira") else None)!r}, '
                f'sep={(self.sep if hasattr(self, "sep") else None)!r}, '
                f'simple={(self.simple if hasattr(self, "simple") else None)!r}, '
                f'roth_ira={(self.roth_ira if hasattr(self, "roth_ira") else None)!r}, '
                f'sep_contributions={(self.sep_contributions if hasattr(self, "sep_contributions") else None)!r}, '
                f'simple_contributions={(self.simple_contributions if hasattr(self, "simple_contributions") else None)!r}, '
                f'roth_ira_contributions={(self.roth_ira_contributions if hasattr(self, "roth_ira_contributions") else None)!r}, '
                f'rmd_next_year={(self.rmd_next_year if hasattr(self, "rmd_next_year") else None)!r}, '
                f'rmd_date={(self.rmd_date if hasattr(self, "rmd_date") else None)!r}, '
                f'rmd_amount={(self.rmd_amount if hasattr(self, "rmd_amount") else None)!r}, '
                f'postponed_contribution={(self.postponed_contribution if hasattr(self, "postponed_contribution") else None)!r}, '
                f'postponed_year={(self.postponed_year if hasattr(self, "postponed_year") else None)!r}, '
                f'postponed_code={(self.postponed_code if hasattr(self, "postponed_code") else None)!r}, '
                f'repayments={(self.repayments if hasattr(self, "repayments") else None)!r}, '
                f'repay_code={(self.repay_code if hasattr(self, "repay_code") else None)!r}, '
                f'fmv_specified_assets={(self.fmv_specified_assets if hasattr(self, "fmv_specified_assets") else None)!r}, '
                f'specified_codes={(self.specified_codes if hasattr(self, "specified_codes") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'ira_contributions={(self.ira_contributions if hasattr(self, "ira_contributions") else None)!s}, '
                f'rollover_contributions={(self.rollover_contributions if hasattr(self, "rollover_contributions") else None)!s}, '
                f'roth_ira_conversion={(self.roth_ira_conversion if hasattr(self, "roth_ira_conversion") else None)!s}, '
                f'recharacterized_contributions={(self.recharacterized_contributions if hasattr(self, "recharacterized_contributions") else None)!s}, '
                f'fair_market_value={(self.fair_market_value if hasattr(self, "fair_market_value") else None)!s}, '
                f'life_insurance_cost={(self.life_insurance_cost if hasattr(self, "life_insurance_cost") else None)!s}, '
                f'ira={(self.ira if hasattr(self, "ira") else None)!s}, '
                f'sep={(self.sep if hasattr(self, "sep") else None)!s}, '
                f'simple={(self.simple if hasattr(self, "simple") else None)!s}, '
                f'roth_ira={(self.roth_ira if hasattr(self, "roth_ira") else None)!s}, '
                f'sep_contributions={(self.sep_contributions if hasattr(self, "sep_contributions") else None)!s}, '
                f'simple_contributions={(self.simple_contributions if hasattr(self, "simple_contributions") else None)!s}, '
                f'roth_ira_contributions={(self.roth_ira_contributions if hasattr(self, "roth_ira_contributions") else None)!s}, '
                f'rmd_next_year={(self.rmd_next_year if hasattr(self, "rmd_next_year") else None)!s}, '
                f'rmd_date={(self.rmd_date if hasattr(self, "rmd_date") else None)!s}, '
                f'rmd_amount={(self.rmd_amount if hasattr(self, "rmd_amount") else None)!s}, '
                f'postponed_contribution={(self.postponed_contribution if hasattr(self, "postponed_contribution") else None)!s}, '
                f'postponed_year={(self.postponed_year if hasattr(self, "postponed_year") else None)!s}, '
                f'postponed_code={(self.postponed_code if hasattr(self, "postponed_code") else None)!s}, '
                f'repayments={(self.repayments if hasattr(self, "repayments") else None)!s}, '
                f'repay_code={(self.repay_code if hasattr(self, "repay_code") else None)!s}, '
                f'fmv_specified_assets={(self.fmv_specified_assets if hasattr(self, "fmv_specified_assets") else None)!s}, '
                f'specified_codes={(self.specified_codes if hasattr(self, "specified_codes") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
