# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class HateoasLink(object):

    """Implementation of the 'HATEOAS Link' model.

    REST application constraint (Hypermedia As The Engine Of Application State)

    Attributes:
        href (str): URL to invoke the action on the resource
        action (HttpActionType): HTTP Method to use for the request
        rel (str): Relation of this link to its containing entity, as defined
            by and with many example relation values at [IETF
            RFC5988](https://datatracker.ietf.org/doc/html/rfc5988)
        types (List[ContentTypes]): Content-types that can be used in the
            Accept header
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "href": 'href',
        "action": 'action',
        "rel": 'rel',
        "types": 'types'
    }

    _optionals = [
        'action',
        'rel',
        'types',
    ]

    def __init__(self,
                 href=None,
                 action=APIHelper.SKIP,
                 rel=APIHelper.SKIP,
                 types=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the HateoasLink class"""

        # Initialize members of the class
        self.href = href 
        if action is not APIHelper.SKIP:
            self.action = action 
        if rel is not APIHelper.SKIP:
            self.rel = rel 
        if types is not APIHelper.SKIP:
            self.types = types 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        href = dictionary.get("href") if dictionary.get("href") else None
        action = dictionary.get("action") if dictionary.get("action") else APIHelper.SKIP
        rel = dictionary.get("rel") if dictionary.get("rel") else APIHelper.SKIP
        types = dictionary.get("types") if dictionary.get("types") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(href,
                   action,
                   rel,
                   types,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.href,
                                           type_callable=lambda value: isinstance(value, str))

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('href'),
                                       type_callable=lambda value: isinstance(value, str))

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'href={self.href!r}, '
                f'action={(self.action if hasattr(self, "action") else None)!r}, '
                f'rel={(self.rel if hasattr(self, "rel") else None)!r}, '
                f'types={(self.types if hasattr(self, "types") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'href={self.href!s}, '
                f'action={(self.action if hasattr(self, "action") else None)!s}, '
                f'rel={(self.rel if hasattr(self, "rel") else None)!s}, '
                f'types={(self.types if hasattr(self, "types") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
