# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class Iso93622014BusinessIdentifierCodeEntity(object):

    """Implementation of the 'ISO 9362:2014 Business Identifier Code entity' model.

    [ISO
    9362:2014](https://www.swift.com/standards/data-standards/bic-business-iden
    tifier-code)
    Business Identifier Code for Financial Institutions
    (see [whitepaper](https://www.swift.com/swift-resource/14256/download))
    Deprecated and superceded by `Iso9362BusinessIdCode2022` (ISO 9362:2022).
    BICFIDec2014Identifier will be
    removed after multi-year transition from 9362:2014

    Attributes:
        bic_fi_dec_2014_id (str): Business identifier code of the financial
            institution
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "bic_fi_dec_2014_id": 'bicFIDec2014Id'
    }

    _optionals = [
        'bic_fi_dec_2014_id',
    ]

    def __init__(self,
                 bic_fi_dec_2014_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Iso93622014BusinessIdentifierCodeEntity class"""

        # Initialize members of the class
        if bic_fi_dec_2014_id is not APIHelper.SKIP:
            self.bic_fi_dec_2014_id = bic_fi_dec_2014_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        bic_fi_dec_2014_id = dictionary.get("bicFIDec2014Id") if dictionary.get("bicFIDec2014Id") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(bic_fi_dec_2014_id,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'bic_fi_dec_2014_id={(self.bic_fi_dec_2014_id if hasattr(self, "bic_fi_dec_2014_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'bic_fi_dec_2014_id={(self.bic_fi_dec_2014_id if hasattr(self, "bic_fi_dec_2014_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
