# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class LocalTaxWithholding(object):

    """Implementation of the 'Local Tax Withholding' model.

    Income in a locality and its tax withholding

    Attributes:
        tax_withheld (float): Amount of local income tax withheld
        locality_name (str): Locality name
        income (float): Income amount for local tax purposes
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_withheld": 'taxWithheld',
        "locality_name": 'localityName',
        "income": 'income'
    }

    _optionals = [
        'tax_withheld',
        'locality_name',
        'income',
    ]

    def __init__(self,
                 tax_withheld=APIHelper.SKIP,
                 locality_name=APIHelper.SKIP,
                 income=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the LocalTaxWithholding class"""

        # Initialize members of the class
        if tax_withheld is not APIHelper.SKIP:
            self.tax_withheld = tax_withheld 
        if locality_name is not APIHelper.SKIP:
            self.locality_name = locality_name 
        if income is not APIHelper.SKIP:
            self.income = income 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_withheld = dictionary.get("taxWithheld") if dictionary.get("taxWithheld") else APIHelper.SKIP
        locality_name = dictionary.get("localityName") if dictionary.get("localityName") else APIHelper.SKIP
        income = dictionary.get("income") if dictionary.get("income") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_withheld,
                   locality_name,
                   income,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_withheld={(self.tax_withheld if hasattr(self, "tax_withheld") else None)!r}, '
                f'locality_name={(self.locality_name if hasattr(self, "locality_name") else None)!r}, '
                f'income={(self.income if hasattr(self, "income") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_withheld={(self.tax_withheld if hasattr(self, "tax_withheld") else None)!s}, '
                f'locality_name={(self.locality_name if hasattr(self, "locality_name") else None)!s}, '
                f'income={(self.income if hasattr(self, "income") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
