# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.notification_payload_entity_2 import NotificationPayloadEntity2
from fdxapi.models.party_entity import PartyEntity


class NotificationEntity(object):

    """Implementation of the 'Notification entity' model.

    Provides the base fields of a notification. Clients will read the `type`
    property to determine the expected notification payload

    Attributes:
        notification_id (str): Id of notification
        mtype (NotificationType): Type of notification
        sent_on (datetime): Time notification was sent
        category (NotificationCategory1): Category of notification
        severity (NotificationSeverity2): Notification severity
        priority (NotificationPriority2): Notification priority
        publisher (PartyEntity): Publisher of notification
        subscriber (PartyEntity): Subscriber to this notification
        notification_payload (NotificationPayloadEntity2):
            Notification-specific key-value paired data
        url (HateoasLink): URL to retrieve further details related to
            notification
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "notification_id": 'notificationId',
        "mtype": 'type',
        "sent_on": 'sentOn',
        "category": 'category',
        "publisher": 'publisher',
        "notification_payload": 'notificationPayload',
        "severity": 'severity',
        "priority": 'priority',
        "subscriber": 'subscriber',
        "url": 'url'
    }

    _optionals = [
        'severity',
        'priority',
        'subscriber',
        'url',
    ]

    def __init__(self,
                 notification_id=None,
                 mtype=None,
                 sent_on=None,
                 category=None,
                 publisher=None,
                 notification_payload=None,
                 severity=APIHelper.SKIP,
                 priority=APIHelper.SKIP,
                 subscriber=APIHelper.SKIP,
                 url=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the NotificationEntity class"""

        # Initialize members of the class
        self.notification_id = notification_id 
        self.mtype = mtype 
        self.sent_on = APIHelper.apply_datetime_converter(sent_on, APIHelper.RFC3339DateTime) if sent_on else None 
        self.category = category 
        if severity is not APIHelper.SKIP:
            self.severity = severity 
        if priority is not APIHelper.SKIP:
            self.priority = priority 
        self.publisher = publisher 
        if subscriber is not APIHelper.SKIP:
            self.subscriber = subscriber 
        self.notification_payload = notification_payload 
        if url is not APIHelper.SKIP:
            self.url = url 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        notification_id = dictionary.get("notificationId") if dictionary.get("notificationId") else None
        mtype = dictionary.get("type") if dictionary.get("type") else None
        sent_on = APIHelper.RFC3339DateTime.from_value(dictionary.get("sentOn")).datetime if dictionary.get("sentOn") else None
        category = dictionary.get("category") if dictionary.get("category") else None
        publisher = PartyEntity.from_dictionary(dictionary.get('publisher')) if dictionary.get('publisher') else None
        notification_payload = NotificationPayloadEntity2.from_dictionary(dictionary.get('notificationPayload')) if dictionary.get('notificationPayload') else None
        severity = dictionary.get("severity") if dictionary.get("severity") else APIHelper.SKIP
        priority = dictionary.get("priority") if dictionary.get("priority") else APIHelper.SKIP
        subscriber = PartyEntity.from_dictionary(dictionary.get('subscriber')) if 'subscriber' in dictionary.keys() else APIHelper.SKIP
        url = HateoasLink.from_dictionary(dictionary.get('url')) if 'url' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(notification_id,
                   mtype,
                   sent_on,
                   category,
                   publisher,
                   notification_payload,
                   severity,
                   priority,
                   subscriber,
                   url,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'notification_id={self.notification_id!r}, '
                f'mtype={self.mtype!r}, '
                f'sent_on={self.sent_on!r}, '
                f'category={self.category!r}, '
                f'severity={(self.severity if hasattr(self, "severity") else None)!r}, '
                f'priority={(self.priority if hasattr(self, "priority") else None)!r}, '
                f'publisher={self.publisher!r}, '
                f'subscriber={(self.subscriber if hasattr(self, "subscriber") else None)!r}, '
                f'notification_payload={self.notification_payload!r}, '
                f'url={(self.url if hasattr(self, "url") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'notification_id={self.notification_id!s}, '
                f'mtype={self.mtype!s}, '
                f'sent_on={self.sent_on!s}, '
                f'category={self.category!s}, '
                f'severity={(self.severity if hasattr(self, "severity") else None)!s}, '
                f'priority={(self.priority if hasattr(self, "priority") else None)!s}, '
                f'publisher={self.publisher!s}, '
                f'subscriber={(self.subscriber if hasattr(self, "subscriber") else None)!s}, '
                f'notification_payload={self.notification_payload!s}, '
                f'url={(self.url if hasattr(self, "url") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
