# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PaymentInitiationPartyCreateResponseEntity(object):

    """Implementation of the 'Payment Initiation Party Create Response entity' model.

    Entity that stores FI payment initiation party details. Each payment
    initiation party  will have a separate entry per FI customer, e.g. we
    might have multiple payment initiation parties that represent the same
    physical person, nevertheless since they are registered for separate
    customers then they will have separate entries.

    Attributes:
        payment_initiation_party_id (str): Unique identifier of a payment
            initiation party
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_initiation_party_id": 'paymentInitiationPartyId'
    }

    _optionals = [
        'payment_initiation_party_id',
    ]

    def __init__(self,
                 payment_initiation_party_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentInitiationPartyCreateResponseEntity class"""

        # Initialize members of the class
        if payment_initiation_party_id is not APIHelper.SKIP:
            self.payment_initiation_party_id = payment_initiation_party_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_initiation_party_id = dictionary.get("paymentInitiationPartyId") if dictionary.get("paymentInitiationPartyId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(payment_initiation_party_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'payment_initiation_party_id={(self.payment_initiation_party_id if hasattr(self, "payment_initiation_party_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'payment_initiation_party_id={(self.payment_initiation_party_id if hasattr(self, "payment_initiation_party_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
