# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.payment_delivery_address_entity import PaymentDeliveryAddressEntity
from fdxapi.models.payment_method_entity_2 import PaymentMethodEntity2


class PaymentInitiationPartyToPaymentMethodEntity(object):

    """Implementation of the 'Payment Initiation Party To Payment Method entity' model.

    Registration between a payment initiation party and a Payment Method

    Attributes:
        registration_id (str): Registration ID
        payment_method (PaymentMethodEntity2): Payment method details
        account (PaymentMethodCreditAccountEntity |
            PaymentMethodDebitAccountEntity | None): Account details
        locations (List[PaymentDeliveryAddressEntity]): Address associated
            with the payment method registration of a payment initiation party
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "registration_id": 'registrationId',
        "payment_method": 'paymentMethod',
        "account": 'account',
        "locations": 'locations'
    }

    _optionals = [
        'registration_id',
        'payment_method',
        'account',
        'locations',
    ]

    def __init__(self,
                 registration_id=APIHelper.SKIP,
                 payment_method=APIHelper.SKIP,
                 account=APIHelper.SKIP,
                 locations=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentInitiationPartyToPaymentMethodEntity class"""

        # Initialize members of the class
        if registration_id is not APIHelper.SKIP:
            self.registration_id = registration_id 
        if payment_method is not APIHelper.SKIP:
            self.payment_method = payment_method 
        if account is not APIHelper.SKIP:
            self.account = account 
        if locations is not APIHelper.SKIP:
            self.locations = locations 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        registration_id = dictionary.get("registrationId") if dictionary.get("registrationId") else APIHelper.SKIP
        payment_method = PaymentMethodEntity2.from_dictionary(dictionary.get('paymentMethod')) if 'paymentMethod' in dictionary.keys() else APIHelper.SKIP
        account = APIHelper.deserialize_union_type(UnionTypeLookUp.get('PaymentInitiationPartyToPaymentMethodEntityAccount'), dictionary.get('account'), False) if dictionary.get('account') is not None else APIHelper.SKIP
        locations = None
        if dictionary.get('locations') is not None:
            locations = [PaymentDeliveryAddressEntity.from_dictionary(x) for x in dictionary.get('locations')]
        else:
            locations = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(registration_id,
                   payment_method,
                   account,
                   locations,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'registration_id={(self.registration_id if hasattr(self, "registration_id") else None)!r}, '
                f'payment_method={(self.payment_method if hasattr(self, "payment_method") else None)!r}, '
                f'account={(self.account if hasattr(self, "account") else None)!r}, '
                f'locations={(self.locations if hasattr(self, "locations") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'registration_id={(self.registration_id if hasattr(self, "registration_id") else None)!s}, '
                f'payment_method={(self.payment_method if hasattr(self, "payment_method") else None)!s}, '
                f'account={(self.account if hasattr(self, "account") else None)!s}, '
                f'locations={(self.locations if hasattr(self, "locations") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
