# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.business_name import BusinessName
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.individual_name import IndividualName


class PayrollReportSummaryEntity(object):

    """Implementation of the 'Payroll Report Summary entity' model.

    The list of payroll reports for an employee

    Attributes:
        report_id (str): The report identification number
        report_type (PayrollReportType1): The type of report
        generation_date (date): The generation date of the report
        data_as_of (date): The data in the report is as of this date.
        employee_id (str): Provider's long-term persistent id for the employee
        employee_name (IndividualName): Employee's full name
        employer_id (str): The employer for this report
        employer_name (BusinessName): The employer's name
        links (List[HateoasLink]): Links to retrieve this payroll report, or
            to invoke related APIs
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "report_id": 'reportId',
        "report_type": 'reportType',
        "generation_date": 'generationDate',
        "employee_name": 'employeeName',
        "employer_name": 'employerName',
        "data_as_of": 'dataAsOf',
        "employee_id": 'employeeId',
        "employer_id": 'employerId',
        "links": 'links'
    }

    _optionals = [
        'data_as_of',
        'employee_id',
        'employer_id',
        'links',
    ]

    def __init__(self,
                 report_id=None,
                 report_type=None,
                 generation_date=None,
                 employee_name=None,
                 employer_name=None,
                 data_as_of=APIHelper.SKIP,
                 employee_id=APIHelper.SKIP,
                 employer_id=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PayrollReportSummaryEntity class"""

        # Initialize members of the class
        self.report_id = report_id 
        self.report_type = report_type 
        self.generation_date = generation_date 
        if data_as_of is not APIHelper.SKIP:
            self.data_as_of = data_as_of 
        if employee_id is not APIHelper.SKIP:
            self.employee_id = employee_id 
        self.employee_name = employee_name 
        if employer_id is not APIHelper.SKIP:
            self.employer_id = employer_id 
        self.employer_name = employer_name 
        if links is not APIHelper.SKIP:
            self.links = links 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        report_id = dictionary.get("reportId") if dictionary.get("reportId") else None
        report_type = dictionary.get("reportType") if dictionary.get("reportType") else None
        generation_date = dateutil.parser.parse(dictionary.get('generationDate')).date() if dictionary.get('generationDate') else None
        employee_name = IndividualName.from_dictionary(dictionary.get('employeeName')) if dictionary.get('employeeName') else None
        employer_name = BusinessName.from_dictionary(dictionary.get('employerName')) if dictionary.get('employerName') else None
        data_as_of = dateutil.parser.parse(dictionary.get('dataAsOf')).date() if dictionary.get('dataAsOf') else APIHelper.SKIP
        employee_id = dictionary.get("employeeId") if dictionary.get("employeeId") else APIHelper.SKIP
        employer_id = dictionary.get("employerId") if dictionary.get("employerId") else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(report_id,
                   report_type,
                   generation_date,
                   employee_name,
                   employer_name,
                   data_as_of,
                   employee_id,
                   employer_id,
                   links,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'report_id={self.report_id!r}, '
                f'report_type={self.report_type!r}, '
                f'generation_date={self.generation_date!r}, '
                f'data_as_of={(self.data_as_of if hasattr(self, "data_as_of") else None)!r}, '
                f'employee_id={(self.employee_id if hasattr(self, "employee_id") else None)!r}, '
                f'employee_name={self.employee_name!r}, '
                f'employer_id={(self.employer_id if hasattr(self, "employer_id") else None)!r}, '
                f'employer_name={self.employer_name!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'report_id={self.report_id!s}, '
                f'report_type={self.report_type!s}, '
                f'generation_date={self.generation_date!s}, '
                f'data_as_of={(self.data_as_of if hasattr(self, "data_as_of") else None)!s}, '
                f'employee_id={(self.employee_id if hasattr(self, "employee_id") else None)!s}, '
                f'employee_name={self.employee_name!s}, '
                f'employer_id={(self.employer_id if hasattr(self, "employer_id") else None)!s}, '
                f'employer_name={self.employer_name!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
