# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""


class PolicyStatus(object):

    """Implementation of the 'Policy Status' enum.

    The status of an insurance policy account.
      | Value | Description |
      |-----|-----|
      | ACTIVE | At least one component of the insurance policy is in force |
      | DEATH_CLAIM_PAID | Benefits for a death claim have been settled with
    the insured |
      | DEATH_CLAIM_PENDING | A death claim has been submitted but not yet
    settled |
      | EXPIRED | Nonpayment of premium has exhausted the policy's Grace
    Period |
      | GRACE_PERIOD | A premium is due but before lapse in coverage begins |
      | LAPSE_PENDING | After the Grace Period has been exhausted but before
    final expiration; during Lapse Pending, policy reinstatement may still be
    possible |
      | TERMINATED | Either the insurance company or the insured cancel the
    coverage of a cancellable insurance policy |
      | WAIVER | A premium payment is waived under certain conditions due to a
    payer benefit clause |

    Attributes:
        ACTIVE: The enum member of type str.
        DEATH_CLAIM_PAID: The enum member of type str.
        DEATH_CLAIM_PENDING: The enum member of type str.
        EXPIRED: The enum member of type str.
        GRACE_PERIOD: The enum member of type str.
        LAPSE_PENDING: The enum member of type str.
        TERMINATED: The enum member of type str.
        WAIVER: The enum member of type str.
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """
    ACTIVE = 'ACTIVE'

    DEATH_CLAIM_PAID = 'DEATH_CLAIM_PAID'

    DEATH_CLAIM_PENDING = 'DEATH_CLAIM_PENDING'

    EXPIRED = 'EXPIRED'

    GRACE_PERIOD = 'GRACE_PERIOD'

    LAPSE_PENDING = 'LAPSE_PENDING'

    TERMINATED = 'TERMINATED'

    WAIVER = 'WAIVER'

    @classmethod
    def validate(cls, value):
        """Validates value contains in enum

        Args:
            value: the value to be validated

        Returns:
            boolean : if value is valid enum values.

        """
        return True if value else False 
