# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.reward_balance_entity import RewardBalanceEntity


class RewardProgramMembershipEntity(object):

    """Implementation of the 'Reward Program Membership entity' model.

    Details of a single membership in a reward programs

    Attributes:
        account_ids (List[str]): accountIds associated to the reward program
        customer_id (str): Long-term persistent identity of the associated
            Customer
        member_id (str): Long term persistent identity of the program member
        member_number (str): Reward program membership number
        member_tier (str): If the reward program is tiered, member's current
            tier
        business_or_consumer (BusinessOrConsumerType1): BUSINESS or CONSUMER
            membership
        balances (List[RewardBalanceEntity]): Array of balances
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_ids": 'accountIds',
        "customer_id": 'customerId',
        "member_id": 'memberId',
        "member_number": 'memberNumber',
        "member_tier": 'memberTier',
        "business_or_consumer": 'businessOrConsumer',
        "balances": 'balances'
    }

    _optionals = [
        'account_ids',
        'customer_id',
        'member_id',
        'member_number',
        'member_tier',
        'business_or_consumer',
        'balances',
    ]

    def __init__(self,
                 account_ids=APIHelper.SKIP,
                 customer_id=APIHelper.SKIP,
                 member_id=APIHelper.SKIP,
                 member_number=APIHelper.SKIP,
                 member_tier=APIHelper.SKIP,
                 business_or_consumer=APIHelper.SKIP,
                 balances=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RewardProgramMembershipEntity class"""

        # Initialize members of the class
        if account_ids is not APIHelper.SKIP:
            self.account_ids = account_ids 
        if customer_id is not APIHelper.SKIP:
            self.customer_id = customer_id 
        if member_id is not APIHelper.SKIP:
            self.member_id = member_id 
        if member_number is not APIHelper.SKIP:
            self.member_number = member_number 
        if member_tier is not APIHelper.SKIP:
            self.member_tier = member_tier 
        if business_or_consumer is not APIHelper.SKIP:
            self.business_or_consumer = business_or_consumer 
        if balances is not APIHelper.SKIP:
            self.balances = balances 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        account_ids = dictionary.get("accountIds") if dictionary.get("accountIds") else APIHelper.SKIP
        customer_id = dictionary.get("customerId") if dictionary.get("customerId") else APIHelper.SKIP
        member_id = dictionary.get("memberId") if dictionary.get("memberId") else APIHelper.SKIP
        member_number = dictionary.get("memberNumber") if dictionary.get("memberNumber") else APIHelper.SKIP
        member_tier = dictionary.get("memberTier") if dictionary.get("memberTier") else APIHelper.SKIP
        business_or_consumer = dictionary.get("businessOrConsumer") if dictionary.get("businessOrConsumer") else APIHelper.SKIP
        balances = None
        if dictionary.get('balances') is not None:
            balances = [RewardBalanceEntity.from_dictionary(x) for x in dictionary.get('balances')]
        else:
            balances = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(account_ids,
                   customer_id,
                   member_id,
                   member_number,
                   member_tier,
                   business_or_consumer,
                   balances,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'account_ids={(self.account_ids if hasattr(self, "account_ids") else None)!r}, '
                f'customer_id={(self.customer_id if hasattr(self, "customer_id") else None)!r}, '
                f'member_id={(self.member_id if hasattr(self, "member_id") else None)!r}, '
                f'member_number={(self.member_number if hasattr(self, "member_number") else None)!r}, '
                f'member_tier={(self.member_tier if hasattr(self, "member_tier") else None)!r}, '
                f'business_or_consumer={(self.business_or_consumer if hasattr(self, "business_or_consumer") else None)!r}, '
                f'balances={(self.balances if hasattr(self, "balances") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'account_ids={(self.account_ids if hasattr(self, "account_ids") else None)!s}, '
                f'customer_id={(self.customer_id if hasattr(self, "customer_id") else None)!s}, '
                f'member_id={(self.member_id if hasattr(self, "member_id") else None)!s}, '
                f'member_number={(self.member_number if hasattr(self, "member_number") else None)!s}, '
                f'member_tier={(self.member_tier if hasattr(self, "member_tier") else None)!s}, '
                f'business_or_consumer={(self.business_or_consumer if hasattr(self, "business_or_consumer") else None)!s}, '
                f'balances={(self.balances if hasattr(self, "balances") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
