# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.page_metadata import PageMetadata
from fdxapi.models.page_metadata_links import PageMetadataLinks
from fdxapi.models.reward_program_entity import RewardProgramEntity


class RewardProgramsEntity(object):

    """Implementation of the 'Reward Programs entity' model.

    An optionally paginated array of reward programs

    Attributes:
        page (PageMetadata): Offset IDs for navigating result sets
        links (PageMetadataLinks): Resource URLs for navigating result sets
        reward_programs (List[RewardProgramEntity]): Array of reward programs
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "page": 'page',
        "links": 'links',
        "reward_programs": 'rewardPrograms'
    }

    _optionals = [
        'page',
        'links',
        'reward_programs',
    ]

    def __init__(self,
                 page=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 reward_programs=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RewardProgramsEntity class"""

        # Initialize members of the class
        if page is not APIHelper.SKIP:
            self.page = page 
        if links is not APIHelper.SKIP:
            self.links = links 
        if reward_programs is not APIHelper.SKIP:
            self.reward_programs = reward_programs 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        page = PageMetadata.from_dictionary(dictionary.get('page')) if 'page' in dictionary.keys() else APIHelper.SKIP
        links = PageMetadataLinks.from_dictionary(dictionary.get('links')) if 'links' in dictionary.keys() else APIHelper.SKIP
        reward_programs = None
        if dictionary.get('rewardPrograms') is not None:
            reward_programs = [RewardProgramEntity.from_dictionary(x) for x in dictionary.get('rewardPrograms')]
        else:
            reward_programs = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(page,
                   links,
                   reward_programs,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'reward_programs={(self.reward_programs if hasattr(self, "reward_programs") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'reward_programs={(self.reward_programs if hasattr(self, "reward_programs") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
