# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class SecurityEntity(object):

    """Implementation of the 'Security entity' model.

    A base Security entity which defines the type of this security

    Attributes:
        security_category (str): The model property of type str.
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "security_category": 'securityCategory'
    }

    _optionals = [
        'security_category',
    ]

    def __init__(self,
                 security_category='Security entity',
                 additional_properties=None):
        """Constructor for the SecurityEntity class"""

        # Initialize members of the class
        self.security_category = security_category 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        discriminators = {
            'Debt Security entity': DebtSecurityEntity.from_dictionary,
            'Mutual Fund Security entity': MutualFundSecurityEntity.from_dictionary,
            'Option Security entity': OptionSecurityEntity.from_dictionary,
            'Other Security entity': OtherSecurityEntity.from_dictionary,
            'Stock Security entity': StockSecurityEntity.from_dictionary,
            'Sweep Security entity': SweepSecurityEntity.from_dictionary
        }
        unboxer = discriminators.get(dictionary.get('securityCategory'))

        # Delegate unboxing to another function if a discriminator
        # value for a child class is present.
        if unboxer:
            return unboxer(dictionary)

        # Extract variables from the dictionary
        security_category = dictionary.get("securityCategory") if dictionary.get("securityCategory") else 'Security entity'
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(security_category,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'security_category={(self.security_category if hasattr(self, "security_category") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'security_category={(self.security_category if hasattr(self, "security_category") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')

class DebtSecurityEntity(SecurityEntity):

    """Implementation of the 'Debt Security entity' model.

    An investment in a debt security
    NOTE: This class inherits from 'SecurityEntity'.

    Attributes:
        par_value (float): Par value amount
        debt_type (DebtType2): Debt type. One of COUPON, ZERO
        debt_class (DebtClass2): Classification of debt. One of TREASURY,
            MUNICIPAL, CORPORATE, OTHER
        coupon_rate (float): Bond coupon rate for next closest call date
        coupon_date (date): Maturity date for next coupon
        coupon_mature_frequency (CouponMatureFrequency2): When coupons mature.
            One of MONTHLY, QUARTERLY,  SEMIANNUAL, ANNUAL, OTHER
        call_price (float): Bond call price
        yield_to_call (float): Yield to next call
        call_date (date): Next call date
        call_type (CallType2): Type of next call. One of CALL, PUT, PREFUND,
            MATURITY
        yield_to_maturity (float): Yield to maturity
        bond_maturity_date (date): Bond maturity date
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "par_value": 'parValue',
        "debt_type": 'debtType',
        "debt_class": 'debtClass',
        "coupon_rate": 'couponRate',
        "coupon_date": 'couponDate',
        "coupon_mature_frequency": 'couponMatureFrequency',
        "call_price": 'callPrice',
        "yield_to_call": 'yieldToCall',
        "call_date": 'callDate',
        "call_type": 'callType',
        "yield_to_maturity": 'yieldToMaturity',
        "bond_maturity_date": 'bondMaturityDate',
        "security_category": 'securityCategory'
    }

    _optionals = [
        'par_value',
        'debt_type',
        'debt_class',
        'coupon_rate',
        'coupon_date',
        'coupon_mature_frequency',
        'call_price',
        'yield_to_call',
        'call_date',
        'call_type',
        'yield_to_maturity',
        'bond_maturity_date',
    ]
    _optionals.extend(SecurityEntity._optionals)

    def __init__(self,
                 par_value=APIHelper.SKIP,
                 debt_type=APIHelper.SKIP,
                 debt_class=APIHelper.SKIP,
                 coupon_rate=APIHelper.SKIP,
                 coupon_date=APIHelper.SKIP,
                 coupon_mature_frequency=APIHelper.SKIP,
                 call_price=APIHelper.SKIP,
                 yield_to_call=APIHelper.SKIP,
                 call_date=APIHelper.SKIP,
                 call_type=APIHelper.SKIP,
                 yield_to_maturity=APIHelper.SKIP,
                 bond_maturity_date=APIHelper.SKIP,
                 security_category='Debt Security entity',
                 additional_properties=None):
        """Constructor for the DebtSecurityEntity class"""

        # Initialize members of the class
        if par_value is not APIHelper.SKIP:
            self.par_value = par_value 
        if debt_type is not APIHelper.SKIP:
            self.debt_type = debt_type 
        if debt_class is not APIHelper.SKIP:
            self.debt_class = debt_class 
        if coupon_rate is not APIHelper.SKIP:
            self.coupon_rate = coupon_rate 
        if coupon_date is not APIHelper.SKIP:
            self.coupon_date = coupon_date 
        if coupon_mature_frequency is not APIHelper.SKIP:
            self.coupon_mature_frequency = coupon_mature_frequency 
        if call_price is not APIHelper.SKIP:
            self.call_price = call_price 
        if yield_to_call is not APIHelper.SKIP:
            self.yield_to_call = yield_to_call 
        if call_date is not APIHelper.SKIP:
            self.call_date = call_date 
        if call_type is not APIHelper.SKIP:
            self.call_type = call_type 
        if yield_to_maturity is not APIHelper.SKIP:
            self.yield_to_maturity = yield_to_maturity 
        if bond_maturity_date is not APIHelper.SKIP:
            self.bond_maturity_date = bond_maturity_date 

        # Call the constructor for the base class
        super(DebtSecurityEntity, self).__init__(security_category,
                                                 additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        par_value = dictionary.get("parValue") if dictionary.get("parValue") else APIHelper.SKIP
        debt_type = dictionary.get("debtType") if dictionary.get("debtType") else APIHelper.SKIP
        debt_class = dictionary.get("debtClass") if dictionary.get("debtClass") else APIHelper.SKIP
        coupon_rate = dictionary.get("couponRate") if dictionary.get("couponRate") else APIHelper.SKIP
        coupon_date = dateutil.parser.parse(dictionary.get('couponDate')).date() if dictionary.get('couponDate') else APIHelper.SKIP
        coupon_mature_frequency = dictionary.get("couponMatureFrequency") if dictionary.get("couponMatureFrequency") else APIHelper.SKIP
        call_price = dictionary.get("callPrice") if dictionary.get("callPrice") else APIHelper.SKIP
        yield_to_call = dictionary.get("yieldToCall") if dictionary.get("yieldToCall") else APIHelper.SKIP
        call_date = dateutil.parser.parse(dictionary.get('callDate')).date() if dictionary.get('callDate') else APIHelper.SKIP
        call_type = dictionary.get("callType") if dictionary.get("callType") else APIHelper.SKIP
        yield_to_maturity = dictionary.get("yieldToMaturity") if dictionary.get("yieldToMaturity") else APIHelper.SKIP
        bond_maturity_date = dateutil.parser.parse(dictionary.get('bondMaturityDate')).date() if dictionary.get('bondMaturityDate') else APIHelper.SKIP
        security_category = dictionary.get("securityCategory") if dictionary.get("securityCategory") else 'Debt Security entity'
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(par_value,
                   debt_type,
                   debt_class,
                   coupon_rate,
                   coupon_date,
                   coupon_mature_frequency,
                   call_price,
                   yield_to_call,
                   call_date,
                   call_type,
                   yield_to_maturity,
                   bond_maturity_date,
                   security_category,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'par_value={(self.par_value if hasattr(self, "par_value") else None)!r}, '
                f'debt_type={(self.debt_type if hasattr(self, "debt_type") else None)!r}, '
                f'debt_class={(self.debt_class if hasattr(self, "debt_class") else None)!r}, '
                f'coupon_rate={(self.coupon_rate if hasattr(self, "coupon_rate") else None)!r}, '
                f'coupon_date={(self.coupon_date if hasattr(self, "coupon_date") else None)!r}, '
                f'coupon_mature_frequency={(self.coupon_mature_frequency if hasattr(self, "coupon_mature_frequency") else None)!r}, '
                f'call_price={(self.call_price if hasattr(self, "call_price") else None)!r}, '
                f'yield_to_call={(self.yield_to_call if hasattr(self, "yield_to_call") else None)!r}, '
                f'call_date={(self.call_date if hasattr(self, "call_date") else None)!r}, '
                f'call_type={(self.call_type if hasattr(self, "call_type") else None)!r}, '
                f'yield_to_maturity={(self.yield_to_maturity if hasattr(self, "yield_to_maturity") else None)!r}, '
                f'bond_maturity_date={(self.bond_maturity_date if hasattr(self, "bond_maturity_date") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'par_value={(self.par_value if hasattr(self, "par_value") else None)!s}, '
                f'debt_type={(self.debt_type if hasattr(self, "debt_type") else None)!s}, '
                f'debt_class={(self.debt_class if hasattr(self, "debt_class") else None)!s}, '
                f'coupon_rate={(self.coupon_rate if hasattr(self, "coupon_rate") else None)!s}, '
                f'coupon_date={(self.coupon_date if hasattr(self, "coupon_date") else None)!s}, '
                f'coupon_mature_frequency={(self.coupon_mature_frequency if hasattr(self, "coupon_mature_frequency") else None)!s}, '
                f'call_price={(self.call_price if hasattr(self, "call_price") else None)!s}, '
                f'yield_to_call={(self.yield_to_call if hasattr(self, "yield_to_call") else None)!s}, '
                f'call_date={(self.call_date if hasattr(self, "call_date") else None)!s}, '
                f'call_type={(self.call_type if hasattr(self, "call_type") else None)!s}, '
                f'yield_to_maturity={(self.yield_to_maturity if hasattr(self, "yield_to_maturity") else None)!s}, '
                f'bond_maturity_date={(self.bond_maturity_date if hasattr(self, "bond_maturity_date") else None)!s})')

class MutualFundSecurityEntity(SecurityEntity):

    """Implementation of the 'Mutual Fund Security entity' model.

    A mutual fund
    NOTE: This class inherits from 'SecurityEntity'.

    Attributes:
        mutual_fund_type (MutualFundType2): Mutual fund type. One of OPENEND,
            CLOSEEND, OTHER
        units_street (float): Units in the FI's street name, positive quantity
        units_user (float): Units in user's name directly, positive  quantity
        reinvest_dividends (bool): Reinvest dividends
        reinvest_capital_gains (bool): Reinvest capital gains
        myield (float): Current yield reported as portion of the fund's assets
        yield_as_of_date (date): As-of date for yield value
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mutual_fund_type": 'mutualFundType',
        "units_street": 'unitsStreet',
        "units_user": 'unitsUser',
        "reinvest_dividends": 'reinvestDividends',
        "reinvest_capital_gains": 'reinvestCapitalGains',
        "myield": 'yield',
        "yield_as_of_date": 'yieldAsOfDate',
        "security_category": 'securityCategory'
    }

    _optionals = [
        'mutual_fund_type',
        'units_street',
        'units_user',
        'reinvest_dividends',
        'reinvest_capital_gains',
        'myield',
        'yield_as_of_date',
    ]
    _optionals.extend(SecurityEntity._optionals)

    def __init__(self,
                 mutual_fund_type=APIHelper.SKIP,
                 units_street=APIHelper.SKIP,
                 units_user=APIHelper.SKIP,
                 reinvest_dividends=APIHelper.SKIP,
                 reinvest_capital_gains=APIHelper.SKIP,
                 myield=APIHelper.SKIP,
                 yield_as_of_date=APIHelper.SKIP,
                 security_category='Mutual Fund Security entity',
                 additional_properties=None):
        """Constructor for the MutualFundSecurityEntity class"""

        # Initialize members of the class
        if mutual_fund_type is not APIHelper.SKIP:
            self.mutual_fund_type = mutual_fund_type 
        if units_street is not APIHelper.SKIP:
            self.units_street = units_street 
        if units_user is not APIHelper.SKIP:
            self.units_user = units_user 
        if reinvest_dividends is not APIHelper.SKIP:
            self.reinvest_dividends = reinvest_dividends 
        if reinvest_capital_gains is not APIHelper.SKIP:
            self.reinvest_capital_gains = reinvest_capital_gains 
        if myield is not APIHelper.SKIP:
            self.myield = myield 
        if yield_as_of_date is not APIHelper.SKIP:
            self.yield_as_of_date = yield_as_of_date 

        # Call the constructor for the base class
        super(MutualFundSecurityEntity, self).__init__(security_category,
                                                       additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        mutual_fund_type = dictionary.get("mutualFundType") if dictionary.get("mutualFundType") else APIHelper.SKIP
        units_street = dictionary.get("unitsStreet") if dictionary.get("unitsStreet") else APIHelper.SKIP
        units_user = dictionary.get("unitsUser") if dictionary.get("unitsUser") else APIHelper.SKIP
        reinvest_dividends = dictionary.get("reinvestDividends") if "reinvestDividends" in dictionary.keys() else APIHelper.SKIP
        reinvest_capital_gains = dictionary.get("reinvestCapitalGains") if "reinvestCapitalGains" in dictionary.keys() else APIHelper.SKIP
        myield = dictionary.get("yield") if dictionary.get("yield") else APIHelper.SKIP
        yield_as_of_date = dateutil.parser.parse(dictionary.get('yieldAsOfDate')).date() if dictionary.get('yieldAsOfDate') else APIHelper.SKIP
        security_category = dictionary.get("securityCategory") if dictionary.get("securityCategory") else 'Mutual Fund Security entity'
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(mutual_fund_type,
                   units_street,
                   units_user,
                   reinvest_dividends,
                   reinvest_capital_gains,
                   myield,
                   yield_as_of_date,
                   security_category,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'mutual_fund_type={(self.mutual_fund_type if hasattr(self, "mutual_fund_type") else None)!r}, '
                f'units_street={(self.units_street if hasattr(self, "units_street") else None)!r}, '
                f'units_user={(self.units_user if hasattr(self, "units_user") else None)!r}, '
                f'reinvest_dividends={(self.reinvest_dividends if hasattr(self, "reinvest_dividends") else None)!r}, '
                f'reinvest_capital_gains={(self.reinvest_capital_gains if hasattr(self, "reinvest_capital_gains") else None)!r}, '
                f'myield={(self.myield if hasattr(self, "myield") else None)!r}, '
                f'yield_as_of_date={(self.yield_as_of_date if hasattr(self, "yield_as_of_date") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'mutual_fund_type={(self.mutual_fund_type if hasattr(self, "mutual_fund_type") else None)!s}, '
                f'units_street={(self.units_street if hasattr(self, "units_street") else None)!s}, '
                f'units_user={(self.units_user if hasattr(self, "units_user") else None)!s}, '
                f'reinvest_dividends={(self.reinvest_dividends if hasattr(self, "reinvest_dividends") else None)!s}, '
                f'reinvest_capital_gains={(self.reinvest_capital_gains if hasattr(self, "reinvest_capital_gains") else None)!s}, '
                f'myield={(self.myield if hasattr(self, "myield") else None)!s}, '
                f'yield_as_of_date={(self.yield_as_of_date if hasattr(self, "yield_as_of_date") else None)!s})')

class OptionSecurityEntity(SecurityEntity):

    """Implementation of the 'Option Security entity' model.

    An option
    NOTE: This class inherits from 'SecurityEntity'.

    Attributes:
        secured (Secured2): How the option is secured. One of NAKED, COVERED
        option_type (OptionType2): Option type. One of PUT, CALL
        strike_price (float): Strike price / Unit price
        expire_date (date): Expiration date of option
        shares_per_contract (float): Shares per contract
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "secured": 'secured',
        "option_type": 'optionType',
        "strike_price": 'strikePrice',
        "expire_date": 'expireDate',
        "shares_per_contract": 'sharesPerContract',
        "security_category": 'securityCategory'
    }

    _optionals = [
        'secured',
        'option_type',
        'strike_price',
        'expire_date',
        'shares_per_contract',
    ]
    _optionals.extend(SecurityEntity._optionals)

    def __init__(self,
                 secured=APIHelper.SKIP,
                 option_type=APIHelper.SKIP,
                 strike_price=APIHelper.SKIP,
                 expire_date=APIHelper.SKIP,
                 shares_per_contract=APIHelper.SKIP,
                 security_category='Option Security entity',
                 additional_properties=None):
        """Constructor for the OptionSecurityEntity class"""

        # Initialize members of the class
        if secured is not APIHelper.SKIP:
            self.secured = secured 
        if option_type is not APIHelper.SKIP:
            self.option_type = option_type 
        if strike_price is not APIHelper.SKIP:
            self.strike_price = strike_price 
        if expire_date is not APIHelper.SKIP:
            self.expire_date = expire_date 
        if shares_per_contract is not APIHelper.SKIP:
            self.shares_per_contract = shares_per_contract 

        # Call the constructor for the base class
        super(OptionSecurityEntity, self).__init__(security_category,
                                                   additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        secured = dictionary.get("secured") if dictionary.get("secured") else APIHelper.SKIP
        option_type = dictionary.get("optionType") if dictionary.get("optionType") else APIHelper.SKIP
        strike_price = dictionary.get("strikePrice") if dictionary.get("strikePrice") else APIHelper.SKIP
        expire_date = dateutil.parser.parse(dictionary.get('expireDate')).date() if dictionary.get('expireDate') else APIHelper.SKIP
        shares_per_contract = dictionary.get("sharesPerContract") if dictionary.get("sharesPerContract") else APIHelper.SKIP
        security_category = dictionary.get("securityCategory") if dictionary.get("securityCategory") else 'Option Security entity'
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(secured,
                   option_type,
                   strike_price,
                   expire_date,
                   shares_per_contract,
                   security_category,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'secured={(self.secured if hasattr(self, "secured") else None)!r}, '
                f'option_type={(self.option_type if hasattr(self, "option_type") else None)!r}, '
                f'strike_price={(self.strike_price if hasattr(self, "strike_price") else None)!r}, '
                f'expire_date={(self.expire_date if hasattr(self, "expire_date") else None)!r}, '
                f'shares_per_contract={(self.shares_per_contract if hasattr(self, "shares_per_contract") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'secured={(self.secured if hasattr(self, "secured") else None)!s}, '
                f'option_type={(self.option_type if hasattr(self, "option_type") else None)!s}, '
                f'strike_price={(self.strike_price if hasattr(self, "strike_price") else None)!s}, '
                f'expire_date={(self.expire_date if hasattr(self, "expire_date") else None)!s}, '
                f'shares_per_contract={(self.shares_per_contract if hasattr(self, "shares_per_contract") else None)!s})')

class OtherSecurityEntity(SecurityEntity):

    """Implementation of the 'Other Security entity' model.

    Any other kind of security
    NOTE: This class inherits from 'SecurityEntity'.

    Attributes:
        type_description (str): Description of other security
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "type_description": 'typeDescription',
        "security_category": 'securityCategory'
    }

    _optionals = [
        'type_description',
    ]
    _optionals.extend(SecurityEntity._optionals)

    def __init__(self,
                 type_description=APIHelper.SKIP,
                 security_category='Other Security entity',
                 additional_properties=None):
        """Constructor for the OtherSecurityEntity class"""

        # Initialize members of the class
        if type_description is not APIHelper.SKIP:
            self.type_description = type_description 

        # Call the constructor for the base class
        super(OtherSecurityEntity, self).__init__(security_category,
                                                  additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        type_description = dictionary.get("typeDescription") if dictionary.get("typeDescription") else APIHelper.SKIP
        security_category = dictionary.get("securityCategory") if dictionary.get("securityCategory") else 'Other Security entity'
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(type_description,
                   security_category,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'type_description={(self.type_description if hasattr(self, "type_description") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'type_description={(self.type_description if hasattr(self, "type_description") else None)!s})')

class StockSecurityEntity(SecurityEntity):

    """Implementation of the 'Stock Security entity' model.

    A stock security
    NOTE: This class inherits from 'SecurityEntity'.

    Attributes:
        units_street (float): The units in the FI's street name as a positive
            quantity
        units_user (float): The units in user's name directly as a positive
            quantity
        reinvest_dividends (bool): Selection to reinvest dividends
        stock_type (StockType2): COMMON, PREFERRED, CONVERTIBLE, OTHER
        myield (float): The current yield
        yield_as_of_date (date): Yield as-of date
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "units_street": 'unitsStreet',
        "units_user": 'unitsUser',
        "reinvest_dividends": 'reinvestDividends',
        "stock_type": 'stockType',
        "myield": 'yield',
        "yield_as_of_date": 'yieldAsOfDate',
        "security_category": 'securityCategory'
    }

    _optionals = [
        'units_street',
        'units_user',
        'reinvest_dividends',
        'stock_type',
        'myield',
        'yield_as_of_date',
    ]
    _optionals.extend(SecurityEntity._optionals)

    def __init__(self,
                 units_street=APIHelper.SKIP,
                 units_user=APIHelper.SKIP,
                 reinvest_dividends=APIHelper.SKIP,
                 stock_type=APIHelper.SKIP,
                 myield=APIHelper.SKIP,
                 yield_as_of_date=APIHelper.SKIP,
                 security_category='Stock Security entity',
                 additional_properties=None):
        """Constructor for the StockSecurityEntity class"""

        # Initialize members of the class
        if units_street is not APIHelper.SKIP:
            self.units_street = units_street 
        if units_user is not APIHelper.SKIP:
            self.units_user = units_user 
        if reinvest_dividends is not APIHelper.SKIP:
            self.reinvest_dividends = reinvest_dividends 
        if stock_type is not APIHelper.SKIP:
            self.stock_type = stock_type 
        if myield is not APIHelper.SKIP:
            self.myield = myield 
        if yield_as_of_date is not APIHelper.SKIP:
            self.yield_as_of_date = yield_as_of_date 

        # Call the constructor for the base class
        super(StockSecurityEntity, self).__init__(security_category,
                                                  additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        units_street = dictionary.get("unitsStreet") if dictionary.get("unitsStreet") else APIHelper.SKIP
        units_user = dictionary.get("unitsUser") if dictionary.get("unitsUser") else APIHelper.SKIP
        reinvest_dividends = dictionary.get("reinvestDividends") if "reinvestDividends" in dictionary.keys() else APIHelper.SKIP
        stock_type = dictionary.get("stockType") if dictionary.get("stockType") else APIHelper.SKIP
        myield = dictionary.get("yield") if dictionary.get("yield") else APIHelper.SKIP
        yield_as_of_date = dateutil.parser.parse(dictionary.get('yieldAsOfDate')).date() if dictionary.get('yieldAsOfDate') else APIHelper.SKIP
        security_category = dictionary.get("securityCategory") if dictionary.get("securityCategory") else 'Stock Security entity'
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(units_street,
                   units_user,
                   reinvest_dividends,
                   stock_type,
                   myield,
                   yield_as_of_date,
                   security_category,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'units_street={(self.units_street if hasattr(self, "units_street") else None)!r}, '
                f'units_user={(self.units_user if hasattr(self, "units_user") else None)!r}, '
                f'reinvest_dividends={(self.reinvest_dividends if hasattr(self, "reinvest_dividends") else None)!r}, '
                f'stock_type={(self.stock_type if hasattr(self, "stock_type") else None)!r}, '
                f'myield={(self.myield if hasattr(self, "myield") else None)!r}, '
                f'yield_as_of_date={(self.yield_as_of_date if hasattr(self, "yield_as_of_date") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'units_street={(self.units_street if hasattr(self, "units_street") else None)!s}, '
                f'units_user={(self.units_user if hasattr(self, "units_user") else None)!s}, '
                f'reinvest_dividends={(self.reinvest_dividends if hasattr(self, "reinvest_dividends") else None)!s}, '
                f'stock_type={(self.stock_type if hasattr(self, "stock_type") else None)!s}, '
                f'myield={(self.myield if hasattr(self, "myield") else None)!s}, '
                f'yield_as_of_date={(self.yield_as_of_date if hasattr(self, "yield_as_of_date") else None)!s})')

class SweepSecurityEntity(SecurityEntity):

    """Implementation of the 'Sweep Security entity' model.

    A sweep security
    NOTE: This class inherits from 'SecurityEntity'.

    Attributes:
        current_balance (float): Balance of funds in account
        available_balance (float): Balance of funds available for use
        balance_as_of (datetime): As-of date of balances
        checks (bool): Whether or not checks can be written on the account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "current_balance": 'currentBalance',
        "available_balance": 'availableBalance',
        "balance_as_of": 'balanceAsOf',
        "checks": 'checks',
        "security_category": 'securityCategory'
    }

    _optionals = [
        'current_balance',
        'available_balance',
        'balance_as_of',
        'checks',
    ]
    _optionals.extend(SecurityEntity._optionals)

    def __init__(self,
                 current_balance=APIHelper.SKIP,
                 available_balance=APIHelper.SKIP,
                 balance_as_of=APIHelper.SKIP,
                 checks=APIHelper.SKIP,
                 security_category='Sweep Security entity',
                 additional_properties=None):
        """Constructor for the SweepSecurityEntity class"""

        # Initialize members of the class
        if current_balance is not APIHelper.SKIP:
            self.current_balance = current_balance 
        if available_balance is not APIHelper.SKIP:
            self.available_balance = available_balance 
        if balance_as_of is not APIHelper.SKIP:
            self.balance_as_of = APIHelper.apply_datetime_converter(balance_as_of, APIHelper.RFC3339DateTime) if balance_as_of else None 
        if checks is not APIHelper.SKIP:
            self.checks = checks 

        # Call the constructor for the base class
        super(SweepSecurityEntity, self).__init__(security_category,
                                                  additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        current_balance = dictionary.get("currentBalance") if dictionary.get("currentBalance") else APIHelper.SKIP
        available_balance = dictionary.get("availableBalance") if dictionary.get("availableBalance") else APIHelper.SKIP
        balance_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("balanceAsOf")).datetime if dictionary.get("balanceAsOf") else APIHelper.SKIP
        checks = dictionary.get("checks") if "checks" in dictionary.keys() else APIHelper.SKIP
        security_category = dictionary.get("securityCategory") if dictionary.get("securityCategory") else 'Sweep Security entity'
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(current_balance,
                   available_balance,
                   balance_as_of,
                   checks,
                   security_category,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'current_balance={(self.current_balance if hasattr(self, "current_balance") else None)!r}, '
                f'available_balance={(self.available_balance if hasattr(self, "available_balance") else None)!r}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!r}, '
                f'checks={(self.checks if hasattr(self, "checks") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'current_balance={(self.current_balance if hasattr(self, "current_balance") else None)!s}, '
                f'available_balance={(self.available_balance if hasattr(self, "available_balance") else None)!s}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!s}, '
                f'checks={(self.checks if hasattr(self, "checks") else None)!s})')
