# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class SecurityIdEntity(object):

    """Implementation of the 'Security ID entity' model.

    Unique identifier for a security

    Attributes:
        id (str): Security identifier
        id_type (SecurityIdType1): CINS, CMC, CME, CUSIP, ISIN, ITSA, NASDAQ,
            SEDOL, SICC, VALOR, WKN
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "id_type": 'idType'
    }

    _optionals = [
        'id',
        'id_type',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 id_type=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the SecurityIdEntity class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if id_type is not APIHelper.SKIP:
            self.id_type = id_type 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        id_type = dictionary.get("idType") if dictionary.get("idType") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(id,
                   id_type,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'id={(self.id if hasattr(self, "id") else None)!r}, '
                f'id_type={(self.id_type if hasattr(self, "id_type") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'id={(self.id if hasattr(self, "id") else None)!s}, '
                f'id_type={(self.id_type if hasattr(self, "id_type") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
