# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.hateoas_link import HateoasLink


class StatementEntity(object):

    """Implementation of the 'Statement entity' model.

    An account statement

    Attributes:
        account_id (str): Corresponds to accountId in Account entity
        statement_id (str): Long-term persistent identity of the statement
        statement_date (date): Date of the statement
        description (str): Description of statement
        links (List[HateoasLink]): The links to retrieve this account
            statement, or to invoke other APIs
        status (DocumentStatus2): Availability status of statement
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_id": 'accountId',
        "statement_id": 'statementId',
        "statement_date": 'statementDate',
        "description": 'description',
        "links": 'links',
        "status": 'status'
    }

    _optionals = [
        'account_id',
        'statement_id',
        'statement_date',
        'description',
        'links',
        'status',
    ]

    def __init__(self,
                 account_id=APIHelper.SKIP,
                 statement_id=APIHelper.SKIP,
                 statement_date=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the StatementEntity class"""

        # Initialize members of the class
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if statement_id is not APIHelper.SKIP:
            self.statement_id = statement_id 
        if statement_date is not APIHelper.SKIP:
            self.statement_date = statement_date 
        if description is not APIHelper.SKIP:
            self.description = description 
        if links is not APIHelper.SKIP:
            self.links = links 
        if status is not APIHelper.SKIP:
            self.status = status 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        statement_id = dictionary.get("statementId") if dictionary.get("statementId") else APIHelper.SKIP
        statement_date = dateutil.parser.parse(dictionary.get('statementDate')).date() if dictionary.get('statementDate') else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(account_id,
                   statement_id,
                   statement_date,
                   description,
                   links,
                   status,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'statement_id={(self.statement_id if hasattr(self, "statement_id") else None)!r}, '
                f'statement_date={(self.statement_date if hasattr(self, "statement_date") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'statement_id={(self.statement_id if hasattr(self, "statement_id") else None)!s}, '
                f'statement_date={(self.statement_date if hasattr(self, "statement_date") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
